/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.guard.foldex.utils;

import com.zkteco.guard.foldex.helper.AesHelper;
import com.zkteco.guard.foldex.helper.ECIES256Helper;
import com.zkteco.guard.foldex.helper.HexHelper;
import com.zkteco.guard.foldex.helper.MD5Helper;
import com.zkteco.guard.foldex.helper.RsaHelper;
import com.zkteco.guard.foldex.helper.Sha256Helper;
import com.zkteco.zkbiosecurity.guard.foldex.constant.EncryptEnum;
import java.io.InputStream;
import java.security.KeyPair;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoldexUtil {
    public static byte[] decryptDev(byte[] encrypt) throws Exception {
        try {
            return AesHelper.decryptDev((byte[])encrypt);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] decryptPro(byte[] encrypt) {
        try {
            return AesHelper.decryptPro((byte[])encrypt);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encryptPro(byte[] encrypt, byte type) {
        try {
            return AesHelper.encrypt((byte[])encrypt, (byte)type);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decryptInstallDate(String decrypt) {
        try {
            byte[] bytes = AesHelper.decryptInstallDate((byte[])Base64.getDecoder().decode(decrypt.getBytes("UTF-8")));
            return new String(bytes, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encryptInstallDate(String encrypt) {
        try {
            byte[] bytes = Base64.getEncoder().encode(AesHelper.encryptInstallDate((byte[])encrypt.getBytes("UTF-8")));
            return new String(bytes, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encrypt(String key, String initVector, String encrypt) {
        try {
            byte[] keyByte = MD5Helper.encrypt((String)key);
            byte[] ivByte = MD5Helper.encrypt((String)initVector);
            byte[] encryptByte = encrypt.getBytes("UTF-8");
            return HexHelper.bytesToHexString((byte[])AesHelper.encrypt((byte[])encryptByte, (byte[])keyByte, (byte[])ivByte));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decrypt(String key, String initVector, String decrypt) throws Exception {
        byte[] decryptBytes = AesHelper.decryptCommon((String)key, (String)initVector, (byte[])HexHelper.hexStringToBytes((String)decrypt));
        return new String(decryptBytes, "UTF-8");
    }

    public static String md5Encrypt32(String encryptStr) {
        return MD5Helper.encrypt32((String)encryptStr);
    }

    public static byte[] encryptRandom(String encryptStr) throws Exception {
        return AesHelper.encryptRandom((String)encryptStr);
    }

    public static byte[] encryptRandom(InputStream sourceFile) throws Exception {
        return AesHelper.encryptRandom((InputStream)sourceFile);
    }

    public static byte[] decryptRandom(InputStream sourceFile) throws Exception {
        return AesHelper.decryptRandom((InputStream)sourceFile);
    }

    public static String decryptRandomString(String decrypt) {
        try {
            byte[] bytes = AesHelper.decryptRandomByBytes((byte[])Base64.getDecoder().decode(decrypt.getBytes("UTF-8")));
            return new String(bytes, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encryptRandomString(String encrypt) {
        try {
            byte[] bytes = Base64.getEncoder().encode(AesHelper.encryptRandom((String)encrypt));
            return new String(bytes, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encryptByRandomSey(String encrypt) {
        String randomSey;
        if (!"".equals(encrypt) && encrypt != null && !"".equals(randomSey = System.getProperty("system.security.randomsey")) && randomSey != null) {
            try {
                if (encrypt.startsWith(EncryptEnum.ENCRYPT_AES256_PREFIX.getValue())) {
                    return encrypt;
                }
                randomSey = FoldexUtil.decryptRandomString(randomSey);
                String randomIv = randomSey.substring(8, 24);
                byte[] keyByte = randomSey.getBytes("UTF-8");
                byte[] ivByte = randomIv.getBytes("UTF-8");
                byte[] encryptByte = encrypt.getBytes("UTF-8");
                byte[] bytes = Base64.getEncoder().encode(AesHelper.encrypt((byte[])encryptByte, (byte[])keyByte, (byte[])ivByte));
                encrypt = EncryptEnum.ENCRYPT_AES256_PREFIX.getValue() + new String(bytes, "UTF-8");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return encrypt;
    }

    public static String decryptByRandomSey(String decrypt) {
        String randomSey;
        if (!"".equals(decrypt) && decrypt != null && !"".equals(randomSey = System.getProperty("system.security.randomsey")) && randomSey != null && decrypt.startsWith(EncryptEnum.ENCRYPT_AES256_PREFIX.getValue())) {
            randomSey = FoldexUtil.decryptRandomString(randomSey);
            String randomIv = randomSey.substring(8, 24);
            try {
                decrypt = decrypt.replace(EncryptEnum.ENCRYPT_AES256_PREFIX.getValue(), "");
                byte[] decryptBytes = AesHelper.decryptNative((byte[])Base64.getDecoder().decode(decrypt.getBytes("UTF-8")), (byte[])randomSey.getBytes("UTF-8"), (byte[])randomIv.getBytes("UTF-8"));
                decrypt = new String(decryptBytes, "UTF-8");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return decrypt;
    }

    public static byte[] encryptRandomWithType(InputStream sourceFile) throws Exception {
        return AesHelper.encryptRandomWithType((InputStream)sourceFile, (String)EncryptEnum.ENCRYPT_AES256_PREFIX.getValue());
    }

    public static byte[] decryptRandomWithType(InputStream sourceFile) throws Exception {
        return AesHelper.decryptRandomWithType((InputStream)sourceFile, (String)EncryptEnum.ENCRYPT_AES256_PREFIX.getValue());
    }

    public static String encryptAESB64(String key, String initVector, String encrypt) {
        try {
            byte[] bytes = Base64.getEncoder().encode(AesHelper.encrypt((byte[])encrypt.getBytes(), (byte[])key.getBytes(), (byte[])initVector.getBytes()));
            return new String(bytes, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decryptAESB64(String key, String initVector, String decrypt) {
        try {
            byte[] bytes = AesHelper.decryptNative((byte[])Base64.getDecoder().decode(decrypt.getBytes("UTF-8")), (byte[])key.getBytes(), (byte[])initVector.getBytes());
            return new String(bytes, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encryptAESHex(String key, String initVector, String encrypt) {
        try {
            return HexHelper.bytesToHexString((byte[])AesHelper.encrypt((byte[])encrypt.getBytes(), (byte[])key.getBytes(), (byte[])initVector.getBytes()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decryptAESHex(String key, String initVector, String decrypt) {
        try {
            byte[] bytes = AesHelper.decryptNative((byte[])HexHelper.hexStringToBytes((String)decrypt), (byte[])key.getBytes(), (byte[])initVector.getBytes());
            return new String(bytes, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> getRSA1024KeyPair() {
        try {
            return FoldexUtil.getRSASizeKeyPair(1024);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> getRSASizeKeyPair(int rsaKeySize) {
        try {
            HashMap<String, String> keyPairMap = new HashMap<String, String>();
            KeyPair keyPair = RsaHelper.getKeyPair((int)rsaKeySize);
            keyPairMap.put("PrivateKey", RsaHelper.getPrivateKey((KeyPair)keyPair));
            keyPairMap.put("PublicKey", RsaHelper.getPublicKey((KeyPair)keyPair));
            return keyPairMap;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encryptRSAB64PubKey(String publicKey, String encrypt) {
        try {
            return RsaHelper.encrypt((String)encrypt, (String)publicKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decryptRSAB64PriKey(String privateKey, String encrypt) {
        try {
            return RsaHelper.decrypt((String)encrypt, (String)privateKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encryptRSAB64PriKey(String privateKey, String encrypt) {
        try {
            return RsaHelper.encryptByPrivateKey((String)encrypt, (String)privateKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decryptRSAB64PubKey(String publicKey, String encrypt) {
        try {
            return RsaHelper.decryptByPublicKey((String)encrypt, (String)publicKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encryptSHAHex(String encrypt) {
        try {
            return Sha256Helper.encrypt((String)encrypt);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encryptSHAB64(String encrypt) {
        try {
            return Sha256Helper.encryptB64((String)encrypt);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encryptHMACSHA256(String encrypt, String secret) {
        try {
            return Sha256Helper.encryptHMACSHA256((String)encrypt, (String)secret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encryptHMACSHA256(byte[] encrypt, String secret) {
        try {
            return Sha256Helper.encryptHMACSHA256((byte[])encrypt, (String)secret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encryptHMACSHA256B64(String encrypt, String secret) {
        try {
            return Sha256Helper.encryptHMACSHA256B64((String)encrypt, (String)secret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encryptFileWithType(InputStream sourceFile, String key, String iv) {
        try {
            if (!"".equals(key) && key != null && !"".equals(iv) && iv != null) {
                return AesHelper.encryptFileWithType((InputStream)sourceFile, (byte[])key.getBytes("UTF-8"), (byte[])iv.getBytes("UTF-8"), (String)EncryptEnum.ENCRYPT_AES256_PREFIX.getValue());
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] decryptFileWithType(InputStream encryptFile, String key, String iv) {
        try {
            if (!"".equals(key) && key != null && !"".equals(iv) && iv != null) {
                return AesHelper.decryptFileWithType((InputStream)encryptFile, (byte[])key.getBytes("UTF-8"), (byte[])iv.getBytes("UTF-8"), (String)EncryptEnum.ENCRYPT_AES256_PREFIX.getValue());
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> getGenerateECIES256Key() {
        try {
            return ECIES256Helper.getGenerateKey();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encryptECIES256B64PubKey(String publicKey, String encrypt) {
        try {
            return ECIES256Helper.encrypt((String)encrypt, (String)publicKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decryptECIES256B64PriKey(String privateKey, String encrypt) {
        try {
            return ECIES256Helper.decrypt((String)encrypt, (String)privateKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

