/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.init;

import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryService;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryValueService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=998)
public class AdmsInit
implements CommandLineRunner {
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private BaseDictionaryService baseDictionaryService;
    @Autowired
    private BaseDictionaryValueService baseDictionaryValueService;
    @Value(value="${system.language:zh_CN}")
    private String language;

    public void run(String ... args) throws Exception {
        AuthPermissionItem admsMenu;
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("AdmsInit");
        if (!alreadyInit && (admsMenu = this.authPermissionService.getItemByCode("AdmsManager")) != null) {
            alreadyInit = true;
            this.baseSysParamService.setAlreadyInitModule("AdmsInit");
        }
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initAdmsParams();
            this.initUpgradeVersion();
            this.baseSysParamService.setAlreadyInitModule("AdmsInit");
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem systemItem = new AuthPermissionItem("System", "system_module", "system", "system", "true", Integer.valueOf(998));
        systemItem = this.authPermissionService.initData(systemItem);
        AuthPermissionItem subMenuItem1 = new AuthPermissionItem("AdmsManager", "adms_manager", "adms:manager", "menu", "true", Integer.valueOf(3));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setImg("base_commManage.png");
        subMenuItem1.setImgHover("base_commManage_over.png");
        subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        AuthPermissionItem subMenuItem = new AuthPermissionItem("AdmsDevCmd", "adms_devCmd_entity", "adms:devCmd", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("admsDevCmd.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        AuthPermissionItem subButtonItem = new AuthPermissionItem("AdmsDevCmdRefresh", "common_op_refresh", "adms:devCmd:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AdmsDevCmdClearCmd", "adms_devCmd_clearCmd", "adms:devCmd:clearCmd", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AdmsDevCmdExport", "common_op_export", "adms:devCmd:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AdmsDevice", "adms_device", "adms:device", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("admsDevice.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AdmsDeviceRefresh", "common_op_refresh", "adms:device:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AdmsDeviceDel", "common_op_del", "adms:device:del", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AdmsDeviceAdd", "common_op_new", "adms:device:add", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AdmsDeviceAuthSearch", "adms_device_authSearch", "adms:device:authSearch", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        if ("zh_CN".equals(this.language)) {
            subButtonItem = new AuthPermissionItem("AdmsDeviceProjectCtrl", "adms_projectDevCtrl_import", "adms:device:devCtrlImport", "button", "true", Integer.valueOf(6));
            subButtonItem.setParentId(subMenuItem.getId());
            this.authPermissionService.initData(subButtonItem);
        }
        subMenuItem = new AuthPermissionItem("AdmsMonitor", "adms_monitor", "adms:params", "menu", "true", Integer.valueOf(8));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("admsParams.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AdmsMonitorRefresh", "common_op_refresh", "adms:params:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AdmsProduct", "adms_product_title", "adms:product", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("admsProduct.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AdmsProductRefresh", "common_op_refresh", "adms:product:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AdmsProductAdd", "common_op_new", "adms:product:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AdmsProductDelete", "common_op_del", "adms:product:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AdmsProductEdit", "common_op_edit", "adms:product:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subMenuItem = new AuthPermissionItem("AdmsAuthDevice", "adms_auth_device", "adms:authDevice", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("admsAuthDevice.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
        subButtonItem = new AuthPermissionItem("AdmsAuthDeviceRefresh", "common_op_refresh", "adms:authDevice:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AdmsAuthDeviceAdd", "common_op_new", "adms:authDevice:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AdmsAuthDeviceDel", "common_op_del", "adms:authDevice:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AdmsAuthDeviceEdit", "common_op_edit", "adms:authDevice:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
        subButtonItem = new AuthPermissionItem("AdmsAuthDeviceExport", "adms_authDev_export", "adms:authDevice:export", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
    }

    private void initAdmsParams() {
        this.baseSysParamService.initData(new BaseSysParamItem("adms.encrypted.transmission", "1", "\u662f\u5426\u5f00\u542f\u52a0\u5bc6\u4f20\u8f93"));
    }

    private void initUpgradeVersion() {
        String curVersion = VersionUtil.getReleaseGitTags((String)"adms");
        if (StringUtils.isNotBlank((CharSequence)curVersion)) {
            BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName("AdmsUpgradeVersion");
            if (StringUtils.isBlank((CharSequence)baseSysParamItem.getId())) {
                baseSysParamItem = new BaseSysParamItem("AdmsUpgradeVersion", curVersion, "Adms Upgrade Version", Boolean.valueOf(true));
            }
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }
}

