/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.mid.init;

import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.mid.constant.MidConstant;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=300)
public class MidInit
implements CommandLineRunner {
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private AuthPermissionService authPermissionService;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("MidInit");
        if (!alreadyInit) {
            this.initLicenseProvider();
            this.initAuthPermission();
            this.initUpgradeVersion();
            this.baseSysParamService.setAlreadyInitModule("MidInit");
        }
    }

    private void initUpgradeVersion() {
        String curVersion = VersionUtil.getReleaseGitTags((String)MidConstant.MID);
        if (StringUtils.isNotBlank((CharSequence)curVersion)) {
            BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName(MidConstant.MID_UPGRADE_VERSION);
            if (StringUtils.isBlank((CharSequence)baseSysParamItem.getId())) {
                baseSysParamItem = new BaseSysParamItem(MidConstant.MID_UPGRADE_VERSION, curVersion, "Mid Upgrade Version", Boolean.valueOf(true));
            }
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }

    private void initLicenseProvider() {
        BaseSysParamItem item10 = new BaseSysParamItem("middletable.version", "true", "Middle Table", Boolean.valueOf(true));
        this.baseSysParamService.initData(item10);
    }

    private void initAuthPermission() {
        AuthPermissionItem systemItem = new AuthPermissionItem("System", "system_module", "system", "system", "true", Integer.valueOf(999));
        systemItem = this.authPermissionService.initData(systemItem);
        AuthPermissionItem subMenuItem1 = new AuthPermissionItem("ThirdPartyDocking", "base_leftMenu_thirdParty", "third:party:docking", "menu", "true", Integer.valueOf(4));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setImg("base_extendManage.png");
        subMenuItem1.setImgHover("base_extendManage_over.png");
        subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        AuthPermissionItem subMenuItem = new AuthPermissionItem("MidData", "auth_license_middletable", "mid:data", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("/midData.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        AuthPermissionItem subButtonItem = new AuthPermissionItem("MidDataRefresh", "common_op_refresh", "mid:data:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        this.authPermissionService.initData(subButtonItem);
    }
}

