/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.utils;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.itextpdf.text.Document;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class IvsExcelUtil {
    private static final Logger loger = LoggerFactory.getLogger(ExcelUtil.class);
    public static final String XLS = "xls";
    public static final String XLSX = "xlsx";
    public static final String XSLM = "xlsm";
    public static final String PDF = "pdf";
    public static final String CSV = "csv";
    public static final String TXT = "txt";

    public static <T> void excelExport(List<T> list, Class<T> cls, String jsonColumn, String fileName, OutputStream outputStream, String reportType, Map<String, Map<String, String>> map, Map<String, String> addReportDetailMap) throws IOException {
        BufferedOutputStream ops = new BufferedOutputStream(outputStream, 8192);
        Object workbook = null;
        workbook = XLS.equals(reportType) ? new HSSFWorkbook() : new XSSFWorkbook();
        Sheet sheet = workbook.createSheet(fileName);
        Drawing patriarch = sheet.createDrawingPatriarch();
        JSONObject jsonObject = JSONObject.parseObject((String)jsonColumn, (Feature[])new Feature[]{Feature.OrderedField});
        Object extraDataMap = new LinkedMap();
        ArrayList<Object> fieldList = new ArrayList<Object>();
        String extraDataName = "";
        try {
            for (String s : jsonObject.keySet()) {
                Field field = cls.getDeclaredField(s);
                field.setAccessible(true);
                if (field.getAnnotation(GridColumn.class) != null && !field.getAnnotation(GridColumn.class).isExportExcel()) continue;
                if ("java.util.Map".equals(cls.getDeclaredField(s).getType().getTypeName())) {
                    extraDataMap = (Map)field.get(list.get(0));
                    extraDataName = s;
                    for (Map.Entry entry : extraDataMap.entrySet()) {
                        fieldList.add(entry.getKey());
                    }
                    continue;
                }
                fieldList.add(s);
            }
            CellStyle headStyle = workbook.createCellStyle();
            Font headFont = workbook.createFont();
            headFont.setFontName("ARIAL");
            headFont.setFontHeightInPoints((short)10);
            headFont.setBold(true);
            headStyle.setFont(headFont);
            headStyle.setAlignment(HorizontalAlignment.CENTER);
            headStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            CellStyle dataStyle = workbook.createCellStyle();
            dataStyle.setBorderBottom(BorderStyle.THIN);
            dataStyle.setBorderLeft(BorderStyle.THIN);
            dataStyle.setBorderTop(BorderStyle.THIN);
            dataStyle.setBorderRight(BorderStyle.THIN);
            dataStyle.setWrapText(true);
            dataStyle.setAlignment(HorizontalAlignment.CENTER);
            dataStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            Row row = sheet.createRow(0);
            Cell cell = row.createCell(0);
            cell.setCellStyle(headStyle);
            cell.setCellValue(fileName);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, fieldList.size() - 1));
            int isMergedRegion = 0;
            Row columnRow = null;
            Row columnRow3 = null;
            if (addReportDetailMap == null || addReportDetailMap.size() == 0) {
                isMergedRegion = 2;
                columnRow = sheet.createRow(1);
                columnRow3 = sheet.createRow(2);
            } else {
                isMergedRegion = 15;
                columnRow = sheet.createRow(14);
                columnRow3 = sheet.createRow(15);
            }
            int mergedRow = 0;
            int mergedRowj = 0;
            for (int i = 0; i < fieldList.size(); ++i) {
                CellRangeAddress region;
                String width = "";
                String columValue = "";
                String secHeader = "";
                if (!extraDataMap.containsKey(fieldList.get(i))) {
                    width = cls.getDeclaredField((String)fieldList.get(i)).getAnnotation(GridColumn.class).width();
                    columValue = cls.getDeclaredField((String)fieldList.get(i)).getAnnotation(GridColumn.class).label();
                    secHeader = cls.getDeclaredField((String)fieldList.get(i)).getAnnotation(GridColumn.class).secHeader();
                } else {
                    width = "90";
                    columValue = (String)fieldList.get(i);
                }
                if (StringUtils.isEmpty((Object)columValue)) {
                    columValue = cls.getDeclaredField((String)fieldList.get(i)).getName();
                }
                if (!StringUtils.isEmpty((Object)width) && !"*".equals(width)) {
                    sheet.setColumnWidth(i, 50 * Integer.parseInt(width));
                }
                Cell columCell = columnRow.createCell(i);
                if (!"".equals(secHeader) && !"#cspan".equals(columValue)) {
                    Cell columCell3 = columnRow3.createCell(i);
                    columCell3.setCellStyle(dataStyle);
                    columCell3.setCellValue(I18nUtil.i18nCode((String)secHeader, (Object[])new Object[0]));
                }
                if (!"".equals(secHeader) && "#cspan".equals(columValue)) {
                    ++mergedRow;
                    ++mergedRowj;
                    columCell = columnRow3.createCell(i);
                    columValue = secHeader;
                    isMergedRegion = 3;
                } else {
                    if (mergedRowj != 0) {
                        region = new CellRangeAddress(1, 1, i - mergedRowj - 1, i - 1);
                        sheet.addMergedRegion(region);
                        IvsExcelUtil.setBorderStyle(BorderStyle.THIN, region, sheet);
                    }
                    mergedRowj = 0;
                }
                if (mergedRowj != 0 && i == fieldList.size() - 1) {
                    region = new CellRangeAddress(1, 1, i - mergedRowj, i);
                    sheet.addMergedRegion(region);
                    IvsExcelUtil.setBorderStyle(BorderStyle.THIN, region, sheet);
                }
                if ("".equals(secHeader) && mergedRow != 0) {
                    region = new CellRangeAddress(1, 2, i, i);
                    sheet.addMergedRegion(region);
                    IvsExcelUtil.setBorderStyle(BorderStyle.THIN, region, sheet);
                }
                columCell.setCellStyle(dataStyle);
                columCell.setCellValue(I18nUtil.i18nCode((String)columValue, (Object[])new Object[0]));
            }
            String cellValue = "";
            CreationHelper creationHelper = workbook.getCreationHelper();
            for (int i = 0; i < list.size(); ++i) {
                Row dataRows = sheet.createRow(i + isMergedRegion);
                for (int j = 0; j < fieldList.size(); ++j) {
                    Field field;
                    Cell dataCell = dataRows.createCell(j);
                    dataCell.setCellStyle(dataStyle);
                    if (!extraDataMap.containsKey(fieldList.get(j))) {
                        field = cls.getDeclaredField((String)fieldList.get(j));
                        field.setAccessible(true);
                        Object cellObject = field.get(list.get(i));
                        if (IvsExcelUtil.checkImg(field.getName()) && cellObject != null) {
                            Object bufferedImage = null;
                            try {
                                HSSFClientAnchor anchor;
                                dataRows.setHeight((short)2048);
                                byte[] decode = Base64.getDecoder().decode(String.valueOf(cellObject));
                                if (XLS.equals(reportType)) {
                                    anchor = new HSSFClientAnchor(0, 2, 2, 255, (short)j, i + isMergedRegion, (short)(j + 1), i + isMergedRegion);
                                    anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
                                    patriarch.createPicture((ClientAnchor)anchor, workbook.addPicture(decode, 5));
                                } else {
                                    anchor = new XSSFClientAnchor(0, 2, 2, 255, (int)((short)j), i + isMergedRegion, (int)((short)(j + 1)), i + isMergedRegion);
                                    Picture picture = patriarch.createPicture((ClientAnchor)anchor, workbook.addPicture(decode, 5));
                                    picture.resize(1.0, 1.0);
                                }
                                cellObject = null;
                            }
                            catch (Exception e) {
                                loger.error("", (Throwable)e);
                            }
                        }
                        if (!StringUtils.isEmpty((Object)cellObject)) {
                            if (field.getType() == Date.class || field.getType() == Timestamp.class) {
                                DateType dateType = field.getAnnotation(DateType.class);
                                String format = IvsExcelUtil.getDateFormt(dateType);
                                cellValue = new SimpleDateFormat(format).format(cellObject);
                            } else if (map != null && map.containsKey(field.getName())) {
                                cellValue = String.valueOf(cellObject);
                                if (map.get(field.getName()).containsKey(cellValue)) {
                                    cellValue = I18nUtil.i18nCode((String)map.get(field.getName()).get(cellValue), (Object[])new Object[0]);
                                }
                            } else {
                                cellValue = String.valueOf(cellObject);
                                if (field.getAnnotation(GridColumn.class).i18n()) {
                                    cellValue = I18nUtil.i18nCode((String)cellValue, (Object[])new Object[0]);
                                }
                                if (!StringUtils.isEmpty((Object)field.getAnnotation(GridColumn.class).format())) {
                                    cellValue = I18nUtil.i18nCode((String)GridUtil.getDictionaryVal((String)field.getAnnotation(GridColumn.class).format(), (Object)cellValue), (Object[])new Object[0]);
                                }
                            }
                        } else {
                            cellValue = "";
                        }
                    } else {
                        field = cls.getDeclaredField(extraDataName);
                        field.setAccessible(true);
                        Map extraDataMaps = (Map)field.get(list.get(i));
                        cellValue = String.valueOf(extraDataMaps.get(fieldList.get(j)));
                    }
                    dataCell.setCellValue(cellValue);
                    if (!StringUtils.isEmpty((Object)cellValue) && !"null".equals(cellValue)) continue;
                    dataCell.setCellValue("");
                }
            }
            if (CSV.equals(reportType) || TXT.equals(reportType)) {
                IvsExcelUtil.ExecltoCsv((Workbook)workbook, ops);
            } else {
                workbook.write((OutputStream)ops);
            }
        }
        catch (Exception e) {
            loger.error("", (Throwable)e);
        }
        ((OutputStream)ops).flush();
        ((OutputStream)ops).close();
        outputStream.close();
    }

    public static String getDateFormt(DateType dateType) {
        String format = "yyyy-MM-dd HH:mm:ss";
        if (dateType != null) {
            switch (dateType.type()) {
                case "date": {
                    format = "yyyy-MM-dd";
                    break;
                }
                case "time": {
                    format = "HH:mm:ss";
                    break;
                }
                case "timestamp": {
                    format = "yyyy-MM-dd HH:mm:ss";
                    break;
                }
            }
        }
        return format;
    }

    public static void ExecltoCsv(Workbook workbook, OutputStream out) throws IOException {
        byte[] uft8bom = new byte[]{-17, -69, -65};
        out.write(uft8bom);
        OutputStreamWriter osw = new OutputStreamWriter(out, "UTF-8");
        BufferedWriter bw = new BufferedWriter(osw);
        Sheet my_worksheet = workbook.getSheetAt(0);
        Iterator rowIterator = my_worksheet.iterator();
        try {
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                int num = row.getPhysicalNumberOfCells();
                if (num == 0) continue;
                Iterator cellIterator = row.cellIterator();
                while (cellIterator.hasNext()) {
                    Cell cell = (Cell)cellIterator.next();
                    switch (cell.getCellType()) {
                        case STRING: {
                            bw.append("\"" + cell.getStringCellValue() + "\"");
                            bw.append(",");
                            break;
                        }
                    }
                }
                bw.append(System.getProperty("line.separator"));
            }
            bw.flush();
            out.close();
            bw.close();
            osw.close();
        }
        catch (IOException e) {
            loger.error("ivs excelUtils excelToCsv error : " + e.getMessage());
        }
    }

    public static void setBorderStyle(BorderStyle border, CellRangeAddress region, Sheet sheet) {
        RegionUtil.setBorderBottom((BorderStyle)border, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)border, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)border, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderTop((BorderStyle)border, (CellRangeAddress)region, (Sheet)sheet);
    }

    private static boolean checkImg(String str) {
        return str.contains("background") || str.contains("captureImage") || str.contains("snapshot") || str.contains("panorama");
    }

    private static class Header
    extends PdfPageEventHelper {
        private Header() {
        }

        public void onEndPage(PdfWriter pdfWriter, Document document) {
            ColumnText.showTextAligned((PdfContentByte)pdfWriter.getDirectContent(), (int)2, (Phrase)new Phrase("Page:" + pdfWriter.getCurrentPageNumber()), (float)450.0f, (float)30.0f, (float)0.0f);
        }
    }
}

