/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.utils;

import com.zkteco.zkbiosecurity.base.utils.SystemOsUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class IVSUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPing(String ip) {
        String pingCommand = SystemOsUtil.isWindow() ? "ping " + ip + " -n 3" : "ping " + ip + " -c 3";
        boolean networkPass = false;
        BufferedReader in = null;
        try {
            String line;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(pingCommand);
            in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = in.readLine()) != null) {
                if (!line.toLowerCase().contains("ttl=")) continue;
                networkPass = true;
                break;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return networkPass;
    }

    public static String getRemoteAddr() {
        HttpServletRequest httpServletRequest;
        String ip = "";
        if (WebContextUtil.getCurrentRequest() != null && StringUtils.isBlank((CharSequence)(ip = (httpServletRequest = WebContextUtil.getCurrentRequest()).getHeader("X-Forwarded-For")))) {
            ip = httpServletRequest.getRemoteAddr();
        }
        return ip;
    }

    public static String replaceBlank(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            str = str.replace("\\n", "");
            str = str.replace("\\u0010", "").trim();
            return str;
        }
        return I18nUtil.i18nCode((String)"ivs_report_noData", (Object[])new Object[0]);
    }

    public static String getExcludedTypes(HttpServletRequest request) {
        String[] parameterNames = new String[]{"isShowZknvr", "isShowTiandyNvr", "isShowHIKVSIONNvr", "isShowOnvifNvr", "isShowOnvifIpc", "isShowCloudDev", "isShowZkIpc", "isShowDHNVR"};
        ArrayList<String> excludedTypes = new ArrayList<String>();
        for (String parameterName : parameterNames) {
            String parameterValue = request.getParameter(parameterName);
            if ("true".equals(parameterValue)) continue;
            String excludedType = IVSUtil.getExcludedTypeByParameterName(parameterName);
            excludedTypes.add(excludedType);
        }
        return IVSUtil.getExcludedTypesAsString(excludedTypes);
    }

    public static String getExcludedTypesAsString(List<String> excludedTypes) {
        return String.join((CharSequence)",", excludedTypes);
    }

    public static String getExcludedTypeByParameterName(String parameterName) {
        switch (parameterName) {
            case "isShowZknvr": {
                return "7";
            }
            case "isShowTiandyNvr": {
                return "9";
            }
            case "isShowHIKVSIONNvr": {
                return "10";
            }
            case "isShowOnvifNvr": {
                return "11";
            }
            case "isShowOnvifIpc": {
                return "12";
            }
            case "isShowCloudDev": {
                return "4";
            }
            case "isShowZkIpc": {
                return "13";
            }
            case "isShowDHNVR": {
                return "14";
            }
        }
        return "";
    }
}

