/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.utils;

import com.google.common.io.ByteStreams;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Encoder;

public class ApiIvsCheckUtil {
    private static final Logger log = LoggerFactory.getLogger(ApiIvsCheckUtil.class);
    public static final int OP_SUCCESS = 0;

    public static String streamToString(InputStream inputStream) throws IOException {
        byte[] bt = ByteStreams.toByteArray((InputStream)inputStream);
        inputStream.close();
        String out = new BASE64Encoder().encodeBuffer(bt);
        return out;
    }

    public static String fileToString(String filePath) throws IOException {
        File file = new File(filePath);
        FileInputStream is = new FileInputStream(file);
        String fileStr = ApiIvsCheckUtil.streamToString(is);
        return fileStr;
    }

    public static Map<String, String> getColumnAndI18nByClass(Class clazz) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Field[] fields = clazz.getDeclaredFields();
        try {
            for (Field field : fields) {
                GridColumn annotation = field.getDeclaredAnnotation(GridColumn.class);
                if (annotation == null) continue;
                String fileI18nCode = annotation.label();
                map.put(field.getName(), I18nUtil.i18nCode((String)fileI18nCode, (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            log.error("ivs getColumnAndI18nByClass error : " + e.getMessage());
        }
        return map;
    }
}

