/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ivs.service.IvsApiDealService;
import com.zkteco.zkbiosecurity.ivs.vo.api.HwApiVidChannelGroupItem;
import com.zkteco.zkbiosecurity.ivs.vo.api.HwApiVidParentDeviceItem;
import com.zkteco.zkbiosecurity.ivs.vo.api.IvsApiRtspPlayBackItem;
import com.zkteco.zkbiosecurity.ivs.vo.api.IvsApiRtspRealPlayItem;
import com.zkteco.zkbiosecurity.ivs.vo.api.IvsApiVideoListItem;
import com.zkteco.zkbiosecurity.ivs.vo.api.IvsFavoritesReqItem;
import com.zkteco.zkbiosecurity.ivs.vo.api.IvsFavoritesReqListItem;
import com.zkteco.zkbiosecurity.ivs.vo.api.IvsGetAllRtspItem;
import com.zkteco.zkbiosecurity.ivs.vo.api.IvsGuardPointItem;
import com.zkteco.zkbiosecurity.ivs.vo.api.IvsIntercomSnapShotItem;
import com.zkteco.zkbiosecurity.ivs.vo.api.IvsOsdConfigItem;
import com.zkteco.zkbiosecurity.ivs.vo.api.IvsPTZControlItem;
import com.zkteco.zkbiosecurity.ivs.vo.api.IvsPluginConfigReqItem;
import com.zkteco.zkbiosecurity.ivs.vo.api.IvsPresetCruiseItem;
import com.zkteco.zkbiosecurity.ivs.vo.api.IvsPresetPositionItem;
import com.zkteco.zkbiosecurity.ivs.vo.video.IvsRtspVideoDownloadItem;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/ivsPlugin"})
public class IvsVideoPluginController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(IvsVideoPluginController.class);
    @Autowired
    private IvsApiDealService ivsApiDealService;

    @RequestMapping(value={"/getDeviceTree"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg getDeviceTree(@RequestBody HwApiVidParentDeviceItem hwVidParentDeviceItem) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        hwVidParentDeviceItem.setIsShowSubset(Boolean.valueOf(true));
        List hwApiVidParentDeviceItems = this.ivsApiDealService.getV2DeviceTree(hwVidParentDeviceItem, hwVidParentDeviceItem.getJsSessionId());
        zkResultMsg.setData((Object)hwApiVidParentDeviceItems);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequestMapping(value={"/getDeviceRtsp"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg getDeviceRtsp(@RequestBody IvsApiRtspRealPlayItem ivsApiRtspRealPlayItem) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        JSONObject result = this.ivsApiDealService.getClientDeviceRtsp(ivsApiRtspRealPlayItem);
        if (Objects.nonNull(result)) {
            if ("0".equals(result.getString("resultCode"))) {
                resultMsg.setData((Object)result);
            } else {
                return ZKResultMsg.failMsg((String)result.getString("resultText"), (Object[])new Object[0]);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(value={"/getGroupTree"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg getGroupTree(@RequestBody HwApiVidChannelGroupItem hwApiVidChannelGroupItem) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        hwApiVidChannelGroupItem.setIsShowSubset(Boolean.valueOf(true));
        List hwApiVidChannelGroupItems = this.ivsApiDealService.getGroupTree(hwApiVidChannelGroupItem);
        zkResultMsg.setData((Object)hwApiVidChannelGroupItems);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequestMapping(value={"/getVideoList"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg getVideoList(@RequestBody IvsApiVideoListItem ivsApiVideoListItem) {
        ZKResultMsg zkResultMsg = this.ivsApiDealService.getVideoList(ivsApiVideoListItem);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequestMapping(value={"/getRtspPlayBack"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg getRtspPlayBack(@RequestBody IvsApiRtspPlayBackItem ivsApiRtspPlayBackItem) {
        ZKResultMsg zkResultMsg = this.ivsApiDealService.getRtspPlayBack(ivsApiRtspPlayBackItem);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequestMapping(value={"/ptzControl"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg ptzControl(@RequestBody IvsPTZControlItem ivsPTZControlItem) {
        ZKResultMsg zkResultMsg = this.ivsApiDealService.ptzControl(ivsPTZControlItem);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequestMapping(value={"/voice"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg voice(@RequestBody IvsApiRtspRealPlayItem ivsApiRtspRealPlayItem) {
        ZKResultMsg zkResultMsg = this.ivsApiDealService.getRtspVoice(ivsApiRtspRealPlayItem);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequestMapping(value={"/broadcast"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg broadcast(@RequestBody IvsApiRtspRealPlayItem ivsApiRtspRealPlayItem) {
        ZKResultMsg zkResultMsg = this.ivsApiDealService.getRtspBroadcast(ivsApiRtspRealPlayItem);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequestMapping(value={"/setOsdConfig"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg setOsdConfig(@RequestBody IvsOsdConfigItem ivsOsdConfigItem) {
        ZKResultMsg zkResultMsg = this.ivsApiDealService.setOsdConfig(ivsOsdConfigItem);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequestMapping(value={"/getOsdConfig"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg getOsdConfig(@RequestBody IvsOsdConfigItem ivsOsdConfigItem) {
        ZKResultMsg zkResultMsg = this.ivsApiDealService.getOsdConfig(ivsOsdConfigItem);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequestMapping(value={"/videoDownload"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg videoDownload(@RequestBody IvsRtspVideoDownloadItem ivsRtspVideoDownloadItem) {
        ZKResultMsg zkResultMsg = this.ivsApiDealService.videoDownload(ivsRtspVideoDownloadItem);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequestMapping(value={"/creatFavorites"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg creatFavorites(@RequestBody IvsFavoritesReqItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.creatFavorites(item));
    }

    @RequestMapping(value={"/changeFavoritesName"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg changeFavoritesName(@RequestBody IvsFavoritesReqItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.creatFavorites(item));
    }

    @RequestMapping(value={"/delFavorites"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg delFavorites(@RequestBody IvsFavoritesReqItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.delFavorites(item));
    }

    @RequestMapping(value={"/addChannel2Favorites"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg addChannel2Favorites(@RequestBody IvsFavoritesReqListItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.addChannel2Favorites(item));
    }

    @RequestMapping(value={"/delChannel4Favorites"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg delChannel4Favorites(@RequestBody IvsFavoritesReqListItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.delChannel4Favorites(item));
    }

    @RequestMapping(value={"/getFavorites"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg getFavorites(@RequestBody IvsFavoritesReqItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.getFavorites(item, this.request.getSession().getId()));
    }

    @RequestMapping(value={"/creatPluginConfig"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg creatPluginConfig(@RequestBody IvsPluginConfigReqItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.creatPluginConfig(item));
    }

    @RequestMapping(value={"/updatePluginConfig"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg updatePluginConfig(@RequestBody IvsPluginConfigReqItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.creatPluginConfig(item));
    }

    @RequestMapping(value={"/delPluginConfig"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg delPluginConfig(@RequestBody IvsPluginConfigReqItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.delPluginConfig(item));
    }

    @RequestMapping(value={"/getPluginConfigs"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg getPluginConfigs(@RequestBody IvsPluginConfigReqItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.getPluginConfigs(item));
    }

    @RequestMapping(value={"getPresetPositionList"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg getPresetPositionList(@RequestBody IvsPresetPositionItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.getPresetPositionList(item));
    }

    @RequestMapping(value={"addPresetPosition"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg addPresetPosition(@RequestBody IvsPresetPositionItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.addPresetPosition(item));
    }

    @RequestMapping(value={"editPresetPosition"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg editPresetPosition(@RequestBody IvsPresetPositionItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.editPresetPosition(item));
    }

    @RequestMapping(value={"delPresetPosition"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg delPresetPosition(@RequestBody IvsPresetPositionItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.delPresetPosition(item));
    }

    @RequestMapping(value={"getGuardPoint"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg getGuardPoint(@RequestBody IvsGuardPointItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.getGuardPoint(item));
    }

    @RequestMapping(value={"setGuardPoint"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg setGuardPoint(@RequestBody IvsGuardPointItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.setGuardPoint(item));
    }

    @RequestMapping(value={"getCruiseNo"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg getCruiseNo(@RequestBody IvsPresetCruiseItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.getCruiseNo(item));
    }

    @RequestMapping(value={"uptPresetCruise"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg uptPresetCruise(@RequestBody IvsPresetCruiseItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.uptPresetCruise(item));
    }

    @RequestMapping(value={"setPresetCruise"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg setPresetCruise(@RequestBody IvsPresetCruiseItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.setPresetCruise(item));
    }

    @RequestMapping(value={"delPresetCruise"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg delPresetCruise(@RequestBody IvsPresetCruiseItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.delPresetCruise(item));
    }

    @RequestMapping(value={"getPresetCruiseList"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg getPresetCruiseList(@RequestBody IvsPresetCruiseItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.getPresetCruiseList(item));
    }

    @RequestMapping(value={"getPresetCruiseDetail"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg getPresetCruiseDetail(@RequestBody IvsPresetCruiseItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.getPresetCruiseDetail(item));
    }

    @RequestMapping(value={"isOnWall"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg isOnWall() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.isOnWall());
    }

    @RequestMapping(value={"getRtspDynamicAndStatic"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg getRtspDynamicAndStatic(@RequestBody IvsGetAllRtspItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.ivsApiDealService.getRtspDynamicAndStatic(item));
    }

    @RequestMapping(value={"snapShot"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg snapShot(@RequestBody IvsIntercomSnapShotItem item) {
        boolean isSucceed = this.ivsApiDealService.snaShot(item.getId(), item.getBase64(), item.getEventType());
        return isSucceed ? ZKResultMsg.successMsg() : ZKResultMsg.failMsg();
    }
}

