/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.ivs.remote.IvsVidAlarmRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsChannelService;
import com.zkteco.zkbiosecurity.ivs.service.IvsEdgeDeviceService;
import com.zkteco.zkbiosecurity.ivs.service.IvsVidAlarmChannelService;
import com.zkteco.zkbiosecurity.ivs.service.IvsVidAlarmLevelService;
import com.zkteco.zkbiosecurity.ivs.service.IvsVidAlarmLinkageService;
import com.zkteco.zkbiosecurity.ivs.service.IvsVidAlarmSourceService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsEdgeDeviceItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsVidAlarmChannelItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsVidAlarmChannelSubItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsVidAlarmLevelItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsVidAlarmLinkageInfoItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsVidAlarmSourceItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsVidAlarmSourceOutItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsVidAlarmTypeItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsVidAlarmController
extends BaseController
implements IvsVidAlarmRemote {
    @Autowired
    private IvsVidAlarmLevelService ivsVidAlarmLevelService;
    @Autowired
    private IvsVidAlarmSourceService ivsVidAlarmSourceService;
    @Autowired
    private IvsVidAlarmChannelService ivsVidAlarmChannelService;
    @Autowired
    private IvsVidAlarmLinkageService ivsVidAlarmLinkageService;
    @Autowired
    private IvsEdgeDeviceService ivsEdgeDeviceService;
    @Autowired
    private IvsChannelService ivsChannelService;

    public DxGrid alarmLevel(IvsVidAlarmLevelItem condition) {
        Pager pager = this.ivsVidAlarmLevelService.getAlarmLevelPager(condition, this.getPageNo(), this.getPageSize());
        DxGrid data = GridUtil.convert((Pager)pager, condition.getClass());
        data.getRows().forEach(item -> {
            JSONObject row = (JSONObject)item;
            String color = row.getJSONArray("data").getString(3);
            row.getJSONArray("data").set(3, (Object)("<div style=\"display:flex;align-items:center;justify-content:center;background:" + color + ";height:25px;width:50px\"></div>"));
        });
        return data;
    }

    public ModelAndView alarmLevelView(String parentDeviceId) {
        this.request.setAttribute("parentDeviceId", (Object)parentDeviceId);
        return new ModelAndView("ivs/parentdevice/alarm/alarmLevel");
    }

    public ModelAndView addAlarmLevelView(String parentDeviceId) {
        this.request.setAttribute("parentDeviceId", (Object)parentDeviceId);
        this.request.setAttribute("alarmLevelValue", (Object)0);
        this.request.setAttribute("isEdit", (Object)false);
        return new ModelAndView("ivs/parentdevice/alarm/editAlarmLevel");
    }

    public ModelAndView editAlarmLevelView(String parentDeviceId, String alarmLevelValue, String id) {
        IvsVidAlarmLevelItem ivsVidAlarmLevelItem = this.ivsVidAlarmLevelService.getAlarmLevelInfo(parentDeviceId, id);
        this.request.setAttribute("item", (Object)ivsVidAlarmLevelItem);
        this.request.setAttribute("parentDeviceId", (Object)parentDeviceId);
        this.request.setAttribute("alarmLevelValue", (Object)alarmLevelValue);
        this.request.setAttribute("isEdit", (Object)true);
        return new ModelAndView("ivs/parentdevice/alarm/editAlarmLevel");
    }

    public DxGrid alarmType(IvsVidAlarmTypeItem condition) {
        Pager pager = this.ivsVidAlarmLevelService.getAlarmTypePager(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid noSelectAlarmType(IvsVidAlarmTypeItem condition) {
        Pager pager = this.ivsVidAlarmLevelService.getNoSelectAlarmTypePager(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @LogChangeRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_iClient_alarm_manage", vo=IvsVidAlarmLevelItem.class, service=IvsVidAlarmLevelService.class)
    public ZKResultMsg addAlarmLevel(IvsVidAlarmLevelItem condition) {
        return this.ivsVidAlarmLevelService.addAlarmLevel(condition, true);
    }

    @LogChangeRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_iClient_alarm_manage", vo=IvsVidAlarmLevelItem.class, service=IvsVidAlarmLevelService.class)
    public ZKResultMsg editAlarmLevel(IvsVidAlarmLevelItem condition) {
        return this.ivsVidAlarmLevelService.addAlarmLevel(condition, false);
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_iClient_alarm_manage", requestParams={"alarmLevelName"}, opContent="common_op_del")
    public ZKResultMsg delAlarmLevel(IvsVidAlarmLevelItem condition) {
        return this.ivsVidAlarmLevelService.delAlarmLevel(condition);
    }

    public DxGrid alarmChannel(IvsVidAlarmChannelItem condition) {
        Pager pager = this.ivsVidAlarmChannelService.getAlarmChannelPager(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid noAlarmChannel(IvsVidAlarmChannelItem condition) {
        Pager pager = this.ivsVidAlarmChannelService.getNoAlarmChannelPager(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid alarmChannelSub(IvsVidAlarmChannelSubItem condition) {
        Pager pager = this.ivsVidAlarmChannelService.getAlarmChannelSubPager(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ModelAndView alarmSourceView(String parentDeviceId) {
        this.request.setAttribute("parentDeviceId", (Object)parentDeviceId);
        return new ModelAndView("ivs/parentdevice/alarm/alarmSource");
    }

    public DxGrid alarmSource(IvsVidAlarmSourceItem condition) {
        Pager pager = new Pager();
        List alarmSourceList = this.ivsVidAlarmSourceService.getAlarmSourceList(condition);
        pager.setTotal(alarmSourceList.size());
        if ("1".equals(condition.getType())) {
            ArrayList<IvsVidAlarmSourceOutItem> ivsVidAlarmSourceOutItems = new ArrayList<IvsVidAlarmSourceOutItem>();
            for (IvsVidAlarmSourceItem ivsVidAlarmSourceItem : alarmSourceList) {
                IvsVidAlarmSourceOutItem ivsVidAlarmSourceOutItem = new IvsVidAlarmSourceOutItem();
                ivsVidAlarmSourceOutItem.setId(ivsVidAlarmSourceItem.getId());
                ivsVidAlarmSourceOutItem.setAlarmName(ivsVidAlarmSourceItem.getAlarmName());
                ivsVidAlarmSourceOutItem.setType(ivsVidAlarmSourceItem.getType());
                ivsVidAlarmSourceOutItems.add(ivsVidAlarmSourceOutItem);
            }
            pager.setData(ivsVidAlarmSourceOutItems);
            return GridUtil.convert((Pager)pager, IvsVidAlarmSourceOutItem.class);
        }
        pager.setData(alarmSourceList);
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ModelAndView alarmLinkageView(IvsVidAlarmChannelSubItem condition) {
        this.request.setAttribute("item", (Object)condition);
        return new ModelAndView("ivs/parentdevice/alarm/alarmLinkage");
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_iClient_alarm_manage", requestParams={"channelCode"}, opContent="common_op_del")
    public ZKResultMsg delAlarmLinkage(IvsVidAlarmChannelSubItem condition) {
        return this.ivsVidAlarmLinkageService.delAlarmLinkage(condition);
    }

    public ModelAndView editAlarmLinkageView(IvsVidAlarmChannelSubItem condition) {
        IvsVidAlarmLinkageInfoItem.AlarmTypeInfo.AlarmTypeConfig config;
        IvsVidAlarmLinkageInfoItem ivsVidAlarmLinkageInfoItem = this.ivsVidAlarmLinkageService.getAlarmLinkageDetails(condition);
        this.request.setAttribute("isEdit", (Object)true);
        this.request.setAttribute("item", (Object)JSONObject.toJSONString((Object)ivsVidAlarmLinkageInfoItem));
        if ("2".equals(ivsVidAlarmLinkageInfoItem.getParentDeviceType()) && Objects.nonNull(config = ivsVidAlarmLinkageInfoItem.getAlarmTypeInfo().getConfig())) {
            this.request.setAttribute("alarmOutValue", (Object)String.join((CharSequence)",", config.getAlarmOut()));
            this.request.setAttribute("recordChannelValue", (Object)String.join((CharSequence)",", config.getRecordChannel()));
        }
        this.request.setAttribute("cacheId", (Object)condition.getId());
        this.request.setAttribute("parentDeviceId", (Object)condition.getParentDeviceId());
        this.request.setAttribute("parentDeviceType", (Object)ivsVidAlarmLinkageInfoItem.getParentDeviceType());
        this.request.setAttribute("channelName", (Object)this.request.getParameter("channelName"));
        return new ModelAndView("ivs/parentdevice/alarm/addAlarmLinkage");
    }

    public ModelAndView addAlarmLinkageView(String parentDeviceId, String channelIds) {
        IvsEdgeDeviceItem ivsEdgeDeviceItem = this.ivsEdgeDeviceService.getItemById(parentDeviceId);
        if (StringUtils.isNotBlank((CharSequence)channelIds)) {
            List codes = this.ivsChannelService.getCodeByIds(Arrays.asList(channelIds.split(",")));
            this.request.setAttribute("codes", (Object)StringUtils.join((Object[])codes.toArray(), (String)","));
        }
        if (Objects.nonNull(ivsEdgeDeviceItem)) {
            this.request.setAttribute("parentDeviceId", (Object)ivsEdgeDeviceItem.getId());
            this.request.setAttribute("parentDeviceType", (Object)ivsEdgeDeviceItem.getType());
        }
        this.request.setAttribute("isEdit", (Object)false);
        String channelName = this.request.getParameter("channelName");
        this.request.setAttribute("channelName", (Object)channelName);
        return new ModelAndView("ivs/parentdevice/alarm/addAlarmLinkage");
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_iClient_alarm_manage", requestParams={"channelName", "alarmTypeName"}, opContent="ivs_alarm_addLinkage")
    public ZKResultMsg addAlarmLinkageInfo(IvsVidAlarmLinkageInfoItem condition) {
        return this.ivsVidAlarmLinkageService.addAlarmLinkageInfo(condition);
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_iClient_alarm_manage", requestParams={"channelName"}, opContent="common_op_edit")
    public ZKResultMsg editAlarmLinkageInfo(IvsVidAlarmLinkageInfoItem condition) {
        return this.ivsVidAlarmLinkageService.editAlarmLinkageInfo(condition);
    }

    public TreeItem getNvr800AlarmChannelTree(String id, String type) {
        return this.ivsVidAlarmLinkageService.getNvr800AlarmChannelTree(id, type);
    }

    public ZKResultMsg getChannelPresetsTree(String channelCode, String parentDeviceId) {
        return this.ivsVidAlarmLinkageService.getChannelPresetsTree(channelCode, parentDeviceId);
    }
}

