/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.ivs.controller.IvsExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsVehicleRetrievalRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsVehicleRetrievalService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsVehicleRetrievalItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsVehicleRetrievalController
extends IvsExportController
implements IvsVehicleRetrievalRemote {
    @Autowired
    private IvsVehicleRetrievalService ivsVehicleRetrievalService;

    @RequiresPermissions(value={"ivs:retrieval:vehicle"})
    public ModelAndView index() {
        return new ModelAndView("ivs/vehicleRetrieval/ivsVehicleRetrieval");
    }

    public DxGrid list(IvsVehicleRetrievalItem condition) {
        Pager pager = this.ivsVehicleRetrievalService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        DxGrid data = GridUtil.convert((Pager)pager, condition.getClass());
        return data;
    }

    @RequiresPermissions(value={"ivs:vehicleRetrieval:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        IvsVehicleRetrievalItem ivsVehicleRetrievalItem = new IvsVehicleRetrievalItem();
        this.setConditionValue((BaseItem)ivsVehicleRetrievalItem);
        int recordstart = Integer.parseInt(request.getParameter("recordstart"));
        int maxCount = Integer.parseInt(request.getParameter("recordcount"));
        List itemList = this.ivsVehicleRetrievalService.getItemData(ivsVehicleRetrievalItem, recordstart, maxCount);
        this.excelExport(itemList, IvsVehicleRetrievalItem.class);
    }

    public ModelAndView getVehicleSearchTail(String id) {
        IvsVehicleRetrievalItem vehicleSearchTail = this.ivsVehicleRetrievalService.getVehicleSearchTail(id, this.request.getSession().getId());
        this.request.setAttribute("item", (Object)vehicleSearchTail);
        return new ModelAndView("ivs/vehicleRetrieval/vehicleRetrievalDetail");
    }
}

