/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.ivs.remote.IvsVehicleIntelligenceRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsVehicleIntelligenceService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsVehicleIntelligenceInfoItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsVehicleIntelligenceController
extends BaseController
implements IvsVehicleIntelligenceRemote {
    @Autowired
    IvsVehicleIntelligenceService ivsVehicleIntelligenceService;

    @RequiresPermissions(value={"ivs:ext:vehicleIntelligence"})
    public ModelAndView index() {
        return new ModelAndView("ivs/vehicleIntelligence/ivsVehicleIntelligence");
    }

    @LogRequest(module="ivs_module", object="ivs_VehicleIntelligence", opType="ivs_log_opType_get", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg getVehicleIntelligence(IvsVehicleIntelligenceInfoItem condition) {
        return this.ivsVehicleIntelligenceService.getVehicleIntelligence(condition);
    }

    @LogRequest(module="ivs_module", object="ivs_VehicleIntelligence", opType="ivs_log_opType_set", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg setVehicleIntelligence(IvsVehicleIntelligenceInfoItem condition) {
        return this.ivsVehicleIntelligenceService.setVehicleIntelligence(condition);
    }
}

