/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ivs.remote.IvsTvWallRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsDecoderService;
import com.zkteco.zkbiosecurity.ivs.service.IvsPluginConfigService;
import com.zkteco.zkbiosecurity.ivs.service.IvsTvWallService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsDecoderItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsPluginConfigItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsTvWallItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsTvWallController
extends BaseController
implements IvsTvWallRemote {
    @Autowired
    private IvsTvWallService ivsTvWallService;
    @Autowired
    private IvsDecoderService ivsDecoderService;
    @Autowired
    private IvsPluginConfigService ivsPluginConfigService;

    @Autowired
    @RequiresPermissions(value={"ivs:tvWall"})
    public ModelAndView index() {
        return new ModelAndView("ivs/tvWall/ivsTvWall");
    }

    @RequiresPermissions(value={"ivs:tvWall:edit", "ivs:tvWall:add"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.ivsTvWallService.getItemAndLayoutById(id));
        }
        this.request.setAttribute("ivsDecoderList", (Object)this.ivsDecoderService.getByCondition(new IvsDecoderItem()));
        return new ModelAndView("ivs/tvWall/editIvsTvWall");
    }

    @RequiresPermissions(value={"ivs:tvWall:edit", "ivs:tvWall:add"})
    public ZKResultMsg save(IvsTvWallItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.ivsTvWallService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ivs:tvWall:refresh"})
    public DxGrid list(IvsTvWallItem condition) {
        Pager pager = this.ivsTvWallService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ivs:tvWall:del"})
    public ZKResultMsg del(String ids) {
        this.ivsTvWallService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String validName(String name) {
        IvsTvWallItem item = this.ivsTvWallService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public ZKResultMsg getTvWallList() {
        List ivsTvWallItems = this.ivsTvWallService.getByCondition(new IvsTvWallItem());
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (IvsTvWallItem ivsTvWallItem : ivsTvWallItems) {
            SelectItem selectItem = new SelectItem();
            selectItem.setValue(ivsTvWallItem.getId());
            selectItem.setText((Object)ivsTvWallItem.getName());
            selectItems.add(selectItem);
        }
        return new ZKResultMsg(selectItems);
    }

    public JSONObject getTvWallAndSchemeListByTvWallId(String tvWallId) {
        JSONObject jsonObject = new JSONObject();
        IvsTvWallItem ivsTvWallItem = this.ivsTvWallService.getItemAndLayoutById(tvWallId);
        jsonObject.put("tvWall", (Object)ivsTvWallItem);
        JSONArray layout = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)ivsTvWallItem.getLayout())) {
            layout = JSONArray.parseArray((String)ivsTvWallItem.getLayout());
            ivsTvWallItem.setLayout(null);
        }
        jsonObject.put("layout", (Object)layout);
        return jsonObject;
    }

    public ZKResultMsg setTvWallLayout() {
        String tvWallAndLayoutSetting = this.request.getParameter("tvWallAndLayoutSetting");
        if (StringUtils.isNotBlank((CharSequence)tvWallAndLayoutSetting)) {
            this.ivsTvWallService.setTvWallLayout(tvWallAndLayoutSetting);
        }
        return new ZKResultMsg();
    }

    @RequiresPermissions(value={"ivs:tvWall:edit", "ivs:tvWall:add"})
    public ModelAndView planEdit(String id) {
        IvsPluginConfigItem item;
        if (StringUtils.isNotBlank((CharSequence)id) && Objects.nonNull(item = this.ivsPluginConfigService.getItemById(id))) {
            this.request.setAttribute("item", (Object)item);
        }
        this.request.setAttribute("editPage", (Object)true);
        return new ModelAndView("ivs/tvWall/editIvsPlanList");
    }

    @RequiresPermissions(value={"ivs:tvWall:edit", "ivs:tvWall:add"})
    public ZKResultMsg savePlanList(IvsPluginConfigItem item) {
        return this.ivsTvWallService.savePlanList(item);
    }

    @RequiresPermissions(value={"ivs:tvWall:refresh"})
    public DxGrid getPlanList(IvsPluginConfigItem condition) {
        Pager pager = this.ivsTvWallService.getPlanListItemsByPage(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ivs:tvWall:del"})
    public ZKResultMsg delPlanList(String ids) {
        boolean isDel = this.ivsPluginConfigService.deleteByIds(ids);
        if (!isDel) {
            return ZKResultMsg.failMsg();
        }
        return ZKResultMsg.successMsg();
    }

    public String validPlanName(String name) {
        IvsPluginConfigItem item = this.ivsPluginConfigService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }
}

