/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.ivs.remote.IvsTransactionRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsTransactionService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsTransactionItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class IvsTransactionController
extends BaseController
implements IvsTransactionRemote {
    @Autowired
    private IvsTransactionService ivsTransactionService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIvsCapture() {
        FileInputStream fStream = null;
        try {
            File file;
            String id = this.request.getParameter("id");
            IvsTransactionItem vidTransaction = this.ivsTransactionService.getItemById(id);
            String filePath = vidTransaction.getFilePath();
            byte[] data = FileEncryptUtil.getDecryptFile((String)filePath);
            if (data == null && StringUtils.isNotBlank((CharSequence)filePath) && (file = new File(FileUtils.getLocalFullPath((String)filePath))).exists()) {
                fStream = new FileInputStream(file);
                int lenght = fStream.available();
                data = new byte[lenght];
                fStream.read(data);
            }
            if (Objects.nonNull(data)) {
                this.response.setHeader("Content-Type", "image/jpeg");
                this.response.getOutputStream().write(this.ivsTransactionService.isEnablePictureBlur(data));
            }
        }
        catch (Exception e) {
            this.log.error("ivs get capture error \uff1a" + e.getMessage());
        }
        finally {
            if (fStream != null) {
                try {
                    fStream.close();
                }
                catch (IOException e) {
                    this.log.error("ivs get capture error \uff1a" + e.getMessage());
                }
            }
        }
        return null;
    }
}

