/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.ivs.controller.IvsExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsSearchByImageRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsSearchByImageService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsSearchByImageItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsSearchByImageController
extends IvsExportController
implements IvsSearchByImageRemote {
    @Autowired
    private IvsSearchByImageService ivsSearchByImageService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @RequiresPermissions(value={"ivs:search:image"})
    public ModelAndView index(String parentDeviceId) {
        if (StringUtils.isNotBlank((CharSequence)parentDeviceId)) {
            this.request.setAttribute("parentDeviceId", (Object)parentDeviceId);
        }
        return new ModelAndView("ivs/searchByImage/IvsSearchByImage");
    }

    public DxGrid list(IvsSearchByImageItem condition) {
        Pager pager = this.ivsSearchByImageService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        DxGrid data = GridUtil.convert((Pager)pager, condition.getClass());
        return data;
    }

    @RequiresPermissions(value={"ivs:searchByImage:export"})
    public void export(IvsSearchByImageItem condition, HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        this.setConditionValue((BaseItem)condition);
        int maxCount = Integer.parseInt(request.getParameter("recordcount"));
        int beginIndex = Integer.parseInt(request.getParameter("recordstart"));
        List itemList = this.ivsSearchByImageService.getItemData(condition, beginIndex / maxCount, maxCount);
        this.excelExport(itemList, IvsSearchByImageItem.class);
    }

    @Override
    public void setConditionValue(BaseItem conditionItem) {
        this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"start");
        String sortOrder = this.request.getParameter("sortOrder");
        String sortName = this.request.getParameter("sortName");
        if (StringUtils.isNotBlank((CharSequence)sortOrder) && StringUtils.isNotBlank((CharSequence)sortName)) {
            conditionItem.setSortName(sortName);
            conditionItem.setSortOrder(sortOrder);
        }
    }
}

