/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.ApplicationPropertiesUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ivs.remote.IvsRtPatrolRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsDeviceService;
import com.zkteco.zkbiosecurity.ivs.service.IvsPatrolPlanService;
import com.zkteco.zkbiosecurity.ivs.vo.patrol.IvsPatrolPlanItem;
import com.zkteco.zkbiosecurity.ivs.vo.patrol.IvsRtPatrolParamItem;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsRtPatrolController
extends BaseController
implements IvsRtPatrolRemote {
    @Autowired
    private IvsPatrolPlanService ivsPatrolPlanService;
    @Autowired
    private IvsDeviceService ivsDeviceService;

    public ModelAndView index(String id) {
        return new ModelAndView("ivs/patrol/ivsRtPatrol");
    }

    public ModelAndView getPatrolPlanInfo(String id, String shiftId) {
        boolean isPatrolMap = false;
        String source = this.request.getParameter("source");
        this.request.setAttribute("source", (Object)source);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            IvsRtPatrolParamItem ivsRtPatrolItem = this.ivsPatrolPlanService.getInfoByPlanId(this.request.getSession().getId(), id, shiftId);
            List ivsDeviceIdList = ivsRtPatrolItem.getIvsDeviceIdList();
            String format = ApplicationPropertiesUtil.getProperty((String)"biosecurity.date.sysDateFmt.alias", (String)"yyyy-MM-dd");
            JSONObject planInfoData = new JSONObject();
            IvsPatrolPlanItem planItem = ivsRtPatrolItem.getIvsPatrolPlanItem();
            planInfoData.put("planId", (Object)id);
            planInfoData.put("shiftId", (Object)shiftId);
            planInfoData.put("name", (Object)planItem.getName());
            planInfoData.put("startDate", (Object)DateUtil.dateToLocaleString((Date)planItem.getStartDate(), (String)format));
            planInfoData.put("endDate", (Object)DateUtil.dateToLocaleString((Date)planItem.getEndDate(), (String)format));
            planInfoData.put("patrolGroupName", (Object)planItem.getPatrolGroupName());
            planInfoData.put("ivsAnswerCount", (Object)planItem.getIvsAnswerCount());
            planInfoData.put("patrolPlanCount", (Object)ivsDeviceIdList.size());
            planInfoData.put("status", (Object)planItem.getStatus());
            planInfoData.put("point", (Object)ivsRtPatrolItem.getPoint());
            planInfoData.put("alarm", (Object)ivsRtPatrolItem.getAlarm());
            planInfoData.put("checkIn", (Object)ivsRtPatrolItem.getCheckIn());
            planInfoData.put("missed", (Object)ivsRtPatrolItem.getMissed());
            planInfoData.put("timelot", (Object)ivsRtPatrolItem.getTimelot());
            String mapId = planItem.getMapId();
            if (StringUtils.isNotBlank((CharSequence)mapId)) {
                isPatrolMap = true;
                planInfoData.put("mapId", (Object)mapId);
                planInfoData.put("cameraSn", (Object)ivsDeviceIdList);
                planInfoData.put("cameraData", (Object)this.getCameraData(ivsDeviceIdList));
            }
            switch (planItem.getStatus()) {
                case "0": {
                    planInfoData.put("statusName", (Object)I18nUtil.i18nCode((String)"ivs_vidRtPatrol_notstart", (Object[])new Object[0]));
                    break;
                }
                case "1": {
                    planInfoData.put("statusName", (Object)I18nUtil.i18nCode((String)"ivs_vidRtPatrol_processing", (Object[])new Object[0]));
                    break;
                }
                case "2": {
                    planInfoData.put("statusName", (Object)I18nUtil.i18nCode((String)"ivs_vidRtPatrol_pause", (Object[])new Object[0]));
                    break;
                }
                default: {
                    planInfoData.put("statusName", (Object)I18nUtil.i18nCode((String)"ivs_vidRtPatrol_end", (Object[])new Object[0]));
                }
            }
            this.request.setAttribute("tempPoint", (Object)ivsRtPatrolItem);
            this.request.setAttribute("patrolPlanInfo", (Object)planInfoData.toString());
            this.request.setAttribute("patrolPlanIvsInfoList", (Object)ivsRtPatrolItem.getIvsPatrolIvsItemList());
            this.request.setAttribute("planStatus", (Object)planItem.getStatus());
        }
        this.request.setAttribute("id", (Object)(id == null ? "" : id));
        if (isPatrolMap) {
            return new ModelAndView("ivs/patrol/ivsRtGeneralPatrolMap");
        }
        return new ModelAndView("ivs/patrol/ivsRtGeneralPatrol");
    }

    private JSONArray getCameraData(List<String> ivsDeviceIdList) {
        JSONArray cameraData = new JSONArray();
        for (String id : ivsDeviceIdList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("deviceId", (Object)id);
            cameraData.add((Object)jsonObject);
        }
        return cameraData;
    }

    public ZKResultMsg getPatrolPlanResult(String planId, String shiftId) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)planId)) {
            IvsRtPatrolParamItem ivsRtPatrolItem = this.ivsPatrolPlanService.getInfoByPlanId(this.request.getSession().getId(), planId, shiftId);
            List ivsDeviceIdList = ivsRtPatrolItem.getIvsDeviceIdList();
            String format = ApplicationPropertiesUtil.getProperty((String)"biosecurity.date.sysDateFmt.alias", (String)"yyyy-MM-dd");
            JSONObject planInfoData = new JSONObject();
            IvsPatrolPlanItem planItem = ivsRtPatrolItem.getIvsPatrolPlanItem();
            planInfoData.put("planId", (Object)planId);
            planInfoData.put("shiftId", (Object)shiftId);
            planInfoData.put("name", (Object)planItem.getName());
            planInfoData.put("startDate", (Object)DateUtil.dateToLocaleString((Date)planItem.getStartDate(), (String)format));
            planInfoData.put("endDate", (Object)DateUtil.dateToLocaleString((Date)planItem.getEndDate(), (String)format));
            planInfoData.put("patrolGroupName", (Object)planItem.getPatrolGroupName());
            planInfoData.put("ivsAnswerCount", (Object)planItem.getIvsAnswerCount());
            planInfoData.put("patrolPlanCount", (Object)ivsDeviceIdList.size());
            planInfoData.put("status", (Object)planItem.getStatus());
            planInfoData.put("point", (Object)ivsRtPatrolItem.getPoint());
            planInfoData.put("alarm", (Object)ivsRtPatrolItem.getAlarm());
            planInfoData.put("checkIn", (Object)ivsRtPatrolItem.getCheckIn());
            planInfoData.put("missed", (Object)ivsRtPatrolItem.getMissed());
            planInfoData.put("timelot", (Object)ivsRtPatrolItem.getTimelot());
            planInfoData.put("planStatus", (Object)planItem.getStatus());
            planInfoData.put("completeName", (Object)I18nUtil.i18nCode((String)"ivs_vidRtPatrol_op_planComplete", (Object[])new Object[0]));
            planInfoData.put("pointName", (Object)I18nUtil.i18nCode((String)"ivs_ivsRtPatrol_point", (Object[])new Object[0]));
            planInfoData.put("alarmName", (Object)I18nUtil.i18nCode((String)"ivs_ivsRtPatrol_alarm", (Object[])new Object[0]));
            planInfoData.put("checkInName", (Object)I18nUtil.i18nCode((String)"ivs_ivsRtPatrol_checkIn", (Object[])new Object[0]));
            planInfoData.put("missedName", (Object)I18nUtil.i18nCode((String)"ivs_ivsRtPatrol_missed", (Object[])new Object[0]));
            switch (planItem.getStatus()) {
                case "0": {
                    planInfoData.put("statusName", (Object)I18nUtil.i18nCode((String)"ivs_vidRtPatrol_notstart", (Object[])new Object[0]));
                    break;
                }
                case "1": {
                    planInfoData.put("statusName", (Object)I18nUtil.i18nCode((String)"ivs_vidRtPatrol_processing", (Object[])new Object[0]));
                    break;
                }
                case "2": {
                    planInfoData.put("statusName", (Object)I18nUtil.i18nCode((String)"ivs_vidRtPatrol_pause", (Object[])new Object[0]));
                    break;
                }
                case "3": {
                    planInfoData.put("statusName", (Object)I18nUtil.i18nCode((String)"ivs_vidRtPatrol_end", (Object[])new Object[0]));
                }
            }
            zkResultMsg.setData((Object)planInfoData);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }
}

