/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsRequestLogRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsRequestLogService;
import com.zkteco.zkbiosecurity.ivs.utils.ApiIvsCheckUtil;
import com.zkteco.zkbiosecurity.ivs.utils.IVSUtil;
import com.zkteco.zkbiosecurity.ivs.vo.IvsRequestLogItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsRequestLogController
extends ExportController
implements IvsRequestLogRemote {
    @Autowired
    private IvsRequestLogService ivsRequestLogService;

    @RequiresPermissions(value={"ivs:requestLog"})
    public ModelAndView index() {
        return new ModelAndView("ivs/requestLog/ivsRequestLog");
    }

    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            IvsRequestLogItem item = this.ivsRequestLogService.getItemById(id);
            String content = "";
            String receive = "";
            if (Objects.nonNull(item)) {
                try {
                    content = item.getContent();
                    if (StringUtils.isNotBlank((CharSequence)content)) {
                        JSONObject contentJson = JSONObject.parseObject((String)content);
                        JSONObject vcmInfo = contentJson.getJSONObject("vcmInfo");
                        if ("7".equals(vcmInfo.getString("vcmType"))) {
                            String vcmSession = vcmInfo.getString("vcmSession");
                            vcmInfo.put("vcmSession", (Object)JSONObject.parseObject((String)vcmSession));
                            contentJson.put("vcmInfo", (Object)vcmInfo);
                            content = contentJson.toJSONString();
                        }
                        content = IVSUtil.replaceBlank(content);
                    }
                }
                catch (Exception e) {
                    content = item.getContent();
                }
                try {
                    receive = IVSUtil.replaceBlank(item.getReceive());
                }
                catch (Exception ee) {
                    receive = item.getReceive();
                }
            }
            this.request.setAttribute("requestParams", (Object)content);
            this.request.setAttribute("content", (Object)receive);
        }
        return new ModelAndView("ivs/requestLog/viewContent");
    }

    @RequiresPermissions(value={"ivs:ivsRequestLog:refresh"})
    public DxGrid list(IvsRequestLogItem condition) {
        Pager pager = this.ivsRequestLogService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        DxGrid data = GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
        data.getRows().forEach(item -> {
            JSONObject row = (JSONObject)item;
            if (I18nUtil.i18nCode((String)"common_failed", (Object[])new Object[0]).equals(row.getJSONArray("data").getString(4))) {
                row.put("style", (Object)"color:red");
            }
        });
        return data;
    }

    @RequiresPermissions(value={"ivs:ivsRequestLog:clear"})
    public ZKResultMsg clearData() {
        this.ivsRequestLogService.clearData();
        return ZKResultMsg.successMsg();
    }

    @RequiresPermissions(value={"ivs:ivsRequestLog:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        IvsRequestLogItem ivsRequestLogItem = new IvsRequestLogItem();
        this.setConditionValue((BaseItem)ivsRequestLogItem);
        List intemList = this.ivsRequestLogService.getItemData(ivsRequestLogItem, this.getBeginIndex(), this.getEndIndex());
        Map<String, String> map = ApiIvsCheckUtil.getColumnAndI18nByClass(IvsRequestLogItem.class);
        map.remove("id");
        HashMap allMap = new HashMap();
        HashMap<String, String> columnNameMap = new HashMap<String, String>();
        columnNameMap.put("jsonColumn", JSONObject.toJSONString(map));
        allMap.put("jsonColumn", columnNameMap);
        this.excelExport(intemList, IvsRequestLogItem.class, allMap);
    }
}

