/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.ivs.remote.IvsPersonnelListRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsAnalyseFaceService;
import com.zkteco.zkbiosecurity.ivs.service.IvsClientParentDeviceService;
import com.zkteco.zkbiosecurity.ivs.service.IvsDeviceService;
import com.zkteco.zkbiosecurity.ivs.service.IvsEdge2ListService;
import com.zkteco.zkbiosecurity.ivs.service.IvsEdgeDeviceService;
import com.zkteco.zkbiosecurity.ivs.service.IvsPersonnelListService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsDeviceItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsEdge2ListItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsEdgeDeviceItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsParentDevicePersonItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsPersonnelListItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsPersonnelListSelectItem;
import com.zkteco.zkbiosecurity.ivs.vo.pers.IvsPersListAlarmItem;
import com.zkteco.zkbiosecurity.pers.service.PersCertificateService;
import com.zkteco.zkbiosecurity.pers.service.PersPersonCacheService;
import com.zkteco.zkbiosecurity.pers.service.PersPersonnalListService;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonCacheItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonnalListItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsPersonnelListController
extends BaseController
implements IvsPersonnelListRemote {
    @Autowired
    private IvsEdgeDeviceService ivsEdgeDeviceService;
    @Autowired(required=false)
    private PersPersonnalListService persPersonnalListService;
    @Autowired
    private IvsEdge2ListService ivsEdge2ListService;
    @Autowired(required=false)
    private PersPersonCacheService persPersonCacheService;
    @Autowired
    private PersCertificateService persCertificateService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private IvsPersonnelListService ivsPersonnelListService;
    @Autowired
    private IvsDeviceService ivsDeviceService;
    @Autowired
    private IvsAnalyseFaceService ivsAnalyseFaceService;

    public ModelAndView index() {
        String domainCode = this.request.getParameter("domainCode");
        String pathType = this.request.getParameter("pathType");
        this.request.setAttribute("domainCode", (Object)domainCode);
        if (StringUtils.isNotBlank((CharSequence)domainCode)) {
            IvsEdgeDeviceItem item = this.ivsEdgeDeviceService.getItemByDomainCode(domainCode);
            this.request.setAttribute("parentDeviceId", (Object)item.getId());
            this.request.setAttribute("path", (Object)this.ivsEdgeDeviceService.getCachePhotoByDomainCode(domainCode));
        }
        if ("addPerson".equals(pathType)) {
            return new ModelAndView("ivs/personnelList/hwNewPerson");
        }
        return new ModelAndView("ivs/personnelList/hwPersonnelList");
    }

    public DxGrid list(IvsPersonnelListItem condition) {
        Pager pager = new Pager();
        if (StringUtils.isBlank((CharSequence)condition.getParentDeviceId())) {
            condition.setParentDeviceId(condition.getDeviceId());
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getParentDeviceId())) {
            List personnelListIds = this.ivsEdge2ListService.getPersonnelListIdsByParentDeviceId(condition.getParentDeviceId());
            if (Objects.nonNull(personnelListIds) && personnelListIds.size() > 0) {
                condition.setInId(StringUtils.join((Iterable)personnelListIds, (String)","));
                pager = this.persPersonnalListService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
                List list = pager.getData();
                this.getPersonnelListCount(list, this.ivsEdgeDeviceService.getPersonnelListPersonCount(condition.getParentDeviceId()));
                this.getPersonnelListDevType(list, condition.getParentDeviceId());
            }
        } else {
            pager = this.persPersonnalListService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
            List list = pager.getData();
            this.getPersonnelListCount(list, this.persPersonnalListService.getPersonnelListPersonCount());
        }
        if (Objects.isNull(pager.getData())) {
            pager.setData((List)Lists.newArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    private void getPersonnelListCount(List<IvsPersonnelListItem> list, Map<String, String> personnelListPersonCountMap) {
        list.forEach(item -> {
            String count = (String)personnelListPersonCountMap.get(item.getId());
            if (StringUtils.isBlank((CharSequence)count)) {
                item.setPersonCount("0");
            } else {
                item.setPersonCount(count);
            }
        });
    }

    private void getPersonnelListDevType(List<IvsPersonnelListItem> list, String parentDeviceId) {
        list.forEach(item -> {
            IvsEdgeDeviceItem ivsEdgeDeviceItem = this.ivsEdgeDeviceService.getItemById(parentDeviceId);
            if ("2".equals(ivsEdgeDeviceItem.getType())) {
                item.setShowFlag(Boolean.valueOf(true));
            }
        });
    }

    public DxGrid getPersonList(IvsParentDevicePersonItem condition) {
        String sessionId = this.request.getSession().getId();
        Pager pager = this.ivsPersonnelListService.getPersonPager(sessionId, condition, this.getPageNo(), this.getPageSize());
        List ivsParentDevicePersonItems = pager.getData();
        PersPersonnalListItem personnalListItem = this.persPersonnalListService.getItemById(condition.getPersonnelListId());
        if (Objects.nonNull(ivsParentDevicePersonItems)) {
            for (IvsParentDevicePersonItem ivsParentDevicePersonItem : ivsParentDevicePersonItems) {
                if ("5".equals(personnalListItem.getType())) {
                    ivsParentDevicePersonItem.setName(this.ivsEdgeDeviceService.convertToEncrypt(ivsParentDevicePersonItem.getName(), "vis.name.encryptProp", "vis.name.encryptMode"));
                    ivsParentDevicePersonItem.setLastName(this.ivsEdgeDeviceService.convertToEncrypt(ivsParentDevicePersonItem.getLastName(), "vis.lastName.encryptProp", "vis.lastName.encryptMode"));
                    continue;
                }
                ivsParentDevicePersonItem.setPin(this.ivsEdgeDeviceService.convertToEncrypt(ivsParentDevicePersonItem.getPin(), "pers.pin.encryptProp", "pers.pin.encryptMode"));
                ivsParentDevicePersonItem.setName(this.ivsEdgeDeviceService.convertToEncrypt(ivsParentDevicePersonItem.getName(), "pers.name.encryptProp", "pers.name.encryptMode"));
                ivsParentDevicePersonItem.setLastName(this.ivsEdgeDeviceService.convertToEncrypt(ivsParentDevicePersonItem.getLastName(), "pers.lastName.encryptProp", "pers.lastName.encryptMode"));
            }
        }
        DxGrid data = GridUtil.convert((Pager)pager, condition.getClass());
        data.getRows().forEach(item -> {
            JSONObject row = (JSONObject)item;
            if (I18nUtil.i18nCode((String)"common_failed", (Object[])new Object[0]).equals(row.getJSONArray("data").getString(3))) {
                row.put("style", (Object)"color:red");
            }
        });
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"ivs:parentDevice:faceList"})
    @LogChangeRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_parent_device_facePersonnelList", vo=IvsParentDevicePersonItem.class, service=IvsClientParentDeviceService.class)
    public ZKResultMsg addPerson(String parentDeviceId, String personnelListId, String personIds) {
        block13: {
            try {
                String clientId = this.request.getParameter("clientId");
                this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
                if (StringUtils.isBlank((CharSequence)personnelListId) || StringUtils.isBlank((CharSequence)personIds)) {
                    this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>");
                    ZKResultMsg zKResultMsg = ZKResultMsg.successMsg();
                    return zKResultMsg;
                }
                if (StringUtils.isNotBlank((CharSequence)parentDeviceId)) {
                    IvsDeviceItem ivsDeviceItem;
                    IvsEdgeDeviceItem ivsEdgeDeviceItem = this.ivsEdgeDeviceService.getItemById(parentDeviceId);
                    if (Objects.isNull(ivsEdgeDeviceItem) && Objects.isNull(ivsDeviceItem = this.ivsDeviceService.getItemById(parentDeviceId))) {
                        this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>");
                        ZKResultMsg zKResultMsg = ZKResultMsg.successMsg();
                        return zKResultMsg;
                    }
                    this.progressCache.setProcess(new ProcessBean(0, 50), clientId);
                    IvsPersonnelListController ivsPersonnelListController = this;
                    synchronized (ivsPersonnelListController) {
                        PersPersonnalListItem personnalListItem = this.persPersonnalListService.getItemById(personnelListId);
                        ZKResultMsg resultMsg = "5".equals(personnalListItem.getType()) ? this.ivsPersonnelListService.sendVisitorsToDev(parentDeviceId, personnelListId, personIds) : this.ivsEdgeDeviceService.sendPersonToDev(parentDeviceId, personnelListId, personIds);
                        if (Objects.nonNull(resultMsg.getData()) && StringUtils.isNotEmpty((CharSequence)resultMsg.getData().toString())) {
                            this.progressCache.setProcess(new ProcessBean(0, 90, "<font color='red'>" + resultMsg.getData().toString() + "</font><br/>"));
                        } else {
                            this.progressCache.setProcess(new ProcessBean(0, 90), clientId);
                        }
                        break block13;
                    }
                }
                this.persPersonnalListService.addPerson(personnelListId, personIds);
                this.progressCache.setProcess(new ProcessBean(0, 90), clientId);
            }
            finally {
                this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>", "", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
            }
        }
        return ZKResultMsg.successMsg();
    }

    @RequiresPermissions(value={"ivs:parentDevice:faceList"})
    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_parent_device_facePersonnelList", requestParams={"ids"}, opContent="common_op_del")
    public ZKResultMsg delPerson(String parentDeviceId, String personnelListId, String ids) {
        if (StringUtils.isBlank((CharSequence)parentDeviceId) || StringUtils.isBlank((CharSequence)personnelListId) || StringUtils.isBlank((CharSequence)ids)) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"ivs_data_incorrect", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        PersPersonnalListItem personnalListItem = this.persPersonnalListService.getItemById(personnelListId);
        if ("5".equals(personnalListItem.getType())) {
            return this.ivsPersonnelListService.delVisitor(parentDeviceId, personnelListId, ids);
        }
        return this.ivsEdgeDeviceService.delPerson(parentDeviceId, personnelListId, ids);
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_parent_device_facePersonnelList", requestParams={"ids"}, opContent="common_op_del")
    public ZKResultMsg delPersonnelList(String parentDeviceId, String ids) {
        if (StringUtils.isBlank((CharSequence)parentDeviceId) || StringUtils.isBlank((CharSequence)ids)) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"ivs_data_incorrect", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        return this.ivsEdgeDeviceService.delPersonnelList(parentDeviceId, ids);
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_parent_device_facePersonnelList", requestParams={"name", "pin"}, opContent="ivs_parentDevice_reSyncPersonnelList")
    public ZKResultMsg newPerson(IvsParentDevicePersonItem item, @RequestParam(value="personPhoto", required=false) MultipartFile file) {
        if (Objects.nonNull(file) && !file.isEmpty()) {
            String photoPath = FileUtil.saveFileToServer((String)"pers", (String)"user/avatar", (String)(item.getPin() + ".jpg"), (MultipartFile)file);
            item.setPhotoPath(photoPath);
        } else if (StringUtils.isNotBlank((CharSequence)item.getPhoto())) {
            String[] photo = StringUtils.split((String)item.getPhoto(), (String)",");
            String photoStr = item.getPhoto();
            if (photo.length > 1) {
                photoStr = photo[1];
            }
            String photoPath = FileUtil.saveFileToServer((String)"pers", (String)"user/avatar", (String)(item.getPin() + ".jpg"), (String)photoStr);
            item.setPhotoPath(photoPath);
        }
        return this.ivsPersonnelListService.newPerson(item);
    }

    public DxGrid selectPersonList(IvsParentDevicePersonItem condition) {
        Pager pager = new Pager();
        PersPersonnalListItem personnalListItem = this.persPersonnalListService.getItemById(condition.getPersonnelListId());
        if ("5".equals(personnalListItem.getType()) && !"selected".equals(condition.getType())) {
            pager = this.ivsPersonnelListService.getVisVisitorInfoByPage(condition, this.getPageNo(), this.getPageSize(), Boolean.valueOf(true));
            return GridUtil.convert((Pager)pager, condition.getClass());
        }
        if ("noSelected".equals(condition.getType())) {
            pager = this.ivsPersonnelListService.getNoExistPerson(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if ("selected".equals(condition.getType())) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid listSelect(IvsPersonnelListSelectItem condition) {
        Pager pager = this.ivsPersonnelListService.loadPersonnelList(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg reSendPersonnelList(IvsEdge2ListItem item) {
        return this.ivsPersonnelListService.reSendPersonnelList(item);
    }

    public ZKResultMsg getChannelSelectData(String parentDeviceId) {
        String sessionId = WebContextUtil.getCurrentSessionId();
        return new ZKResultMsg((Object)this.ivsAnalyseFaceService.getVidExtChannelSelectData(parentDeviceId, sessionId));
    }

    public ModelAndView toAlarmSet(String personnelListId, String parentDeviceId) {
        IvsPersListAlarmItem ivsPersListAlarmItem = this.ivsPersonnelListService.getHwPersListAlarmItem(personnelListId, parentDeviceId);
        this.request.setAttribute("item", (Object)ivsPersListAlarmItem);
        this.request.setAttribute("attributeItem", (Object)ivsPersListAlarmItem.getIvsPersAlarmSetItems());
        this.request.setAttribute("total", (Object)ivsPersListAlarmItem.getIvsPersAlarmSetItems().size());
        this.request.setAttribute("alarmOutSize", (Object)ivsPersListAlarmItem.getChnAlarmOutCount());
        this.request.setAttribute("parentDeviceId", (Object)parentDeviceId);
        return new ModelAndView("ivs/personnelList/personnelListAlarmSet");
    }

    public ZKResultMsg saveAlarmSetList(IvsPersListAlarmItem condition) {
        ZKResultMsg zkResultMsg = this.ivsPersonnelListService.saveAlarmSetList(condition);
        return zkResultMsg;
    }

    public TreeItem tree(String count) {
        return this.ivsPersonnelListService.getChannelTree(count);
    }

    public TreeItem treeSet(String key) {
        String[] listArray = StringUtils.split((String)key, (String)",");
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        for (int i = 0; i < listArray.length; ++i) {
            TreeItem item = new TreeItem();
            item.setId(String.valueOf(i + 1));
            item.setText(listArray[i]);
            item.setParent(new TreeItem("0"));
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public ZKResultMsg getPersonByPin(String pin) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        JSONObject jsonObject = new JSONObject();
        PersPersonCacheItem item = this.persPersonCacheService.getPersonCacheByPin(pin);
        if (Objects.nonNull(item)) {
            String photoPath = item.getPhotoPath();
            if (StringUtils.isNotBlank((CharSequence)photoPath)) {
                String decryptFileBase64 = FileEncryptUtil.getDecryptFileBase64((String)photoPath);
                item.setPhotoPath(decryptFileBase64);
            }
            jsonObject.put("persPersonItem", (Object)item);
        }
        zkResultMsg.setData((Object)jsonObject);
        return zkResultMsg;
    }

    public ZKResultMsg getPersonListPersonItem(String personId) {
        IvsParentDevicePersonItem ivsEdge2ListItem = this.ivsEdge2ListService.getPersonListPersonItem(personId);
        return new ZKResultMsg((Object)ivsEdge2ListItem);
    }
}

