/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsPatrolReportRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsPatrolReportService;
import com.zkteco.zkbiosecurity.ivs.vo.patrol.IvsPatrolReportItem;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsPatrolReportController
extends ExportController
implements IvsPatrolReportRemote {
    @Autowired
    private IvsPatrolReportService ivsPatrolReportService;

    public ModelAndView index() {
        return new ModelAndView("ivs/patrolReport/ivsPatrolReport");
    }

    public DxGrid list(IvsPatrolReportItem condition) {
        Pager pager = this.ivsPatrolReportService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    public ZKResultMsg getPatrolPhotoInfo(String photoPath) {
        String filePath = "";
        if (StringUtils.isNotBlank((CharSequence)photoPath)) {
            filePath = this.ivsPatrolReportService.getBase64ByPath(photoPath);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)filePath));
    }

    public ZKResultMsg uploadReport(IvsPatrolReportItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)this.ivsPatrolReportService.uploadReport(this.request.getSession().getId(), item)));
    }

    public ModelAndView getReportInfo(String planId, String shiftId) {
        IvsPatrolReportItem item = this.ivsPatrolReportService.getReportInfo(this.request.getSession().getId(), planId, shiftId);
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("ivs/patrol/editPatrolReport");
    }

    public ZKResultMsg getItemById(String id) {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)this.ivsPatrolReportService.getItemById(id)));
    }

    public void export(HttpServletRequest request, HttpServletResponse response) {
        IvsPatrolReportItem item = new IvsPatrolReportItem();
        this.setConditionValue((BaseItem)item);
        List itemList = this.ivsPatrolReportService.getItemDate(item, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, IvsPatrolReportItem.class);
    }
}

