/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ivs.remote.IvsPatrolPlanRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsPatrolPlanService;
import com.zkteco.zkbiosecurity.ivs.service.IvsPatrolShiftService;
import com.zkteco.zkbiosecurity.ivs.vo.patrol.IvsPatrolChannelSelectItem;
import com.zkteco.zkbiosecurity.ivs.vo.patrol.IvsPatrolEmailSettingItem;
import com.zkteco.zkbiosecurity.ivs.vo.patrol.IvsPatrolPlanItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsPatrolPlanController
extends BaseController
implements IvsPatrolPlanRemote {
    @Autowired
    private IvsPatrolPlanService ivsPatrolPlanService;
    @Autowired
    private IvsPatrolShiftService ivsPatrolShiftService;

    @RequiresPermissions(value={"ivs:patrolPlan"})
    public ModelAndView index() {
        return new ModelAndView("ivs/patrolPlan/ivsPatrolPlan");
    }

    @RequiresPermissions(value={"ivs:patrolPlan:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            IvsPatrolPlanItem item = this.ivsPatrolPlanService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("ivs/patrolPlan/editIvsPatrolPlan");
    }

    @RequiresPermissions(value={"ivs:patrolPlan:edit"})
    public ZKResultMsg save(IvsPatrolPlanItem item) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)item.getId()) && this.ivsPatrolPlanService.validatePlanIsUsed(item.getId())) {
            throw new ZKBusinessException(I18nUtil.i18nCode((String)"ivs_patrolPlan_isUsed", (Object[])new Object[0]));
        }
        this.ivsPatrolPlanService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequiresPermissions(value={"ivs:patrolPlan:refresh"})
    public DxGrid list(IvsPatrolPlanItem condition) {
        Pager pager = this.ivsPatrolPlanService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ivs:patrolPlan:del"})
    public ZKResultMsg del(String ids) {
        this.ivsPatrolPlanService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isExistByName(String name) {
        IvsPatrolPlanItem ivsPatrolPlanItem = this.ivsPatrolPlanService.getItemByName(name);
        return Objects.isNull(ivsPatrolPlanItem);
    }

    public ZKResultMsg getPatrolShiftsByStatus(String status) {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)this.ivsPatrolPlanService.getPatrolShiftsByStatus(this.request.getSession().getId(), status)));
    }

    public ZKResultMsg getPatrolTaskCount() {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)this.ivsPatrolPlanService.getPatrolTaskCount(this.request.getSession().getId())));
    }

    public ZKResultMsg getNextIvsDevice(String planId, String shiftId, String previousIvsDevId, boolean isLinkMap) {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)this.ivsPatrolPlanService.getNextIvsDevice(this.request.getSession().getId(), planId, shiftId, previousIvsDevId, isLinkMap)));
    }

    public ZKResultMsg checkPlanShiftUser(String planId, String shiftId) {
        this.ivsPatrolPlanService.checkPlanShiftUser(this.request.getSession().getId(), planId, shiftId);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg ivsColckIn(String planId, String shiftId, String channelId) {
        this.ivsPatrolPlanService.ivsColckIn(planId, shiftId, channelId);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public ZKResultMsg setPatrolShiftStatus(String planId, String shiftId, String status) {
        this.ivsPatrolShiftService.setPatrolShiftStatus(this.request.getSession().getId(), planId, shiftId, status);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public ZKResultMsg getPatrolPlanMapData() {
        return new ZKResultMsg((Object)this.ivsPatrolPlanService.getPatrolPlanMapData(this.request.getSession().getId()));
    }

    public DxGrid ivsPatrolSelectList(IvsPatrolChannelSelectItem condition) {
        return GridUtil.convert((Pager)this.ivsPatrolPlanService.getPatrolChannelsByPage(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize()), condition.getClass());
    }

    public ZKResultMsg sendEmail(String patrolPlanIds, IvsPatrolEmailSettingItem item) {
        return this.ivsPatrolPlanService.sendEmail(patrolPlanIds, item);
    }

    public ModelAndView viewEmailSetting(String patrolPlanId) {
        IvsPatrolEmailSettingItem ivsPatrolEmailSettingItem = this.ivsPatrolPlanService.getEmailSetting(patrolPlanId);
        this.request.setAttribute("item", (Object)ivsPatrolEmailSettingItem);
        return new ModelAndView("ivs/patrolPlan/viewEmailSetting");
    }
}

