/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ivs.remote.IvsPatrolGroupRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsPatrolGroupService;
import com.zkteco.zkbiosecurity.ivs.vo.patrol.IvsPatrolGroupItem;
import com.zkteco.zkbiosecurity.ivs.vo.patrol.IvsPatrolGroupSelectUserItem;
import com.zkteco.zkbiosecurity.ivs.vo.patrol.IvsPatrolGroupUserItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsPatrolGroupController
extends BaseController
implements IvsPatrolGroupRemote {
    @Autowired
    private IvsPatrolGroupService ivsPatrolGroupService;

    @RequiresPermissions(value={"ivs:patrolGroup"})
    public ModelAndView index() {
        return new ModelAndView("ivs/patrolGroup/ivsPatrolGroup");
    }

    @RequiresPermissions(value={"ivs:patrolGroup:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.ivsPatrolGroupService.getItemById(id));
        }
        return new ModelAndView("ivs/patrolGroup/editIvsPatrolGroup");
    }

    @RequiresPermissions(value={"ivs:patrolGroup:edit"})
    @LogRequest(module="ivs_module", object="ivs_leftMenu_ivsPatrolGroup", opType="common_op_edit", requestParams={"name"}, opContent="ivs_patrolGroup_name")
    public ZKResultMsg save(IvsPatrolGroupItem item) {
        this.ivsPatrolGroupService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"ivs:patrolGroup:refresh"})
    public DxGrid list(IvsPatrolGroupItem condition) {
        Pager pager = this.ivsPatrolGroupService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ivs:patrolGroup:del"})
    @LogRequest(module="ivs_module", object="ivs_leftMenu_ivsPatrolGroup", opType="common_op_del", requestParams={"names"}, opContent="ivs_patrolGroup_name")
    public ZKResultMsg del(String ids) {
        this.ivsPatrolGroupService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean valid(String name) {
        IvsPatrolGroupItem item = this.ivsPatrolGroupService.getItemByName(name);
        return Objects.isNull(item);
    }

    @RequiresPermissions(value={"ivs:patrolGroup:addUser"})
    @LogRequest(module="ivs_module", object="ivs_leftMenu_ivsPatrolGroup", opType="ivs_patrolGroup_addUser", requestParams={"groupName", "userNames"}, opContent="ivs_patrolGroup_addUser")
    public ZKResultMsg addUser(String patrolGroupId, String userIds) {
        this.ivsPatrolGroupService.addUser(patrolGroupId, userIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"ivs:patrolGroup:delUser"})
    @LogRequest(module="ivs_module", object="ivs_leftMenu_ivsPatrolGroup", opType="ivs_patrolGroup_delUser", requestParams={"groupName", "userNames"}, opContent="ivs_patrolGroup_delUser")
    public ZKResultMsg delUser(String patrolGroupId, String userIds) {
        this.ivsPatrolGroupService.delUser(patrolGroupId, userIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid patrolGroupSelectUserList(IvsPatrolGroupSelectUserItem condition) {
        condition.setIsSuperuser(Boolean.valueOf(false));
        if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
            condition.setSelectId("-1");
        }
        if ("noSelected".equals(condition.getType())) {
            condition.setSelectUserIdsNotIn(condition.getSelectId());
        } else if ("selected".equals(condition.getType())) {
            condition.setSelectUserIdsIn(condition.getSelectId());
        }
        Pager pager = this.ivsPatrolGroupService.patrolGroupSelectUserList(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ivs:patrolGroup:refreshUser"})
    public DxGrid patrolGroupUserList(IvsPatrolGroupUserItem condition) {
        Pager pager = this.ivsPatrolGroupService.patrolGroupUserList(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg getPatrolGroupList() {
        return new ZKResultMsg((Object)this.ivsPatrolGroupService.getPatrolGroupList(this.request.getSession().getId()));
    }
}

