/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsPatrolAlarmReportRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsPatrolAlarmReportService;
import com.zkteco.zkbiosecurity.ivs.vo.patrol.IvsAlarmPhotoPathParams;
import com.zkteco.zkbiosecurity.ivs.vo.patrol.IvsPatrolAlarmReportItem;
import com.zkteco.zkbiosecurity.ivs.vo.patrol.IvsSimplePatrolAlarmReportItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsPatrolAlarmReportController
extends ExportController
implements IvsPatrolAlarmReportRemote {
    @Autowired
    private IvsPatrolAlarmReportService ivsPatrolAlarmReportService;

    public ModelAndView index() {
        return new ModelAndView("ivs/patrolReport/ivsPatrolAlarmReport");
    }

    public DxGrid list(IvsPatrolAlarmReportItem condition) {
        Pager pager = this.ivsPatrolAlarmReportService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    public ZKResultMsg uploadAlarmReport(IvsPatrolAlarmReportItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)this.ivsPatrolAlarmReportService.uploadAlarmReport(item)));
    }

    public ModelAndView getAlarmInfo(String planId, String shiftId, String isLastIvs, String ivsParentDevId, String channelCode, String channelId, boolean isLinkMap) {
        IvsPatrolAlarmReportItem item = this.ivsPatrolAlarmReportService.getAlarmReportInfo(this.request.getSession().getId(), planId, shiftId, isLastIvs, ivsParentDevId, channelCode, channelId);
        this.request.setAttribute("item", (Object)item);
        this.request.setAttribute("isLinkMap", (Object)isLinkMap);
        return new ModelAndView("ivs/patrol/editAlarmReport");
    }

    public ZKResultMsg getAlarmPhotoPath(IvsAlarmPhotoPathParams vidAlarmPhotoPathParams) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        zkResultMsg.setData((Object)this.ivsPatrolAlarmReportService.getAlarmReportPhotoPath(vidAlarmPhotoPathParams.getChannelId()));
        return zkResultMsg;
    }

    public DxGrid simplList(IvsSimplePatrolAlarmReportItem condition) {
        Pager pager = this.ivsPatrolAlarmReportService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ivs:patrolAlarmReport:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        IvsPatrolAlarmReportItem item = new IvsPatrolAlarmReportItem();
        this.setConditionValue((BaseItem)item);
        List itemList = this.ivsPatrolAlarmReportService.getItemDate(item, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, IvsPatrolAlarmReportItem.class);
    }
}

