/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.ivs.remote.IvsParentDeviceRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsEdgeDeviceService;
import com.zkteco.zkbiosecurity.ivs.service.IvsPersonnelListService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsAddDeviceResultItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsAddParentDeviceResultItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsCameraSearchReqItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsClientParentDeviceItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsDeviceItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsEdgeDeviceItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsParentDeicePersonalListItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsParentDevicePersonItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsParentDeviceSearchItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsSearchCameraItem;
import com.zkteco.zkbiosecurity.ivs.vo.pers.IvsPersonnalListSelectItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsParentDeviceController
extends BaseController
implements IvsParentDeviceRemote {
    @Autowired
    private IvsEdgeDeviceService ivsEdgeDeviceService;
    @Autowired
    private IvsPersonnelListService ivsPersonnelListService;
    @Autowired
    private ProgressCache progressCache;

    @RequiresPermissions(value={"ivs:parentdevice"})
    public ModelAndView index() {
        return new ModelAndView("ivs/parentdevice/vidParentDevice");
    }

    @RequiresPermissions(value={"ivs:parentDevice:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.ivsEdgeDeviceService.getItemById(id));
        } else {
            IvsEdgeDeviceItem ivsEdgeDeviceItem = new IvsEdgeDeviceItem();
            ivsEdgeDeviceItem.setDomainCode(String.valueOf(System.currentTimeMillis()));
            this.request.setAttribute("item", (Object)ivsEdgeDeviceItem);
        }
        return new ModelAndView("ivs/parentdevice/editVidParentDevice");
    }

    @RequiresPermissions(value={"ivs:parentDevice:edit"})
    public ZKResultMsg save(IvsEdgeDeviceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.ivsEdgeDeviceService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ivs:parentDevice:refresh"})
    public DxGrid list(IvsEdgeDeviceItem condition) {
        Pager pager = this.ivsEdgeDeviceService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ivs:parentDevice:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.ivsEdgeDeviceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public DxGrid getPersonnelListById(String parentDevId, IvsParentDeicePersonalListItem condition) {
        Pager pager = this.ivsEdgeDeviceService.getPersonnelListPagerById(parentDevId, condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg sendPersonToDev(String ids, String personnelListIds, String personIds) {
        return this.ivsEdgeDeviceService.sendPersonToDev(ids, personnelListIds, personIds);
    }

    public DxGrid selectPersonlist(IvsPersonnalListSelectItem condition) {
        Pager pager = new Pager();
        if ("noSelected".equals(condition.getType())) {
            pager = this.ivsEdgeDeviceService.getPersonnelList(condition, this.getPageNo(), this.getPageSize(), false);
        } else if ("selected".equals(condition.getType())) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectExistPersonnelList(IvsPersonnalListSelectItem condition) {
        Pager pager = new Pager();
        if ("noSelected".equals(condition.getType())) {
            pager = this.ivsEdgeDeviceService.getPersonnelList(condition, this.getPageNo(), this.getPageSize(), true);
        } else if ("selected".equals(condition.getType())) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZKResultMsg addPersonnelList(String parentDeviceId, String personnelListIds) {
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
        IvsParentDeviceController ivsParentDeviceController = this;
        synchronized (ivsParentDeviceController) {
            return this.ivsEdgeDeviceService.addPersonnelList(parentDeviceId, personnelListIds, true);
        }
    }

    public ZKResultMsg delPersonnelList(String parentDeviceId, String personnelListIds) {
        return this.ivsEdgeDeviceService.delPersonnelList(parentDeviceId, personnelListIds);
    }

    public ZKResultMsg delPerson(String parentDeviceId, String personnelListIds, String personIds) {
        return this.ivsEdgeDeviceService.delPerson(parentDeviceId, personnelListIds, personIds);
    }

    public DxGrid getPersonList(IvsParentDevicePersonItem condition) {
        String sessionId = this.request.getSession().getId();
        Pager pager = this.ivsPersonnelListService.getPersonPager(sessionId, condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public TreeItem tree() {
        List ivsEdgeDeviceItemList = this.ivsEdgeDeviceService.getDevListWithStatusByAuthFilter(this.request.getSession().getId(), new IvsEdgeDeviceItem());
        ArrayList items = Lists.newArrayList();
        TreeItem item = null;
        TreeItem pItem = null;
        for (IvsEdgeDeviceItem ivsEdgeDeviceItem : ivsEdgeDeviceItemList) {
            if ("2".equals(ivsEdgeDeviceItem.getIsFromType())) continue;
            item = new TreeItem();
            item.setId(ivsEdgeDeviceItem.getId());
            item.setText(ivsEdgeDeviceItem.getName());
            pItem = new TreeItem("0");
            item.setParent(pItem);
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList((Collection)items);
        return new TreeItem("0", treeItems);
    }

    public ZKResultMsg getAccTree() {
        IvsEdgeDeviceItem parentDeviceItem = new IvsEdgeDeviceItem();
        parentDeviceItem.setType("0");
        List ivsEdgeDeviceItemList = this.ivsEdgeDeviceService.getByCondition(parentDeviceItem);
        ArrayList items = Lists.newArrayList();
        for (IvsEdgeDeviceItem ivsEdgeDeviceItem : ivsEdgeDeviceItemList) {
            items.add(new SelectItem((Object)ivsEdgeDeviceItem.getName(), ivsEdgeDeviceItem.getId()));
        }
        return new ZKResultMsg((Object)items);
    }

    public ZKResultMsg getOptionTree() {
        IvsEdgeDeviceItem condition = new IvsEdgeDeviceItem();
        List ivsEdgeDeviceItemList = this.ivsEdgeDeviceService.getByCondition(condition);
        ArrayList items = Lists.newArrayList();
        for (IvsEdgeDeviceItem ivsEdgeDeviceItem : ivsEdgeDeviceItemList) {
            if ("7".equals(ivsEdgeDeviceItem.getType())) continue;
            items.add(new SelectItem((Object)ivsEdgeDeviceItem.getName(), ivsEdgeDeviceItem.getId()));
        }
        return new ZKResultMsg((Object)items);
    }

    public ZKResultMsg getItemById(String parentDeviceId) {
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        if (StringUtils.isNotBlank((CharSequence)parentDeviceId)) {
            IvsEdgeDeviceItem ivsEdgeDeviceItem = this.ivsEdgeDeviceService.getItemByAcc(parentDeviceId);
            if (Objects.nonNull(ivsEdgeDeviceItem)) {
                resultMsg.setData((Object)ivsEdgeDeviceItem);
            } else {
                resultMsg.setRet("fail");
            }
        } else {
            resultMsg.setRet("fail");
        }
        return resultMsg;
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_vid_parentDevice_syncTime", requestParams={"names"}, opContent="ivs_vid_parentDevice_syncTime")
    public ZKResultMsg syncTime(String ids) {
        return this.ivsEdgeDeviceService.syncTime(ids);
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_vid_parentDevice_subscription", requestParams={"names"}, opContent="ivs_vid_parentDevice_subscription")
    public ZKResultMsg addSub(String ids) {
        return this.ivsEdgeDeviceService.subscription(ids, Boolean.valueOf(true));
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_vid_parentDevice_unsuscription", requestParams={"names"}, opContent="ivs_vid_parentDevice_unsuscription")
    public ZKResultMsg cancelSub(String ids) {
        return this.ivsEdgeDeviceService.subscription(ids, Boolean.valueOf(false));
    }

    public ZKResultMsg getVidExtDeviceSelectDataNvr800() {
        String sessionId = WebContextUtil.getCurrentSessionId();
        return new ZKResultMsg((Object)this.ivsEdgeDeviceService.getVidExtDeviceSelectDataNvr800(sessionId));
    }

    public ZKResultMsg getChannelCodeSelectDataNvr800(String vidExtParentDeviceId) {
        return new ZKResultMsg((Object)this.ivsEdgeDeviceService.getChannelCodeSelectDataNvr800(vidExtParentDeviceId));
    }

    public ZKResultMsg getPersonnalListSelectDataNvr800(String vidExtParentDeviceId) {
        return new ZKResultMsg((Object)this.ivsEdgeDeviceService.getPersonnalListSelectDataNvr800(vidExtParentDeviceId));
    }

    public ZKResultMsg getSdcSelectData(String parentDeviceId) {
        return new ZKResultMsg((Object)this.ivsEdgeDeviceService.getSdcSelectData(parentDeviceId));
    }

    public ZKResultMsg getAlgorithmSelectDataIvs1800(String parentDeviceId) {
        return new ZKResultMsg((Object)this.ivsEdgeDeviceService.getAlgorithmSelectDataIvs1800(parentDeviceId));
    }

    public TreeItem getGroupTree(String vidExtDeviceId) {
        return this.ivsEdgeDeviceService.getGroupTree(vidExtDeviceId);
    }

    public ZKResultMsg cameraAutoSearch(IvsCameraSearchReqItem condition) {
        return this.ivsEdgeDeviceService.cameraAutoSearch(condition);
    }

    public ZKResultMsg ivsParentDeviceSearch(Map<String, String> params) {
        return this.ivsEdgeDeviceService.ivsEdgeDeviceSearch(params);
    }

    public ZKResultMsg existDeviceSearch() {
        return this.ivsEdgeDeviceService.existDeviceSearch();
    }

    public DxGrid getSearchCameras(String isSearchFinish, String parentDeviceId) {
        Pager pager = this.ivsEdgeDeviceService.getSearchCameras(isSearchFinish, parentDeviceId);
        return GridUtil.convert((Pager)pager, IvsSearchCameraItem.class);
    }

    public DxGrid getSearchParentDevices(String isSearchFinish) {
        Pager pager = this.ivsEdgeDeviceService.getSearchEdgeDevices(isSearchFinish);
        return GridUtil.convert((Pager)pager, IvsParentDeviceSearchItem.class);
    }

    public ZKResultMsg addAllCameras(List<IvsDeviceItem> condition) {
        if (Objects.nonNull(condition) && condition.size() > 0 && StringUtils.isNotBlank((CharSequence)condition.get(0).getVidParentDeviceId())) {
            IvsEdgeDeviceItem ivsEdgeDeviceItem = this.ivsEdgeDeviceService.getItemById(condition.get(0).getVidParentDeviceId());
            for (IvsDeviceItem ivsDeviceItem : condition) {
                ivsDeviceItem.setNvrCode(ivsEdgeDeviceItem.getDomainCode());
                ivsDeviceItem.setDomainCode(ivsEdgeDeviceItem.getDomainCode());
                ivsDeviceItem.setParentType(ivsEdgeDeviceItem.getType());
                if ("0".equals(ivsEdgeDeviceItem.getType())) {
                    ivsDeviceItem.setLoginType("0");
                    continue;
                }
                ivsDeviceItem.setLoginType("1");
            }
            return this.ivsEdgeDeviceService.addAllCameras(ivsEdgeDeviceItem, condition, this.request.getSession().getId());
        }
        return ZKResultMsg.failMsg();
    }

    public DxGrid getCameraAddResult(String parentDeviceId) {
        Pager pager = this.ivsEdgeDeviceService.getCameraAddResult(parentDeviceId);
        return GridUtil.convert((Pager)pager, IvsAddDeviceResultItem.class);
    }

    public ZKResultMsg addAllParentDevices(List<IvsClientParentDeviceItem> condition) {
        return this.ivsEdgeDeviceService.addAllEdgeDevices(condition);
    }

    public DxGrid getParentDeviceAddResult() {
        Pager pager = this.ivsEdgeDeviceService.getEdgeDeviceAddResult();
        return GridUtil.convert((Pager)pager, IvsAddParentDeviceResultItem.class);
    }
}

