/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ivs.remote.IvsParamsRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsEdgeDeviceService;
import com.zkteco.zkbiosecurity.ivs.service.IvsParamsService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsCloudUserItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsEdgeDeviceItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsParamsController
extends BaseController
implements IvsParamsRemote {
    @Autowired
    private IvsParamsService ivsParamsService;
    @Autowired
    private IvsEdgeDeviceService ivsEdgeDeviceService;

    @RequiresPermissions(value={"system:params"})
    public ModelAndView index() {
        Map ivsParams = this.ivsParamsService.getIvsParams();
        this.request.setAttribute("ivsParams", (Object)ivsParams);
        IvsEdgeDeviceItem parentDeviceItem = new IvsEdgeDeviceItem();
        parentDeviceItem.setType("0");
        List ivs1800DeviceList = this.ivsEdgeDeviceService.getByCondition(parentDeviceItem);
        this.request.setAttribute("ivs1800DeviceList", (Object)ivs1800DeviceList);
        IvsCloudUserItem cloudUserInfo = this.ivsEdgeDeviceService.getCloudUserInfo();
        this.request.setAttribute("cloudUserInfo", (Object)cloudUserInfo);
        return new ModelAndView("ivs/params/ivsParams");
    }

    public ZKResultMsg save(@RequestParam Map<String, String> params) {
        ZKResultMsg res = new ZKResultMsg();
        this.ivsParamsService.saveItem(params);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public TreeItem getIpTree() {
        List ipList = this.ivsParamsService.getServerIpList();
        ArrayList items = Lists.newArrayList();
        TreeItem pItem = new TreeItem("0");
        for (String ip : ipList) {
            TreeItem item = new TreeItem();
            item.setId(ip);
            item.setText(ip);
            item.setParent(pItem);
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList((Collection)items);
        return new TreeItem("0", treeItems);
    }
}

