/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsObjectStatisticsRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsObjectStatisticsService;
import com.zkteco.zkbiosecurity.ivs.utils.ApiIvsCheckUtil;
import com.zkteco.zkbiosecurity.ivs.vo.IvsObjectStatisticsExportItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsObjectStatisticsReqItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsObjectStatisticsController
extends ExportController
implements IvsObjectStatisticsRemote {
    @Autowired
    private IvsObjectStatisticsService ivsObjectStatisticsService;

    @RequiresPermissions(value={"ivs:objectStatistics"})
    public ModelAndView index() {
        return new ModelAndView("ivs/statistic/objectStatistics");
    }

    public ZKResultMsg getObjectStatisticsReportData(IvsObjectStatisticsReqItem item) {
        return this.ivsObjectStatisticsService.getObjectStatisticsReportData(item);
    }

    public void export() {
        List ivsObjectStatisticsExportItems = this.ivsObjectStatisticsService.getExportData();
        Map<String, String> map = ApiIvsCheckUtil.getColumnAndI18nByClass(IvsObjectStatisticsExportItem.class);
        HashMap allMap = new HashMap();
        HashMap<String, String> tableNameMap = new HashMap<String, String>();
        HashMap<String, String> columnNameMap = new HashMap<String, String>();
        tableNameMap.put("tableName", I18nUtil.i18nCode((String)"ivs_ObjectStatistics", (Object[])new Object[0]));
        columnNameMap.put("jsonColumn", JSONObject.toJSONString(map));
        allMap.put("tableName", tableNameMap);
        allMap.put("jsonColumn", columnNameMap);
        this.excelExport(ivsObjectStatisticsExportItems, IvsObjectStatisticsExportItem.class, allMap);
    }
}

