/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ivs.remote.IvsMultiAircraftRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsEdgeDeviceService;
import com.zkteco.zkbiosecurity.ivs.service.IvsMultiAircraftService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsEdgeDeviceItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsMultiAircraftItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsMultiAircraftMainItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsMultiAircraftController
extends BaseController
implements IvsMultiAircraftRemote {
    @Autowired
    private IvsMultiAircraftService ivsMultiAircraftService;
    @Autowired
    private IvsEdgeDeviceService ivsEdgeDeviceService;

    public ModelAndView index() {
        String domainCode = this.request.getParameter("domainCode");
        this.request.setAttribute("domainCode", (Object)domainCode);
        if (StringUtils.isNotBlank((CharSequence)domainCode)) {
            IvsEdgeDeviceItem item = this.ivsEdgeDeviceService.getItemByDomainCode(domainCode);
            this.request.setAttribute("parentDeviceId", (Object)item.getId());
        }
        return new ModelAndView("ivs/multiAircraft/ivsMultiAircraft");
    }

    public DxGrid list(IvsMultiAircraftMainItem condition) {
        Pager pager = this.ivsMultiAircraftService.getHwMultiAircraftForm(condition.getParentDeviceId(), "master_device", null);
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid fromList(IvsMultiAircraftMainItem condition) {
        Pager pager = this.ivsMultiAircraftService.getHwMultiAircraftForm(condition.getParentDeviceId(), "secondary_device", null);
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid mainFromList(IvsMultiAircraftItem condition) {
        Pager pager = this.ivsMultiAircraftService.getHwMultiAircraftForm(condition.getParentDeviceId(), "master_device", "mainFormDevice");
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ivs:aircraft:edit"})
    public ModelAndView editStatus(String item, String parentDeviceId) {
        if (StringUtils.isNotBlank((CharSequence)item)) {
            JSONObject itemObject = JSONObject.parseObject((String)item);
            itemObject.put("parentDeviceId", (Object)parentDeviceId);
            this.request.setAttribute("editPage", (Object)true);
            this.request.setAttribute("item", (Object)itemObject);
        }
        return new ModelAndView("ivs/multiAircraft/editHwMultiAircraft");
    }

    @RequiresPermissions(value={"ivs:aircraft:edit"})
    public ZKResultMsg editSave(IvsMultiAircraftMainItem item) {
        ZKResultMsg zkResultMsg = this.ivsMultiAircraftService.setOpenStatus(item);
        return zkResultMsg;
    }

    @RequiresPermissions(value={"ivs:aircraft:delete"})
    public ZKResultMsg delete(String item, String parentDeviceId) {
        ZKResultMsg res = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)item)) {
            JSONObject itemObject = JSONObject.parseObject((String)item);
            itemObject.put("parentDeviceId", (Object)parentDeviceId);
            ZKResultMsg zkResultMsg = this.ivsMultiAircraftService.delBingChannel(itemObject);
            return zkResultMsg;
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ivs:aircraft:bind"})
    public ModelAndView bingDevice(String mainChannelCode, String fromChannelCode, String parentDeviceId) {
        if (StringUtils.isNotBlank((CharSequence)mainChannelCode) && StringUtils.isNotBlank((CharSequence)fromChannelCode)) {
            JSONObject itemObject = new JSONObject();
            itemObject.put("parentDeviceId", (Object)parentDeviceId);
            itemObject.put("mainChannelCode", (Object)mainChannelCode);
            itemObject.put("fromChannelCode", (Object)fromChannelCode);
            this.request.setAttribute("editPage", (Object)true);
            this.request.setAttribute("item", (Object)itemObject);
        }
        return new ModelAndView("ivs/multiAircraft/bingMainChannel");
    }

    @RequiresPermissions(value={"ivs:aircraft:bind"})
    public ZKResultMsg bingSave(IvsMultiAircraftMainItem item) {
        ZKResultMsg zkResultMsg = this.ivsMultiAircraftService.bingSave(item);
        return zkResultMsg;
    }

    public ZKResultMsg getOptionTree() {
        IvsEdgeDeviceItem condition = new IvsEdgeDeviceItem();
        condition.setType("2");
        List ivsEdgeDeviceItemList = this.ivsEdgeDeviceService.getByCondition(condition);
        ArrayList items = Lists.newArrayList();
        for (IvsEdgeDeviceItem ivsEdgeDeviceItem : ivsEdgeDeviceItemList) {
            items.add(new SelectItem((Object)ivsEdgeDeviceItem.getName(), ivsEdgeDeviceItem.getId()));
        }
        return new ZKResultMsg((Object)items);
    }
}

