/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ivs.remote.IvsMapRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsChannelService;
import com.zkteco.zkbiosecurity.ivs.service.IvsMapPosService;
import com.zkteco.zkbiosecurity.ivs.service.IvsMapService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsChannelItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsMapItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsMapPosItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsMapSelectChannelItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsMapController
extends BaseController
implements IvsMapRemote {
    @Autowired
    private IvsMapService ivsMapService;
    @Autowired
    private IvsMapPosService ivsMapPosService;
    @Autowired
    private IvsChannelService ivsChannelService;
    @Value(value="${system.filePath:BioSecurityFile}")
    private String systemFilePath;

    @RequiresPermissions(value={"ivs:map:video"})
    public ModelAndView index() {
        this.request.setAttribute("isClient", (Object)this.request.getParameter("isClient"));
        return new ModelAndView("ivs/map/ivsMap");
    }

    @RequiresPermissions(value={"ivs:map:add", "ivs:map:edit"})
    public ModelAndView edit(String id) {
        String parentId = this.request.getParameter("parentId");
        String parentType = this.request.getParameter("parentType");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.ivsMapService.getItemById(id));
            this.request.setAttribute("editPage", (Object)true);
        }
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            this.request.setAttribute("parentId", (Object)parentId);
            this.request.setAttribute("parentType", (Object)parentType);
        }
        return new ModelAndView("ivs/map/editMap");
    }

    @RequiresPermissions(value={"ivs:map:add", "ivs:map:edit"})
    public ZKResultMsg save(@RequestParam(value="file", required=false) MultipartFile file, IvsMapItem item) {
        List ivsMapItems;
        if ("1".equals(item.getParentType()) && StringUtils.isBlank((CharSequence)item.getId()) && (ivsMapItems = this.ivsMapService.getIdsByParentId(item.getParentId())).size() >= 1) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"ivs_map_tip", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        ZKResultMsg res = new ZKResultMsg();
        String modify = this.request.getParameter("modify_path");
        String path = this.systemFilePath + File.separator + "/upload/ivs/map";
        boolean isGridMap = false;
        if (StringUtils.isBlank((CharSequence)item.getId()) && "2".equals(item.getParentType())) {
            isGridMap = true;
        }
        if (StringUtils.isBlank((CharSequence)item.getId()) || "1".equals(modify)) {
            IvsMapItem oldMap;
            File oldPic;
            if (file == null || file.getSize() > 0x200000L) {
                throw ZKBusinessException.warnException((String)I18nUtil.i18nCode((String)"base_map_imgSizeError", (Object[])new Object[0]), (Object[])new Object[0]);
            }
            File upLoadPicPath = new File(path);
            if (!upLoadPicPath.isAbsolute()) {
                path = ClassUtil.getRootPath() + "/" + path;
                upLoadPicPath = new File(path);
            }
            if (!upLoadPicPath.exists()) {
                upLoadPicPath.mkdirs();
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{item.getId()}) && (oldPic = new File((oldMap = this.ivsMapService.getItemById(item.getId())).getMapPath())).exists()) {
                oldPic.delete();
            }
            long fName = System.currentTimeMillis();
            item.setMapPath(path + "/" + fName + ".jpg");
            try {
                String mapName = path + "/" + fName + ".jpg";
                File mapFile = new File(mapName);
                file.transferTo(mapFile);
            }
            catch (IOException e) {
                throw new ZKBusinessException("IvsMapItem SaveMap Exception");
            }
        }
        this.ivsMapService.saveItem(item);
        if (isGridMap) {
            this.ivsMapService.addEntity(item.getParentId(), Double.valueOf(40.0), "Map", item.getId(), "addMap");
        }
        res.setData((Object)(item.getId() + "_2"));
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(IvsMapItem codition) {
        return null;
    }

    @RequiresPermissions(value={"ivs:map:del"})
    public ZKResultMsg del(String ids) {
        List list = this.ivsMapService.getChildMapsByParentId(ids);
        for (int i = 0; i < list.size(); ++i) {
            this.ivsMapService.deleteByIds((String)list.get(i));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ModelAndView getMap(String id) {
        this.request.setAttribute("isClient", (Object)this.request.getParameter("isClient"));
        if (StringUtils.isNotBlank((CharSequence)id)) {
            IvsMapItem tempMapItem = this.ivsMapService.getItemById(id);
            if (Objects.nonNull(tempMapItem)) {
                String imgBase64Str = "";
                String mapPath = tempMapItem.getMapPath();
                File mapfile = new File(mapPath);
                if (mapfile.exists()) {
                    try {
                        FileInputStream in = new FileInputStream(mapfile);
                        byte[] data = new byte[((InputStream)in).available()];
                        ((InputStream)in).read(data);
                        imgBase64Str = Base64Utils.encodeToString((byte[])data);
                        tempMapItem.setMapPath("data:image/jpg;base64," + imgBase64Str);
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        throw new ZKBusinessException("IvsMapController getMap base64 error");
                    }
                }
            } else {
                return new ModelAndView("ivs/map/ivsMapRTMonitor");
            }
            IvsMapPosItem ivsMapPosItem = new IvsMapPosItem();
            ivsMapPosItem.setMapId(id);
            ArrayList<IvsMapPosItem> mapPosList = new ArrayList<IvsMapPosItem>();
            List mapPosItemList = this.ivsMapPosService.getByCondition(ivsMapPosItem);
            List entityIds = mapPosItemList.stream().map(IvsMapPosItem::getEntityId).collect(Collectors.toList());
            List ivsChannelItemList = this.ivsChannelService.getItemsByIds(entityIds);
            Map ivsChannelItemMap = ivsChannelItemList.stream().collect(Collectors.toMap(IvsChannelItem::getId, Function.identity()));
            for (IvsMapPosItem pos : mapPosItemList) {
                IvsMapItem ivsMapItem;
                if ("VidChannel".equals(pos.getEntityType())) {
                    IvsChannelItem ivsChannelItem = (IvsChannelItem)ivsChannelItemMap.get(pos.getEntityId());
                    if (Objects.nonNull(ivsChannelItem)) {
                        pos.setEntityName(ivsChannelItem.getName());
                    } else {
                        pos.setEntityName(I18nUtil.i18nCode((String)"ivs_ext_device_notExist", (Object[])new Object[0]));
                    }
                } else if ("Map".equals(pos.getEntityType()) && Objects.nonNull(ivsMapItem = this.ivsMapService.getItemById(pos.getEntityId()))) {
                    pos.setEntityName(ivsMapItem.getName());
                }
                mapPosList.add(pos);
            }
            List lineList = this.ivsMapService.getLineData(id);
            List ivsMapPosItemIds = mapPosList.stream().map(item -> "item_" + item.getId()).collect(Collectors.toList());
            ArrayList newlineList = new ArrayList();
            lineList.forEach(ivsMapLineItem -> {
                if (ivsMapPosItemIds.contains(ivsMapLineItem.getStartIconId()) && ivsMapPosItemIds.contains(ivsMapLineItem.getEndIconId())) {
                    newlineList.add(ivsMapLineItem);
                }
            });
            this.request.setAttribute("tempMap", (Object)tempMapItem);
            this.request.setAttribute("mapPosList", mapPosList);
            this.request.setAttribute("mapId", (Object)id);
            this.request.setAttribute("lineList", (Object)JSONObject.toJSONString(newlineList));
        }
        this.request.setAttribute("gridName", (Object)this.request.getParameter("gridName"));
        return new ModelAndView("ivs/map/ivsMapRTMonitor");
    }

    public ZKResultMsg saveMapPos(String mapId, Double mapWidth, Double mapHeight, String posArray, String lineData) {
        this.ivsMapService.saveMapPos(mapId, mapWidth, mapHeight, posArray, lineData);
        if ("addEntityToMap".equals(this.request.getParameter("flag"))) {
            return null;
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg addChannel(String mapId, Double width, String entityType, String entityIds, String logMethod) {
        this.ivsMapService.addEntity(mapId, width, entityType, entityIds, logMethod);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg addPoint(String mapId, Double width, String entityType, String entityIds, String logMethod) {
        this.ivsMapService.addEntity(mapId, width, entityType, entityIds, logMethod);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isExist(IvsMapItem item) {
        List ivsMapItemList = this.ivsMapService.getItemsByParentIdAndName(item.getParentId(), item.getName());
        return ivsMapItemList.size() <= 0;
    }

    public ModelAndView getEntitySelectItem(String mapId, String entityType, String width) {
        this.request.setAttribute("mapId", (Object)mapId);
        this.request.setAttribute("entityType", (Object)entityType);
        this.request.setAttribute("width", (Object)width);
        this.request.setAttribute("logMethod", (Object)"addChannelToMap");
        return new ModelAndView("ivs/map/ivsMapSelectChannel");
    }

    public ZKResultMsg isExistVid() {
        return ZKResultMsg.successMsg();
    }

    public TreeItem getMapTree(String id) {
        List items = this.ivsMapService.createMapTree(id);
        if (items == null || items.isEmpty()) {
            TreeItem infoItem = new TreeItem();
            infoItem.setId("_");
            infoItem.setText("<span class='warningColor'>" + I18nUtil.i18nCode((String)"base_map_addMap", (Object[])new Object[0]) + "</span>");
            infoItem.setIm0("comm_iconAlert.png");
            items.add(infoItem);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList((Collection)items);
        return new TreeItem("0", treeItems);
    }

    public ZKResultMsg getEntityWidthByMapId(String mapId) {
        IvsMapPosItem ivsMapPosItem;
        double width = 40.0;
        IvsMapPosItem mapPosItem = new IvsMapPosItem();
        mapPosItem.setMapId(mapId);
        mapPosItem.setEntityType("VidChannel");
        List itemList = this.ivsMapPosService.getByCondition(mapPosItem);
        if (!itemList.isEmpty() && (ivsMapPosItem = (IvsMapPosItem)itemList.get(0)).getWidth() != null) {
            width = ivsMapPosItem.getWidth();
        }
        return new ZKResultMsg((Object)width);
    }

    public DxGrid listChannel(IvsMapSelectChannelItem condition) {
        String filterIds;
        String mapId = this.request.getParameter("mapId");
        String type = condition.getType();
        String string = filterIds = StringUtils.isNotBlank((CharSequence)condition.getSelectId()) ? "-1," + condition.getSelectId() : "-1";
        if ("noSelected".equals(type)) {
            String filterChannelIds = this.ivsMapPosService.getEntityIdsByMapIdAndEntityType(mapId, "VidChannel");
            if (StringUtils.isNotBlank((CharSequence)filterChannelIds)) {
                filterIds = filterIds + "," + filterChannelIds;
            }
            condition.setNotInId(filterIds);
        } else if ("selected".equals(type)) {
            condition.setInId(filterIds);
        }
        Pager pager = this.ivsMapService.getSelectChannelItemsByPage(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg delMapPos(String ids) {
        this.ivsMapPosService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg updateLineData(String mapId, String lineData) {
        this.ivsMapService.updateLineData(mapId, lineData);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

