/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsIntercomTransactionRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsIntercomService;
import com.zkteco.zkbiosecurity.ivs.service.IvsIntercomTransactionService;
import com.zkteco.zkbiosecurity.ivs.vo.intercom.IvsIntercomTransactionItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsIntercomTransactionController
extends ExportController
implements IvsIntercomTransactionRemote {
    @Autowired
    private IvsIntercomService ivsIntercomService;
    @Autowired
    IvsIntercomTransactionService ivsIntercomTransactionService;

    @MessageMapping(value={"ivsIntercom/callInfoData"})
    @SendTo(value={"/topic/ivsIntercom/callInfoData"})
    public String getPersonInfo(String params) {
        JSONObject paramJson = JSONObject.parseObject((String)params);
        String clientId = paramJson.getString("clientId");
        String opType = paramJson.getString("type");
        String operator = paramJson.getString("operator");
        JSONObject retData = new JSONObject();
        switch (opType) {
            case "getOrInit": 
            case "refreshCalls": {
                retData.put("dataType", (Object)"callsReceived");
                retData.put("clientId", (Object)clientId);
                retData.put("data", (Object)JSONArray.toJSONString((Object)this.ivsIntercomService.getCallDataByClientId(clientId)));
                break;
            }
            case "answer": {
                String ivsDevSn = paramJson.getString("ivsDevSn");
                if (this.ivsIntercomService.answerIntercomCall(ivsDevSn, clientId, operator)) {
                    retData.put("dataType", (Object)"callAnsweredSucceed");
                } else {
                    retData.put("dataType", (Object)"callAnsweredFailed");
                }
                retData.put("excludeClientId", (Object)clientId);
                retData.put("ivsDevSn", (Object)ivsDevSn);
                break;
            }
            case "ignore": {
                String ignoreSn = paramJson.getString("ivsDevSn");
                this.ivsIntercomService.ignoreCallByClientId(ignoreSn, clientId);
                break;
            }
            case "hangup": {
                String hangupSn = paramJson.getString("ivsDevSn");
                if (this.ivsIntercomService.updateTransactionWhenHangup(hangupSn, clientId, operator)) {
                    retData.put("dataType", (Object)"callHangUpSucceed");
                } else {
                    retData.put("dataType", (Object)"callHangUpFailed");
                }
                retData.put("excludeClientId", (Object)clientId);
                retData.put("ivsDevSn", (Object)hangupSn);
                break;
            }
            case "openDoor": {
                String opDoorDevSn = paramJson.getString("ivsDevSn");
                String cmdId = this.ivsIntercomService.operateDoor(opDoorDevSn, "open", 5, clientId);
                retData.put("excludeClientId", (Object)clientId);
                retData.put("ivsDevSn", (Object)opDoorDevSn);
                retData.put("cmdId", (Object)cmdId);
                retData.put("dataType", (Object)"opDoorResult");
                break;
            }
        }
        return retData.toJSONString();
    }

    @RequiresPermissions(value={"ivs:intercomTransaction"})
    public ModelAndView index() {
        return new ModelAndView("ivs/intercom/ivsIntercom");
    }

    @RequiresPermissions(value={"ivs:intercomTransaction:refresh"})
    public DxGrid list(IvsIntercomTransactionItem condition) {
        Pager pager = this.ivsIntercomTransactionService.loadTransactionByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"ivs:intercomTransaction:del"})
    public ZKResultMsg clearData() {
        this.ivsIntercomTransactionService.deleteAllData();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"ivs:intercomTransaction:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        IvsIntercomTransactionItem transactionItem = new IvsIntercomTransactionItem();
        this.setConditionValue((BaseItem)transactionItem);
        transactionItem.setAreaNameIn(this.ivsIntercomTransactionService.getAreaNamesBySessionId(request.getSession().getId()));
        List transactionList = this.ivsIntercomTransactionService.getTransactionData(IvsIntercomTransactionItem.class, (BaseItem)transactionItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(transactionList, IvsIntercomTransactionItem.class);
    }

    public ZKResultMsg getUserAuthInformation() {
        ZKResultMsg res = ZKResultMsg.successMsg();
        Map userAuthInformation = this.ivsIntercomService.getUserAuthInformation(this.request.getSession().getId());
        res.setData((Object)userAuthInformation);
        return res;
    }

    public ZKResultMsg getDevIpInformation() {
        ZKResultMsg res = ZKResultMsg.successMsg();
        Map devIpInformation = this.ivsIntercomService.getDevIpInformation();
        res.setData((Object)devIpInformation);
        return res;
    }

    public ZKResultMsg getPhoto(String path) {
        return this.ivsIntercomService.getPhoto(path);
    }
}

