/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.ivs.remote.IvsIntelApplicationRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsIntelApplicationService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsLargeScreenEventItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsIntelApplicationController
extends BaseController
implements IvsIntelApplicationRemote {
    @Autowired
    private IvsIntelApplicationService ivsIntelApplicationService;

    @RequiresPermissions(value={"ivs:ext:intelligenceApplication"})
    public ModelAndView index() {
        return new ModelAndView("ivs/intelApplication/ivsIntelApplication");
    }

    public ModelAndView openMixeCheckLargeScreen() {
        this.ivsIntelApplicationService.delVehicleDataInRedis();
        return new ModelAndView("ivs/intelApplication/ivsMixeCheckLargeScreen");
    }

    public DxGrid list(IvsLargeScreenEventItem condition) {
        Pager pager = new Pager();
        ArrayList itemList = new ArrayList();
        pager.setTotal(itemList.size());
        pager.setData(itemList);
        return GridUtil.convert((Pager)pager, IvsLargeScreenEventItem.class);
    }

    public ModelAndView toIvsMixeCheckSetPage() {
        return new ModelAndView("ivs/intelApplication/ivsMixeCheckSet");
    }

    public ZKResultMsg getMixeCheckSet() {
        return new ZKResultMsg((Object)this.ivsIntelApplicationService.getMixeCheckSet());
    }

    @LogRequest(module="ivs_module", object="ivs_intelligent_application", opType="ivs_mixeCheck_largeScreen", requestParams={"targetAttribute", "motorVehicle", "targetWhole"}, opContent="common_adf_setting")
    public ZKResultMsg saveMixeCheckSetInfo(String targetAttribute, String motorVehicle, String targetWhole, String showContent) {
        JSONObject ret = new JSONObject();
        ret.put("targetAttribute", (Object)targetAttribute);
        ret.put("motorVehicle", (Object)motorVehicle);
        ret.put("targetWhole", (Object)targetWhole);
        ret.put("showContent", (Object)showContent);
        this.ivsIntelApplicationService.saveMixeCheckSetInfo(ret);
        return ZKResultMsg.successMsg();
    }

    @LogRequest(module="ivs_module", object="ivs_intelligent_application", opType="ivs_mixeCheck_largeScreen", opContent="ivs_restoreDefault")
    public ZKResultMsg restoreDefaultSet() {
        this.ivsIntelApplicationService.initDataToRedis();
        return ZKResultMsg.successMsg();
    }

    @MessageMapping(value={"/ivsAlarmsMonitor/getEventData"})
    @SendTo(value={"/topic/ivsAlarmsMonitor/getEventData"})
    public Object getEventData(String params) {
        return null;
    }
}

