/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsHeatMapStatisticsRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsHeatMapStatisticsSerivce;
import com.zkteco.zkbiosecurity.ivs.utils.ApiIvsCheckUtil;
import com.zkteco.zkbiosecurity.ivs.vo.IvsHeatMapStatisticsRepItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsHeatMapStatisticsReqItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsHeatMapStatisticsController
extends ExportController
implements IvsHeatMapStatisticsRemote {
    @Autowired
    private IvsHeatMapStatisticsSerivce ivsHeatMapStatisticsSerivce;

    @RequiresPermissions(value={"ivs:ext:heatMapStatistics"})
    public ModelAndView index() {
        return new ModelAndView("ivs/statistic/ivsHeatMapStatistics");
    }

    public ZKResultMsg getHwHeatMapStatisticsData(IvsHeatMapStatisticsReqItem condition) {
        return this.ivsHeatMapStatisticsSerivce.getHwHeatMapStatisticsData(condition);
    }

    public void export(String dataKey, String statisticsWay, String startTime) {
        List itemList = this.ivsHeatMapStatisticsSerivce.getItemListFromCache(dataKey, statisticsWay, startTime);
        Map<String, String> map = ApiIvsCheckUtil.getColumnAndI18nByClass(IvsHeatMapStatisticsRepItem.class);
        HashMap allMap = new HashMap();
        HashMap<String, String> tableNameMap = new HashMap<String, String>();
        HashMap<String, String> columnNameMap = new HashMap<String, String>();
        String tableName = I18nUtil.i18nCode((String)"ivs_heatMapStatistices_timeType", (Object[])new Object[0]);
        switch (statisticsWay) {
            case "day": {
                tableName = tableName + "_" + I18nUtil.i18nCode((String)"ivs_dailyReport", (Object[])new Object[0]);
                break;
            }
            case "week": {
                tableName = tableName + "_" + I18nUtil.i18nCode((String)"ivs_weekReport", (Object[])new Object[0]);
                break;
            }
            case "month": {
                tableName = tableName + "_" + I18nUtil.i18nCode((String)"ivs_monthlyReport", (Object[])new Object[0]);
                break;
            }
            case "year": {
                tableName = tableName + "_" + I18nUtil.i18nCode((String)"ivs_yearQuarter", (Object[])new Object[0]);
                break;
            }
        }
        tableNameMap.put("tableName", tableName);
        columnNameMap.put("jsonColumn", JSONObject.toJSONString(map));
        allMap.put("tableName", tableNameMap);
        allMap.put("jsonColumn", columnNameMap);
        this.excelExport(itemList, IvsHeatMapStatisticsRepItem.class, allMap);
    }
}

