/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.ImgEncodeUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsGlobalLinkageTransactionRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsGlobalLinkageEventService;
import com.zkteco.zkbiosecurity.ivs.service.IvsGlobalLinkageTransactionService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsGlobalLinkageTransactionItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsGlobalLinkageTransactionController
extends ExportController
implements IvsGlobalLinkageTransactionRemote {
    @Autowired
    private IvsGlobalLinkageTransactionService ivsGlobalLinkageTransactionService;
    @Autowired
    private IvsGlobalLinkageEventService ivsGlobalLinkageEventService;

    public ModelAndView index() {
        return new ModelAndView("ivs/transaction/ivsGlobalLinkageTransaction");
    }

    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.ivsGlobalLinkageTransactionService.getItemById(id));
        }
        return new ModelAndView("ivs/transaction/editIvsGlobalLinkageTransaction");
    }

    public ZKResultMsg save(IvsGlobalLinkageTransactionItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.ivsGlobalLinkageTransactionService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(IvsGlobalLinkageTransactionItem condition) {
        if (Objects.nonNull(condition.getFileType())) {
            if (2 == condition.getFileType()) {
                condition.setStatusIn("3,11,15");
                condition.setFileTypeQuery(condition.getFileType());
            } else if (1 == condition.getFileType()) {
                condition.setStatusIn("12,14,15");
                condition.setFileTypeQuery(condition.getFileType());
            }
        }
        condition.setFileType(null);
        Pager pager = this.ivsGlobalLinkageTransactionService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @LogRequest(module="ivs_module", object="ivs_leftMenu_ivsTransaction", opType="common_op_clearData", opContent="common_op_clearData")
    public ZKResultMsg clearData(@RequestParam(value="ids") String ids) {
        this.ivsGlobalLinkageTransactionService.clearData();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getAllCapture(IvsGlobalLinkageTransactionItem condition) {
        ZKResultMsg ret = new ZKResultMsg();
        condition.setStatusIn("3,11,15");
        if (condition.getFileType() != null) {
            condition.setFileTypeQuery(condition.getFileType());
            condition.setFileType(null);
        }
        String currentPage = this.request.getParameter("currentPage");
        String pageSizeStr = this.request.getParameter("pageSize");
        int pageNo = StringUtils.isBlank((CharSequence)currentPage) ? 0 : Integer.valueOf(currentPage);
        int pageSize = StringUtils.isBlank((CharSequence)pageSizeStr) ? 50 : Integer.valueOf(pageSizeStr);
        Pager pager = this.ivsGlobalLinkageTransactionService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, pageNo, pageSize);
        List ivsTransactionItemList = pager.getData();
        for (IvsGlobalLinkageTransactionItem ivsTransactionItem : ivsTransactionItemList) {
            ivsTransactionItem.setStartTimeStr(DateUtil.dateToString((Date)ivsTransactionItem.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            String filePath = ivsTransactionItem.getFilePath();
            ivsTransactionItem.setFilePath("data:image/jpg;base64," + FileUtils.getFileBase64Str((String)ivsTransactionItem.getFilePath()));
            int index = filePath.lastIndexOf(File.separator);
            String newFilePath = filePath.substring(0, index) + File.separator + "thumb" + filePath.substring(index);
            ivsTransactionItem.setFileThumbBase64("data:image/jpg;base64," + FileUtils.getFileBase64Str((String)newFilePath));
        }
        ret.setData((Object)ivsTransactionItemList);
        return ret;
    }

    public ZKResultMsg isExistCapture() {
        ZKResultMsg ret = new ZKResultMsg();
        String id = this.request.getParameter("id");
        IvsGlobalLinkageTransactionItem ivsTransaction = this.ivsGlobalLinkageTransactionService.getItemById(id);
        if (null != ivsTransaction) {
            ArrayList<IvsGlobalLinkageTransactionItem> ivsTransactionItems = new ArrayList<IvsGlobalLinkageTransactionItem>();
            String filePath = ivsTransaction.getFilePath();
            if (StringUtils.isNotBlank((CharSequence)filePath)) {
                File file = new File(filePath);
                if (!file.exists()) {
                    ret.setRet("fail");
                } else {
                    String fileBase64 = "data:image/jpg;base64," + FileUtils.getFileBase64Str((String)filePath);
                    ivsTransaction.setFilePath(fileBase64);
                    int index = filePath.lastIndexOf(File.separator);
                    String newFilePath = filePath.substring(0, index) + File.separator + "thumb" + filePath.substring(index);
                    File newFile = new File(newFilePath);
                    if (!newFile.exists()) {
                        File f = new File(filePath.substring(0, index) + File.separator + "thumb");
                        if (!f.exists()) {
                            f.mkdirs();
                        }
                        ImgEncodeUtil.createZoomImage((File)file, (File)newFile, (int)160, (int)120);
                    }
                    ivsTransaction.setFileThumbBase64("data:image/jpg;base64," + FileUtils.getFileBase64Str((String)filePath));
                    ivsTransactionItems.add(ivsTransaction);
                    ret.setData(ivsTransactionItems);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIvsCapture() {
        FileInputStream fStream = null;
        try {
            String id = this.request.getParameter("id");
            String ptype = this.request.getParameter("ptype");
            IvsGlobalLinkageTransactionItem ivsTransaction = this.ivsGlobalLinkageTransactionService.getItemById(id);
            String filePath = ivsTransaction.getFilePath();
            File file = new File(filePath);
            if (ptype != null) {
                int index = filePath.lastIndexOf(File.separator);
                String newFilePath = filePath.substring(0, index) + File.separator + ptype + filePath.substring(index);
                File newFile = new File(newFilePath);
                if (newFile.exists()) {
                    file = newFile;
                } else if (file.exists()) {
                    File f = new File(filePath.substring(0, index) + File.separator + ptype);
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    ImgEncodeUtil.createZoomImage((File)file, (File)newFile, (int)160, (int)120);
                    file = newFile;
                }
            }
            fStream = new FileInputStream(file);
            int lenght = fStream.available();
            byte[] data = new byte[lenght];
            fStream.read(data);
            this.response.reset();
            this.response.getOutputStream().write(data);
        }
        catch (Exception e) {
            this.log.error("exception", (Throwable)e);
        }
        finally {
            try {
                if (fStream != null) {
                    fStream.close();
                }
                this.response.getOutputStream().close();
            }
            catch (IOException e) {
                this.log.error("exception", (Throwable)e);
            }
        }
        return null;
    }

    public ZKResultMsg getVideoFile() {
        String id = this.request.getParameter("id");
        Map retMap = this.ivsGlobalLinkageTransactionService.getVideoFileValidate(id);
        ZKResultMsg ret = (ZKResultMsg)retMap.get("ret");
        if (null != ret) {
            return I18nUtil.i18nMsg((ZKResultMsg)ret);
        }
        String filePath = retMap.get("filePath").toString();
        File file = (File)retMap.get("file");
        int index = filePath.lastIndexOf(File.separator);
        String fileName = filePath.substring(index + 1);
        if (file.isDirectory() && file.listFiles().length > 0) {
            File childFile = file.listFiles()[0];
            fileName = fileName.substring(0, fileName.lastIndexOf(".")) + childFile.getName().substring(childFile.getName().lastIndexOf("."));
        }
        this.response.setCharacterEncoding("utf-8");
        this.response.setContentType("multipart/form-data");
        this.response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
        try {
            int length;
            FileInputStream inputStream = new FileInputStream(filePath);
            ServletOutputStream os = this.response.getOutputStream();
            byte[] b = new byte[2048];
            while ((length = ((InputStream)inputStream).read(b)) > 0) {
                os.write(b, 0, length);
            }
            os.close();
            ((InputStream)inputStream).close();
        }
        catch (Exception e) {
            this.log.error("exception", (Throwable)e);
        }
        return null;
    }

    public InputStream getDownVideoFile() {
        String filePath = this.request.getParameter("filePath");
        FileInputStream fStream = null;
        File file = new File(filePath);
        try {
            if (file.isFile()) {
                fStream = new FileInputStream(file);
            } else if (file.listFiles().length > 0) {
                fStream = new FileInputStream(file.listFiles()[0]);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
        return fStream;
    }

    public String batchDownloadPic(@RequestParam(value="ids") String ids) {
        this.ivsGlobalLinkageTransactionService.batchDownloadPic(ids);
        return null;
    }

    public ZKResultMsg getVideoRecordInfo(String id) {
        ZKResultMsg res = new ZKResultMsg();
        res.setData((Object)this.ivsGlobalLinkageTransactionService.getVideoRecordInfo(id));
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg viewVidLinkData(String vidLinkageHandle, String fileType) {
        return this.ivsGlobalLinkageEventService.getVidLinkageEventData(vidLinkageHandle, fileType);
    }

    public void export(HttpServletRequest request, HttpServletResponse response) throws InvocationTargetException, IllegalAccessException {
        IvsGlobalLinkageTransactionItem ivsTransactionItem = new IvsGlobalLinkageTransactionItem();
        this.setConditionValue((BaseItem)ivsTransactionItem);
        ivsTransactionItem.setSortName(null);
        ivsTransactionItem.setSortOrder(null);
        ivsTransactionItem.setFileType(null);
        Pager pager = this.ivsGlobalLinkageTransactionService.loadPagerByAuthFilter(request.getSession().getId(), ivsTransactionItem, this.getPageNo(), this.getPageSize());
        List itemList = pager.getData();
        this.excelExport(itemList, IvsGlobalLinkageTransactionItem.class);
    }

    public ZKResultMsg getEventTypeList() {
        return new ZKResultMsg((Object)this.ivsGlobalLinkageTransactionService.getEventTypeList());
    }
}

