/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.ivs.remote.IvsGlobalLinkagePersonRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsEdgeDeviceService;
import com.zkteco.zkbiosecurity.ivs.service.IvsGlobalLinkagePersonService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsGlobalLinkageSelectPersonItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class IvsGlobalLinkagePersonController
extends BaseController
implements IvsGlobalLinkagePersonRemote {
    @Autowired
    private IvsGlobalLinkagePersonService ivsGlobalLinkagePersonService;
    @Autowired
    private IvsEdgeDeviceService ivsEdgeDeviceService;

    public DxGrid selectPersonList(IvsGlobalLinkageSelectPersonItem condition) {
        Pager pager = new Pager();
        if (condition.getType().equals("noSelected")) {
            pager = this.ivsGlobalLinkagePersonService.getNoExistPerson(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getGlobalLinkagePerson(IvsGlobalLinkageSelectPersonItem condition) {
        Pager pager = this.ivsGlobalLinkagePersonService.getItemsByLinkId(condition, this.getPageNo(), this.getPageSize());
        List ivsGlobalLinkageSelectPersonItems = pager.getData();
        if (Objects.nonNull(ivsGlobalLinkageSelectPersonItems)) {
            for (IvsGlobalLinkageSelectPersonItem ivsGlobalLinkageSelectPersonItem : ivsGlobalLinkageSelectPersonItems) {
                ivsGlobalLinkageSelectPersonItem.setPersonPin(this.ivsEdgeDeviceService.convertToEncrypt(ivsGlobalLinkageSelectPersonItem.getPersonPin(), "pers.pin.encryptProp", "pers.pin.encryptMode"));
                ivsGlobalLinkageSelectPersonItem.setPersonName(this.ivsEdgeDeviceService.convertToEncrypt(ivsGlobalLinkageSelectPersonItem.getPersonName(), "pers.name.encryptProp", "pers.name.encryptMode"));
                ivsGlobalLinkageSelectPersonItem.setPersonLastName(this.ivsEdgeDeviceService.convertToEncrypt(ivsGlobalLinkageSelectPersonItem.getPersonLastName(), "pers.lastName.encryptProp", "pers.lastName.encryptMode"));
            }
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

