/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ivs.remote.IvsGlobalLinkageRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsGlobalLinkageService;
import com.zkteco.zkbiosecurity.ivs.service.IvsParamsService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsChannelSelectItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsGlobalLinkage4LineContactItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsGlobalLinkageEntityItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsGlobalLinkageItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsGlobalLinkageSelectAuxOutItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsGlobalLinkageSelectDoorItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsGlobalLinkageSelectFloorItem;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsGlobalLinkageController
extends BaseController
implements IvsGlobalLinkageRemote {
    @Autowired
    private IvsGlobalLinkageService ivsGlobalLinkageService;
    @Autowired
    private IvsParamsService ivsParamsService;

    public ModelAndView index() {
        return new ModelAndView("ivs/linkage/ivsGlobalLinkage");
    }

    public DxGrid list(IvsGlobalLinkageEntityItem condition) {
        Pager pager = this.ivsGlobalLinkageService.getEntityItems(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ModelAndView edit(String id) {
        boolean showLine = this.ivsGlobalLinkageService.checkShowLine();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            IvsGlobalLinkageItem item = this.ivsGlobalLinkageService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
            if (showLine) {
                List accGlobalLinkage4LineContactItems = this.ivsGlobalLinkageService.getLineContactsByContactIds(item.getLineContactId());
                this.request.setAttribute("contactList", (Object)accGlobalLinkage4LineContactItems);
            }
        }
        this.request.setAttribute("showSMS", (Object)this.ivsGlobalLinkageService.checkShowSMS());
        this.request.setAttribute("showLine", (Object)showLine);
        this.request.setAttribute("showWhatsapp", (Object)this.ivsGlobalLinkageService.checkShowWhatsapp());
        String sessionId = this.request.getSession().getId();
        this.request.setAttribute("hasAccPermission", (Object)("" + this.ivsGlobalLinkageService.checkShowAcc(sessionId)));
        this.request.setAttribute("hasElePermission", (Object)("" + this.ivsGlobalLinkageService.checkShowEle(sessionId)));
        return new ModelAndView("ivs/linkage/editIvsGlobalLinkage");
    }

    public boolean isExistLinkageName(String name) {
        return this.ivsGlobalLinkageService.getItemByName(name) == null;
    }

    public ZKResultMsg getLinkTriggerOpt(String globalLinkageId) {
        return this.ivsGlobalLinkageService.getLinkTriggerOpt(globalLinkageId);
    }

    public DxGrid getGlobalLinkageSelectChannel(IvsChannelSelectItem condition) {
        Pager pager = this.ivsGlobalLinkageService.getGlobalLinkageSelectChannel(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getGlobalLinkageSelectDoor(IvsGlobalLinkageSelectDoorItem condition) {
        Pager pager = this.ivsGlobalLinkageService.getGlobalLinkageSelectSelectDoor(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getGlobalLinkageSelectAuxOut(IvsGlobalLinkageSelectAuxOutItem condition) {
        Pager pager = this.ivsGlobalLinkageService.getGlobalLinkageSelectSelectAuxOut(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getGlobalLinkageSelectFloor(IvsGlobalLinkageSelectFloorItem condition) {
        Pager pager = this.ivsGlobalLinkageService.getGlobalLinkageSelectSelectFloor(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg save(IvsGlobalLinkageItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String isApplyToAll = item.getApplyToAllStr();
        if (StringUtils.isNotBlank((CharSequence)isApplyToAll)) {
            item.setIsApplyToAll(Short.valueOf((short)0));
        } else {
            item.setIsApplyToAll(Short.valueOf((short)1));
        }
        if (StringUtils.isNotBlank((CharSequence)item.getPopUpVideo())) {
            String popUpTime = this.request.getParameter("popUpTime");
            item.setPopUpTimes(Integer.parseInt(popUpTime));
        }
        if (StringUtils.isNotBlank((CharSequence)item.getRecord())) {
            String recordTime = this.request.getParameter("recordTime");
            item.setRecordTimes(Integer.parseInt(recordTime));
        }
        if (StringUtils.isNotBlank((CharSequence)item.getCapture())) {
            String captureTime = this.request.getParameter("captureTime");
            if (StringUtils.isNotBlank((CharSequence)captureTime)) {
                item.setCaptureTimes(Integer.parseInt(captureTime));
            } else {
                item.setCaptureTimes(-1);
            }
        }
        this.ivsGlobalLinkageService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg del(String ids) {
        this.ivsGlobalLinkageService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg setEnable(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.ivsGlobalLinkageService.setGlobalLinkageStatus(ids, true);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg setDisable(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.ivsGlobalLinkageService.setGlobalLinkageStatus(ids, false);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ModelAndView setGlobalPopUpOption() {
        this.request.setAttribute("globalPopUpOption", this.ivsParamsService.getIvsParams().get("ivs.global_popup_option"));
        return new ModelAndView("ivs/linkage/setGlobalPopUpOption");
    }

    public ZKResultMsg updateGlobalPopUpOption(String globalPopUpOption) {
        ZKResultMsg res = new ZKResultMsg();
        this.ivsParamsService.saveParam("ivs.global_popup_option", globalPopUpOption);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg addPersonValidate(String linkId) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (!this.ivsGlobalLinkageService.addPersonValidate(linkId)) {
            resultMsg.setRet("fail");
            resultMsg.setMsg("ivs_globalLinkage_noAddPerson");
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg addPerson(String globalLinkageId, String personIds) {
        if (StringUtils.isNotBlank((CharSequence)globalLinkageId) && StringUtils.isNotBlank((CharSequence)personIds)) {
            this.ivsGlobalLinkageService.addPerson(globalLinkageId, personIds);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg delPerson(String globalLinkageId, String personIds) {
        if (StringUtils.isNotBlank((CharSequence)globalLinkageId) && StringUtils.isNotBlank((CharSequence)personIds)) {
            this.ivsGlobalLinkageService.delPerson(globalLinkageId, personIds);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg isSupportLockDoor(String doorIds) {
        boolean isSupportLockDoor = true;
        if (StringUtils.isNotBlank((CharSequence)doorIds)) {
            isSupportLockDoor = this.ivsGlobalLinkageService.isSupportLockDoor(doorIds);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)isSupportLockDoor));
    }

    public ZKResultMsg checkSMSModemParam() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        zkResultMsg.setData((Object)this.ivsGlobalLinkageService.checkSMSModemParam());
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg getTVWallLinkage(String linkageId) {
        return this.ivsGlobalLinkageService.getTVWallLinkage(linkageId);
    }

    public DxGrid selectLineContactList(IvsGlobalLinkage4LineContactItem condition) {
        Pager pager = new Pager();
        String selectIds = this.request.getParameter("selectValue");
        if (StringUtils.isBlank((CharSequence)selectIds)) {
            selectIds = "";
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getSelectId())) {
            selectIds = selectIds + "," + condition.getSelectId();
        }
        condition.setSelectId(selectIds);
        if (condition.getType().equals("noSelected")) {
            pager = this.ivsGlobalLinkageService.getNoExistLineContacts(condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

