/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.ivs.remote.IvsGeneralIntelligenceRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsGeneralIntelligenceService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsGeneralIntelligenceInfoItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsSoundDetectItem;
import com.zkteco.zkbiosecurity.ivs.vo.zknvr.IvsZKNvrMotionChannelConfigItem;
import com.zkteco.zkbiosecurity.ivs.vo.zknvr.IvsZKNvrOcclusionChannelConfigItem;
import com.zkteco.zkbiosecurity.ivs.vo.zknvr.IvsZKNvrVideoLostItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsGeneralIntelligenceController
extends BaseController
implements IvsGeneralIntelligenceRemote {
    @Autowired
    private IvsGeneralIntelligenceService generalIntelligenceService;

    @RequiresPermissions(value={"ivs:ext:ivsGeneralIntel"})
    public ModelAndView index() {
        this.request.setAttribute("isClient", (Object)this.request.getParameter("isClient"));
        return new ModelAndView("ivs/generalIntelligence/generalIntelligence");
    }

    @LogRequest(module="ivs_module", object="ivs_generalIntelligence", opType="ivs_log_opType_get", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg getGeneralIntelligence(IvsGeneralIntelligenceInfoItem requestBody) {
        return this.generalIntelligenceService.getGeneralIntelligence(requestBody);
    }

    @LogRequest(module="ivs_module", object="ivs_generalIntelligence", opType="ivs_log_opType_set", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg setGeneralIntelligence(IvsGeneralIntelligenceInfoItem requestBody) {
        return this.generalIntelligenceService.setGeneralIntelligence(requestBody);
    }

    @LogRequest(module="ivs_module", object="ivs_generalIntelligence", opType="ivs_log_opType_get", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg getSoundDetect(IvsSoundDetectItem condition) {
        return this.generalIntelligenceService.getSoundDetect(condition);
    }

    @LogRequest(module="ivs_module", object="ivs_generalIntelligence", opType="ivs_log_opType_set", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg setSoundDetect(IvsSoundDetectItem condition) {
        return this.generalIntelligenceService.setSoundDetect(condition);
    }

    public ZKResultMsg getZKNvrMotionDetect(IvsZKNvrMotionChannelConfigItem condition) {
        return this.generalIntelligenceService.getZKNvrMotionDetect(condition);
    }

    public ZKResultMsg getZKNvrSmartMotion(String channelCode, String parentDeviceId) {
        return this.generalIntelligenceService.getZKNvrSmartMotion(channelCode, parentDeviceId);
    }

    public ZKResultMsg setZKNvrMotionDetect(IvsZKNvrMotionChannelConfigItem condition) {
        return this.generalIntelligenceService.setZKNvrMotionDetect(condition);
    }

    public ZKResultMsg setZKNvrSmartMotion(String smartMotionObject) {
        return this.generalIntelligenceService.setZKNvrSmartMotion(smartMotionObject);
    }

    @LogRequest(module="ivs_module", object="ivs_generalIntelligence", opType="ivs_log_opType_get", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg getZKNvrOcclusion(IvsZKNvrOcclusionChannelConfigItem condition) {
        return this.generalIntelligenceService.getZKNvrOcclusion(condition);
    }

    @LogRequest(module="ivs_module", object="ivs_generalIntelligence", opType="ivs_log_opType_set", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg setZKNvrOcclusion(IvsZKNvrOcclusionChannelConfigItem condition) {
        return this.generalIntelligenceService.setZKNvrOcclusion(condition);
    }

    public ZKResultMsg getVideoLost(IvsZKNvrVideoLostItem condition) {
        return this.generalIntelligenceService.getVideoLost(condition);
    }

    public ZKResultMsg setVideoLost(IvsZKNvrVideoLostItem condition) {
        return this.generalIntelligenceService.setVideoLost(condition);
    }
}

