/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsFaceStatisticRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsAnalyseFaceService;
import com.zkteco.zkbiosecurity.ivs.utils.ApiIvsCheckUtil;
import com.zkteco.zkbiosecurity.ivs.utils.IVSUtil;
import com.zkteco.zkbiosecurity.ivs.vo.IvsAnalyseFaceItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsFaceStatisticExportItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsFaceStatisticController
extends ExportController
implements IvsFaceStatisticRemote {
    @Autowired
    private IvsAnalyseFaceService ivsAnalyseFaceService;

    @RequiresPermissions(value={"ivs:ext:faceStatistic"})
    public ModelAndView index() {
        return new ModelAndView("ivs/statistic/ivsFaceStatistic");
    }

    public ZKResultMsg getFaceStatisticHistogramData(IvsAnalyseFaceItem condition) {
        return new ZKResultMsg((Object)this.ivsAnalyseFaceService.getFaceStatisticHistogramData(condition));
    }

    public ZKResultMsg getFaceStatisticPieData(IvsAnalyseFaceItem condition) {
        return new ZKResultMsg((Object)this.ivsAnalyseFaceService.getFaceStatisticPieData(condition));
    }

    public ZKResultMsg getVidExtDeviceSelectData() {
        String sessionId = WebContextUtil.getCurrentSessionId();
        String notInType = IVSUtil.getExcludedTypes(this.request);
        boolean withType = "true".equals(this.request.getParameter("withType"));
        return new ZKResultMsg((Object)this.ivsAnalyseFaceService.getVidExtDeviceSelectData(sessionId, notInType, withType));
    }

    public ZKResultMsg getVidExtIvsDeviceSelectData() {
        String sessionId = WebContextUtil.getCurrentSessionId();
        return new ZKResultMsg((Object)this.ivsAnalyseFaceService.getVidExtIvsDeviceSelectData(sessionId));
    }

    public ZKResultMsg getVidExtChannelSelectData(@RequestParam(value="vidExtParentDeviceId", required=false) String vidExtParentDeviceId) {
        String sessionId = WebContextUtil.getCurrentSessionId();
        return new ZKResultMsg((Object)this.ivsAnalyseFaceService.getVidExtChannelSelectData(vidExtParentDeviceId, sessionId));
    }

    public ZKResultMsg getVidExtChannelCodeSelectData(String vidExtParentDeviceId) {
        String sessionId = WebContextUtil.getCurrentSessionId();
        return new ZKResultMsg((Object)this.ivsAnalyseFaceService.getVidExtChannelCodeSelectData(vidExtParentDeviceId, sessionId));
    }

    public void export(IvsAnalyseFaceItem condition) {
        List ivsFaceStatisticExportItems = this.ivsAnalyseFaceService.getExportData(condition);
        this.setConditionValue((BaseItem)condition);
        Map<String, String> map = ApiIvsCheckUtil.getColumnAndI18nByClass(IvsFaceStatisticExportItem.class);
        HashMap allMap = new HashMap();
        HashMap<String, String> tableNameMap = new HashMap<String, String>();
        HashMap<String, String> columnNameMap = new HashMap<String, String>();
        tableNameMap.put("tableName", I18nUtil.i18nCode((String)"ivs_ext_faceanalyse", (Object[])new Object[0]));
        columnNameMap.put("jsonColumn", JSONObject.toJSONString(map));
        allMap.put("tableName", tableNameMap);
        allMap.put("jsonColumn", columnNameMap);
        this.excelExport(ivsFaceStatisticExportItems, IvsFaceStatisticExportItem.class, allMap);
    }
}

