/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ivs.controller.IvsExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsFaceSearchRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsEdgeDeviceService;
import com.zkteco.zkbiosecurity.ivs.service.IvsFaceSearchService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsFaceSearchItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsFaceSearchController
extends IvsExportController
implements IvsFaceSearchRemote {
    @Autowired
    private IvsFaceSearchService ivsFaceSearchService;
    @Autowired
    private IvsEdgeDeviceService ivsEdgeDeviceService;

    @RequiresPermissions(value={"ivs:face:search"})
    public ModelAndView index() {
        return new ModelAndView("ivs/faceSearch/ivsFaceSearch");
    }

    public DxGrid list(IvsFaceSearchItem condition) {
        Pager pager = this.ivsFaceSearchService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        DxGrid data = GridUtil.convert((Pager)pager, condition.getClass());
        return data;
    }

    @RequiresPermissions(value={"ivs:faceSearch:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        IvsFaceSearchItem ivsFaceSearchItem = new IvsFaceSearchItem();
        this.setConditionValue((BaseItem)ivsFaceSearchItem);
        int recordstart = Integer.parseInt(request.getParameter("recordstart"));
        int maxCount = Integer.parseInt(request.getParameter("recordcount"));
        List itemList = this.ivsFaceSearchService.getItemData(ivsFaceSearchItem, recordstart, maxCount);
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        if (Objects.nonNull(itemList) && itemList.size() > 0 && "2".equals(((IvsFaceSearchItem)itemList.get(0)).getParentType())) {
            String jsonColumn = request.getParameter("jsonColumn");
            LinkedHashMap jsonMap = (LinkedHashMap)JSON.parseObject((String)jsonColumn, LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField});
            jsonMap.put("hair", I18nUtil.i18nCode((String)"ivs_acc_hair", (Object[])new Object[0]));
            JSONObject jsonObject = new JSONObject(true);
            jsonObject.putAll((Map)jsonMap);
            HashMap<String, String> columnMap = new HashMap<String, String>();
            columnMap.put("jsonColumn", jsonObject.toJSONString());
            map.put("jsonColumn", columnMap);
        }
        this.excelExport(itemList, IvsFaceSearchItem.class, map, null);
    }

    public ModelAndView getFaceSearchTail(String id, String isFaceSearch) {
        IvsFaceSearchItem faceSearchTail = this.ivsFaceSearchService.getFaceSearchTail(id, isFaceSearch, this.request.getSession().getId());
        if (Objects.nonNull(faceSearchTail)) {
            String genderStr = this.ivsEdgeDeviceService.convertToEncrypt(faceSearchTail.getGenderStr(), "pers.gender.encryptProp", "pers.gender.encryptMode");
            faceSearchTail.setGenderStr(genderStr);
            this.request.setAttribute("item", (Object)faceSearchTail);
        }
        if ("true".equals(isFaceSearch)) {
            return new ModelAndView("ivs/faceSearch/faceSearchDetail");
        }
        return new ModelAndView("ivs/humanRetrieval/humanRetrievalDetail");
    }
}

