/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsFaceRetrievalRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsFaceRetrievalService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsFaceImageItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsFaceRetrievalInfoItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsFaceRetrievalItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsFaceRetrievalRepItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsFaceRetrievalController
extends ExportController
implements IvsFaceRetrievalRemote {
    @Autowired
    private IvsFaceRetrievalService ivsFaceRetrievalService;

    @RequiresPermissions(value={"ivs:face:retrieval"})
    public ModelAndView index() {
        return new ModelAndView("ivs/faceretrieval/ivsFaceRetrieval");
    }

    public ModelAndView retrievalInfoList(String id) {
        this.request.setAttribute("id", (Object)id);
        return new ModelAndView("ivs/faceretrieval/hwFaceRetrievalList");
    }

    @RequiresPermissions(value={"ivs:alarmLatest:refresh"})
    public DxGrid list(IvsFaceRetrievalItem condition) {
        Pager pager = new Pager();
        ArrayList itemList = new ArrayList();
        pager.setTotal(itemList.size());
        pager.setData(itemList);
        return GridUtil.convert((Pager)pager, IvsFaceRetrievalRepItem.class);
    }

    public ZKResultMsg getFaceSearchCount(IvsFaceRetrievalItem condition) {
        return this.ivsFaceRetrievalService.getFaceSearchCount(condition);
    }

    public ZKResultMsg getIvsFaceRetrievalRepAsyn(IvsFaceRetrievalItem condition) {
        return this.ivsFaceRetrievalService.getIvsFaceRetrievalDataAsyn(condition);
    }

    public ZKResultMsg getHwFaceRetrievalSingle(String signId) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        Pager pager = this.ivsFaceRetrievalService.getRetrievaInfoBySignId(signId);
        zkResultMsg.setData((Object)pager.getData());
        return zkResultMsg;
    }

    public DxGrid getRetrievaInfoBySignId(String signId) {
        Pager pager = new Pager();
        ArrayList itemList = new ArrayList();
        pager.setTotal(itemList.size());
        pager.setData(itemList);
        return GridUtil.convert((Pager)pager, IvsFaceRetrievalInfoItem.class);
    }

    public TreeItem tree(String key) {
        if ("sex".equals(key) || "age".equals(key) || "mouthMouseType".equals(key) || "hairType".equals(key) || "glassType".equals(key) || "hatType".equals(key)) {
            HashMap<String, String> map = new HashMap<String, String>();
            if ("sex".equals(key)) {
                map.put("0", I18nUtil.i18nCode((String)"ivs_unknown", (Object[])new Object[0]));
                map.put("1", I18nUtil.i18nCode((String)"common_male", (Object[])new Object[0]));
                map.put("2", I18nUtil.i18nCode((String)"common_female", (Object[])new Object[0]));
            } else if ("age".equals(key)) {
                map.put("0", I18nUtil.i18nCode((String)"ivs_face_retrieval_age0", (Object[])new Object[0]));
                map.put("1", I18nUtil.i18nCode((String)"ivs_face_retrieval_age1", (Object[])new Object[0]));
                map.put("2", I18nUtil.i18nCode((String)"ivs_face_retrieval_age2", (Object[])new Object[0]));
                map.put("3", I18nUtil.i18nCode((String)"ivs_face_retrieval_age3", (Object[])new Object[0]));
                map.put("4", I18nUtil.i18nCode((String)"ivs_face_retrieval_age4", (Object[])new Object[0]));
                map.put("5", I18nUtil.i18nCode((String)"ivs_face_retrieval_age5", (Object[])new Object[0]));
                map.put("6", I18nUtil.i18nCode((String)"ivs_face_retrieval_age6", (Object[])new Object[0]));
                map.put("7", I18nUtil.i18nCode((String)"ivs_unknown", (Object[])new Object[0]));
            } else if ("mouthMouseType".equals(key)) {
                map.put("0", I18nUtil.i18nCode((String)"ivs_unknown", (Object[])new Object[0]));
                map.put("1", I18nUtil.i18nCode((String)"ivs_face_retrieval_mouthMask_1", (Object[])new Object[0]));
                map.put("2", I18nUtil.i18nCode((String)"ivs_face_retrieval_mouthMask_2", (Object[])new Object[0]));
            } else if ("hairType".equals(key)) {
                map.put("0", I18nUtil.i18nCode((String)"ivs_unknown", (Object[])new Object[0]));
                map.put("1", I18nUtil.i18nCode((String)"ivs_face_retrieval_hair_1", (Object[])new Object[0]));
                map.put("2", I18nUtil.i18nCode((String)"ivs_face_retrieval_hair_2", (Object[])new Object[0]));
            } else if ("glassType".equals(key)) {
                map.put("0", I18nUtil.i18nCode((String)"ivs_unknown", (Object[])new Object[0]));
                map.put("1", I18nUtil.i18nCode((String)"ivs_face_retrieval_glassType_1", (Object[])new Object[0]));
                map.put("2", I18nUtil.i18nCode((String)"ivs_face_retrieval_glassType_2", (Object[])new Object[0]));
                map.put("3", I18nUtil.i18nCode((String)"ivs_face_retrieval_glassType_3", (Object[])new Object[0]));
            } else if ("hatType".equals(key)) {
                map.put("0", I18nUtil.i18nCode((String)"ivs_unknown", (Object[])new Object[0]));
                map.put("1", I18nUtil.i18nCode((String)"ivs_face_retrieval_hat_1", (Object[])new Object[0]));
                map.put("2", I18nUtil.i18nCode((String)"vid_face_retrieval_have", (Object[])new Object[0]));
            }
            ArrayList<HashMap<String, String>> items = new ArrayList<HashMap<String, String>>();
            items.add(map);
            ArrayList<TreeItem> tempItems = new ArrayList<TreeItem>();
            TreeItem item = null;
            TreeItem pItem = null;
            for (Map map2 : items) {
                for (String k : map2.keySet()) {
                    item = new TreeItem();
                    item.setId(k);
                    item.setText((String)map2.get(k));
                    pItem = new TreeItem("15");
                    item.setParent(pItem);
                    tempItems.add(item);
                }
            }
            List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(tempItems);
            return new TreeItem("0", treeItems);
        }
        return null;
    }

    public ModelAndView opFaceRetrievalDetails(String signId, String fileId, String parentDeviceId) {
        IvsFaceImageItem infoItem = this.ivsFaceRetrievalService.getRetrievaInfoByFileId(signId, fileId);
        this.request.setAttribute("item", (Object)infoItem);
        this.request.setAttribute("parentDeviceId", (Object)parentDeviceId);
        return new ModelAndView("ivs/faceretrieval/faceRetrievalDetails");
    }
}

