/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsFaceReportRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsAnalyseFaceService;
import com.zkteco.zkbiosecurity.ivs.service.IvsEdgeDeviceService;
import com.zkteco.zkbiosecurity.ivs.utils.ApiIvsCheckUtil;
import com.zkteco.zkbiosecurity.ivs.vo.IvsAnalyseFaceItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsEdgeDeviceItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsFaceReportChartItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsFaceReportExportItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsFaceReportController
extends ExportController
implements IvsFaceReportRemote {
    @Autowired
    private IvsAnalyseFaceService ivsAnalyseFaceService;
    @Autowired
    private IvsEdgeDeviceService ivsEdgeDeviceService;

    @RequiresPermissions(value={"ivs:ext:faceReport"})
    public ModelAndView index() {
        return new ModelAndView("ivs/statistic/ivsFaceReport");
    }

    public ZKResultMsg getAgePieData(IvsAnalyseFaceItem condition) {
        return new ZKResultMsg((Object)this.ivsAnalyseFaceService.getAgePieData(condition));
    }

    public ZKResultMsg getSexPieData(IvsAnalyseFaceItem condition) {
        return new ZKResultMsg((Object)this.ivsAnalyseFaceService.getSexPieData(condition));
    }

    public void export(HttpServletRequest request, HttpServletResponse response, IvsAnalyseFaceItem condition) {
        IvsFaceReportExportItem exportItem = new IvsFaceReportExportItem();
        IvsEdgeDeviceItem ivsEdgeDeviceItem = this.ivsEdgeDeviceService.getItemById(condition.getVidExtDeviceId());
        if ("2".equals(ivsEdgeDeviceItem.getType())) {
            exportItem = this.ivsAnalyseFaceService.getCatchPieData(condition);
        } else {
            int allAmount = this.ivsAnalyseFaceService.getAllAmountByDoMainCodeAndChannelCode(condition);
            List sexPieData = this.ivsAnalyseFaceService.getSexGroupDataList(condition);
            Map<String, IvsFaceReportChartItem> sexPieMap = sexPieData.stream().collect(Collectors.toMap(IvsFaceReportChartItem::getGroupName, IvsFaceReportChartItem2 -> IvsFaceReportChartItem2));
            List agePieData = this.ivsAnalyseFaceService.getAgeGroupDataList(condition);
            Map<String, IvsFaceReportChartItem> agePieMap = agePieData.stream().collect(Collectors.toMap(IvsFaceReportChartItem::getGroupName, IvsFaceReportChartItem2 -> IvsFaceReportChartItem2));
            exportItem.setUnKnown(String.valueOf(sexPieMap.get("0") == null ? "0" : sexPieMap.get("0").getAmount()));
            exportItem.setMan(String.valueOf(sexPieMap.get("1") == null ? "0" : sexPieMap.get("1").getAmount()));
            exportItem.setWoman(String.valueOf(sexPieMap.get("2") == null ? "0" : sexPieMap.get("2").getAmount()));
            exportItem.setAllCount(String.valueOf(allAmount));
            exportItem.setStartTime(condition.getStartTime());
            exportItem.setEndTime(condition.getEndTime());
            exportItem.setUnKnownAge(String.valueOf(agePieMap.get("unkonw") == null ? "0" : agePieMap.get("unkonw").getAmount()));
            exportItem.setLessThanSeventeen(String.valueOf(agePieMap.get("juvenileAge") == null ? "0" : agePieMap.get("juvenileAge").getAmount()));
            exportItem.setEighteenAndThirtyFive(String.valueOf(agePieMap.get("youthAge") == null ? "0" : agePieMap.get("youthAge").getAmount()));
            exportItem.setThirtySixAndFiftyNine(String.valueOf(agePieMap.get("middleAge") == null ? "0" : agePieMap.get("middleAge").getAmount()));
            exportItem.setMoreThanSixty(String.valueOf(agePieMap.get("oldAge") == null ? "0" : agePieMap.get("oldAge").getAmount()));
        }
        Map<String, String> map = ApiIvsCheckUtil.getColumnAndI18nByClass(IvsFaceReportExportItem.class);
        HashMap allMap = new HashMap();
        HashMap<String, String> tableNameMap = new HashMap<String, String>();
        HashMap<String, String> columnNameMap = new HashMap<String, String>();
        tableNameMap.put("tableName", I18nUtil.i18nCode((String)"ivs_ext_facereport", (Object[])new Object[0]));
        columnNameMap.put("jsonColumn", JSONObject.toJSONString(map));
        allMap.put("tableName", tableNameMap);
        allMap.put("jsonColumn", columnNameMap);
        this.excelExport(Collections.singletonList(exportItem), IvsFaceReportExportItem.class, allMap);
    }
}

