/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.Tree;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.ivs.remote.IvsFaceIntelligentRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsApiDealService;
import com.zkteco.zkbiosecurity.ivs.service.IvsFaceIntelligentService;
import com.zkteco.zkbiosecurity.ivs.utils.IVSUtil;
import com.zkteco.zkbiosecurity.ivs.vo.IvsGetDeviceTreeItem;
import com.zkteco.zkbiosecurity.ivs.vo.api.HwApiVidParentDeviceItem;
import com.zkteco.zkbiosecurity.ivs.vo.api.IvsApiRtspRealPlayItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsFaceIntelligentController
extends BaseController
implements IvsFaceIntelligentRemote {
    @Autowired
    private IvsFaceIntelligentService ivsFaceIntelligentService;
    @Autowired
    private IvsApiDealService ivsApiDealService;

    @RequiresPermissions(value={"ivs:ext:faceIntelligent"})
    public ModelAndView index() {
        return new ModelAndView("/ivs/faceIntelligent/faceIntelligent");
    }

    private boolean isQueryToDevice(String id) {
        return StringUtils.isBlank((CharSequence)id) || "0".equals(id);
    }

    public Tree dynaTree(String id, Boolean showPersonCount, HwApiVidParentDeviceItem hwVidParentDeviceItem) {
        String filterDevType = this.request.getParameter("filterDevType");
        if (StringUtils.isNotBlank((CharSequence)filterDevType)) {
            hwVidParentDeviceItem.setType(filterDevType);
            hwVidParentDeviceItem.setIsFromType("1");
            String parentDeviceIds = this.request.getParameter("parentDeviceId");
            hwVidParentDeviceItem.setInId(parentDeviceIds);
        }
        String notInType = IVSUtil.getExcludedTypes(this.request);
        hwVidParentDeviceItem.setNotInType(notInType);
        List deviceTreeItems = this.ivsFaceIntelligentService.getDeviceTree(id, hwVidParentDeviceItem, this.request.getSession().getId());
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        Map<Object, Object> deviceTreeMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)deviceTreeItems) && deviceTreeItems.size() > 0) {
            deviceTreeMap = deviceTreeItems.stream().filter(ivsGetDeviceTreeItem -> ivsGetDeviceTreeItem.getParentId() != null).collect(Collectors.groupingBy(IvsGetDeviceTreeItem::getParentId));
        }
        TreeItem item = null;
        TreeItem pItem = null;
        if (CollectionUtils.isNotEmpty((Collection)deviceTreeItems)) {
            for (IvsGetDeviceTreeItem deviceTree : deviceTreeItems) {
                String isOnline;
                item = new TreeItem();
                item.setId(deviceTree.getId());
                item.setText(deviceTree.getName());
                item.setChild("1");
                String string = isOnline = "1".equals(deviceTree.getStatus()) ? "online" : "outline";
                if (this.isQueryToDevice(id) && Objects.isNull(deviceTree.getParentId())) {
                    item.setOpen(null);
                    item.setChild(null);
                    List ivsGetDeviceTreeItems = (List)deviceTreeMap.get(deviceTree.getId());
                    if (!CollectionUtils.isEmpty((Collection)ivsGetDeviceTreeItems) && ivsGetDeviceTreeItems.size() > 0) {
                        Integer deviceCount = ivsGetDeviceTreeItems.size();
                        List ivsGetDeviceTreeOnlineItems = ivsGetDeviceTreeItems.stream().filter(ivsGetDeviceTreeItem -> "1".equals(ivsGetDeviceTreeItem.getStatus())).collect(Collectors.toList());
                        Integer deviceOnlineCount = ivsGetDeviceTreeOnlineItems.size();
                        item.setText(deviceTree.getName() + "(" + deviceOnlineCount + "/" + deviceCount + ")");
                    } else {
                        item.setText(deviceTree.getName() + "(0/0)");
                    }
                    item.setIm0("details_open.png");
                    item.setIm1("details_open.png");
                    item.setIm2("details_close.png");
                } else {
                    item.setOpen(null);
                    item.setIm0(deviceTree.getCameraType().toLowerCase() + "_" + isOnline + ".png");
                    item.setIm1(deviceTree.getCameraType().toLowerCase() + "_" + isOnline + ".png");
                    item.setIm2(deviceTree.getCameraType().toLowerCase() + "_" + isOnline + ".png");
                }
                pItem = deviceTree.getParentId() != null ? new TreeItem(deviceTree.getParentId()) : new TreeItem("0");
                item.setParent(pItem);
                items.add(item);
            }
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        Tree tree = new Tree(treeItems);
        tree.setId(StringUtils.isBlank((CharSequence)id) ? "0" : id);
        return tree;
    }

    public Tree dynaTreeWithType(String id, Boolean showPersonCount, HwApiVidParentDeviceItem hwVidParentDeviceItem) {
        return this.getDeviceTree(id, showPersonCount, hwVidParentDeviceItem, "1");
    }

    public Tree dynaTree4TvWall(String id, Boolean showPersonCount, HwApiVidParentDeviceItem hwVidParentDeviceItem) {
        return this.getDeviceTree(id, showPersonCount, hwVidParentDeviceItem, "2");
    }

    private Tree getDeviceTree(String id, Boolean showPersonCount, HwApiVidParentDeviceItem hwVidParentDeviceItem, String type) {
        String filterDevType = this.request.getParameter("filterDevType");
        if (StringUtils.isNotBlank((CharSequence)filterDevType)) {
            hwVidParentDeviceItem.setType(filterDevType);
            hwVidParentDeviceItem.setIsFromType("1");
            String parentDeviceIds = this.request.getParameter("parentDeviceId");
            hwVidParentDeviceItem.setInId(parentDeviceIds);
        }
        String notInType = IVSUtil.getExcludedTypes(this.request);
        hwVidParentDeviceItem.setNotInType(notInType);
        List deviceTreeItems = this.ivsFaceIntelligentService.getDeviceTree(id, hwVidParentDeviceItem, this.request.getSession().getId());
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        Map<Object, Object> deviceTreeMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)deviceTreeItems) && deviceTreeItems.size() > 0) {
            deviceTreeMap = deviceTreeItems.stream().filter(ivsGetDeviceTreeItem -> ivsGetDeviceTreeItem.getParentId() != null).collect(Collectors.groupingBy(IvsGetDeviceTreeItem::getParentId));
        }
        TreeItem item = null;
        TreeItem pItem = null;
        if (CollectionUtils.isNotEmpty((Collection)deviceTreeItems)) {
            for (IvsGetDeviceTreeItem deviceTree : deviceTreeItems) {
                String isOnline;
                item = new TreeItem();
                String deviceTreeId = deviceTree.getId();
                switch (type) {
                    case "1": {
                        deviceTreeId = deviceTreeId + "#" + deviceTree.getType();
                        break;
                    }
                    case "2": {
                        if (StringUtils.isNotBlank((CharSequence)deviceTree.getParentId())) {
                            deviceTreeId = deviceTreeId + "#" + deviceTree.getType() + "#" + deviceTree.getParentId() + "#" + deviceTree.getStatus();
                            break;
                        }
                        deviceTreeId = deviceTreeId + "#" + deviceTree.getType();
                        break;
                    }
                }
                item.setId(deviceTreeId);
                item.setText(deviceTree.getName());
                item.setChild("1");
                String string = isOnline = "1".equals(deviceTree.getStatus()) ? "online" : "outline";
                if (this.isQueryToDevice(id) && Objects.isNull(deviceTree.getParentId())) {
                    item.setOpen(null);
                    item.setChild(null);
                    List ivsGetDeviceTreeItems = (List)deviceTreeMap.get(deviceTree.getId());
                    if (!CollectionUtils.isEmpty((Collection)ivsGetDeviceTreeItems) && ivsGetDeviceTreeItems.size() > 0) {
                        Integer deviceCount = ivsGetDeviceTreeItems.size();
                        List ivsGetDeviceTreeOnlineItems = ivsGetDeviceTreeItems.stream().filter(ivsGetDeviceTreeItem -> "1".equals(ivsGetDeviceTreeItem.getStatus())).collect(Collectors.toList());
                        Integer deviceOnlineCount = ivsGetDeviceTreeOnlineItems.size();
                        item.setText(deviceTree.getName() + "(" + deviceOnlineCount + "/" + deviceCount + ")");
                    } else {
                        item.setText(deviceTree.getName() + "(0/0)");
                    }
                    item.setIm0("details_open.png");
                    item.setIm1("details_open.png");
                    item.setIm2("details_close.png");
                } else {
                    item.setOpen(null);
                    item.setIm0(deviceTree.getCameraType().toLowerCase() + "_" + isOnline + ".png");
                    item.setIm1(deviceTree.getCameraType().toLowerCase() + "_" + isOnline + ".png");
                    item.setIm2(deviceTree.getCameraType().toLowerCase() + "_" + isOnline + ".png");
                }
                pItem = deviceTree.getParentId() != null ? new TreeItem(deviceTree.getParentId() + "#" + deviceTree.getType()) : new TreeItem("0");
                item.setParent(pItem);
                items.add(item);
            }
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        Tree tree = new Tree(treeItems);
        tree.setId(StringUtils.isBlank((CharSequence)id) ? "0" : id);
        return tree;
    }

    @LogRequest(module="ivs_module", object="ivs_intelligent_face", opType="ivs_log_opType_get", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg getPerimeterFace(String channelCode, String parentDeviceId) {
        ZKResultMsg perimeterFace = this.ivsFaceIntelligentService.getFaceIntelligent(channelCode, parentDeviceId, "perimeterFace");
        return perimeterFace;
    }

    @LogRequest(module="ivs_module", object="ivs_intelligent_face", opType="ivs_log_opType_set", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg setPerimeterFace(String perimeterFaceObject) {
        ZKResultMsg perimeterFace = this.ivsFaceIntelligentService.setFaceIntelligent(perimeterFaceObject, "perimeterFace");
        return perimeterFace;
    }

    public ZKResultMsg getDeviceRtsp(String channelCode, String parentDeviceId) {
        IvsApiRtspRealPlayItem ivsApiRtspRealPlayItem = new IvsApiRtspRealPlayItem();
        ivsApiRtspRealPlayItem.setChannelCode(channelCode);
        ivsApiRtspRealPlayItem.setVidParentDeviceId(parentDeviceId);
        ivsApiRtspRealPlayItem.setType(Integer.valueOf(2));
        ZKResultMsg deviceRtsp = this.ivsApiDealService.getDeviceRtsp(ivsApiRtspRealPlayItem);
        return deviceRtsp;
    }

    @LogRequest(module="ivs_module", object="ivs_intelligent_face", opType="ivs_log_opType_get", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg getMaskAlarm(String channelCode, String parentDeviceId) {
        ZKResultMsg maskAlarm = this.ivsFaceIntelligentService.getFaceIntelligent(channelCode, parentDeviceId, "maskAlarm");
        return maskAlarm;
    }

    @LogRequest(module="ivs_module", object="ivs_intelligent_face", opType="ivs_log_opType_set", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg setMaskAlarm(String maskAlarmObject) {
        ZKResultMsg maskAlarm = this.ivsFaceIntelligentService.setFaceIntelligent(maskAlarmObject, "maskAlarm");
        return maskAlarm;
    }

    @LogRequest(module="ivs_module", object="ivs_intelligent_face", opType="ivs_log_opType_get", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg getFaceRecognition(String channelCode, String parentDeviceId) {
        ZKResultMsg faceRecognition = this.ivsFaceIntelligentService.getFaceIntelligent(channelCode, parentDeviceId, "faceRecognition");
        return faceRecognition;
    }

    @LogRequest(module="ivs_module", object="ivs_intelligent_face", opType="ivs_log_opType_set", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg setFaceRecognition(String faceRecognitionObject) {
        ZKResultMsg faceRecognition = this.ivsFaceIntelligentService.setFaceIntelligent(faceRecognitionObject, "faceRecognition");
        return faceRecognition;
    }

    public ModelAndView videoScribing(String data) {
        if (StringUtils.isNotBlank((CharSequence)data)) {
            JSONObject dataObject = JSON.parseObject((String)data);
            this.request.setAttribute("intelligentType", (Object)dataObject.getString("intelligentType"));
            this.request.setAttribute("ivsSchDetailsTabId", (Object)dataObject.getString("ivsSchDetailsTabId"));
            this.request.setAttribute("editPage", (Object)true);
            this.request.setAttribute("data", (Object)data);
        }
        return new ModelAndView("/ivs/faceIntelligent/ivsVideoScribing");
    }
}

