/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.utils.Base64Util;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.ivs.remote.IvsFaceComparisonRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsApiDealService;
import com.zkteco.zkbiosecurity.ivs.service.IvsEdgeDeviceService;
import com.zkteco.zkbiosecurity.ivs.service.IvsFaceComparisonService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsFaceComparisonItem;
import com.zkteco.zkbiosecurity.ivs.vo.api.HwApiPersExtPersonItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsFaceComparisonController
extends BaseController
implements IvsFaceComparisonRemote {
    @Autowired
    private IvsFaceComparisonService ivsFaceComparisonService;
    @Autowired
    private IvsApiDealService ivsApiDealService;
    @Autowired
    private IvsEdgeDeviceService ivsEdgeDeviceService;

    @RequiresPermissions(value={"ivs:retrieval:comparison"})
    public ModelAndView index() {
        return new ModelAndView("ivs/faceComparison/faceComparison");
    }

    public ZKResultMsg getAlgorithmCode(String vidExtDeviceId) {
        ZKResultMsg zkResultMsg = this.ivsFaceComparisonService.getAlgorithmCode(vidExtDeviceId);
        return zkResultMsg;
    }

    public ZKResultMsg comparison(@RequestParam(value="leftPhoto") MultipartFile leftPhoto, @RequestParam(value="rightPhoto") MultipartFile rightPhoto, IvsFaceComparisonItem item) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String[] imgStr = new String[2];
        try {
            if (StringUtils.isBlank((CharSequence)item.getDecryptPhotoOne())) {
                if (Long.parseLong(FileUtils.getFileSize((MultipartFile)leftPhoto)) != 0L) {
                    imgStr[0] = Base64Util.encode((byte[])leftPhoto.getBytes());
                }
                if (StringUtils.isNotEmpty((CharSequence)item.getImageOne())) {
                    imgStr[0] = item.getImageOne();
                }
            } else {
                imgStr[0] = item.getDecryptPhotoOne();
            }
            if (StringUtils.isBlank((CharSequence)item.getDecryptPhotoTwo())) {
                if (Long.parseLong(FileUtils.getFileSize((MultipartFile)rightPhoto)) != 0L) {
                    imgStr[1] = Base64Util.encode((byte[])rightPhoto.getBytes());
                }
                if (StringUtils.isNotEmpty((CharSequence)item.getImageTwo())) {
                    imgStr[1] = item.getImageTwo();
                }
            } else {
                imgStr[1] = item.getDecryptPhotoTwo();
            }
        }
        catch (IOException e) {
            this.log.error("Picture conversion abnormal!");
        }
        IvsFaceComparisonItem ivsFaceComparisonItem = new IvsFaceComparisonItem();
        ivsFaceComparisonItem.setImageOne(imgStr[0]);
        ivsFaceComparisonItem.setImageTwo(imgStr[1]);
        ivsFaceComparisonItem.setAlgorithmCode(item.getAlgorithmCode());
        ivsFaceComparisonItem.setVidExtDeviceId(item.getVidExtDeviceId());
        zkResultMsg = this.ivsFaceComparisonService.faceComparison(ivsFaceComparisonItem);
        return zkResultMsg;
    }

    public void filterEmployee() {
        try {
            this.response.setContentType("text/xml;charset=utf-8");
            this.response.setHeader("Cache-Control", "no-cache");
            StringBuffer result = new StringBuffer();
            result.append("<complete>");
            String hostId = this.request.getParameter("mask");
            if (StringUtils.isNotBlank((CharSequence)hostId)) {
                HwApiPersExtPersonItem hwApiPersExtPersonItem = new HwApiPersExtPersonItem();
                hwApiPersExtPersonItem.setCurrency(hostId);
                ZKResultMsg zkResultMsg = this.ivsApiDealService.getPersByCondition(hwApiPersExtPersonItem);
                List persPersonItems = (List)zkResultMsg.getData();
                for (PersPersonItem personItem : persPersonItems) {
                    if (StringUtils.isNotBlank((CharSequence)personItem.getPhotoPath())) {
                        personItem.setPhotoBase64("data:image/jpg;base64," + this.ivsEdgeDeviceService.isEnablePictureBlur(personItem.getPhotoPath()));
                    }
                    this.setEmployeeInfo(result, personItem);
                }
                result.append("</complete>");
                this.response.getWriter().write(result.toString());
                return;
            }
        }
        catch (IOException e) {
            this.log.error("ivs ivsFaceComparisonController filterEmployee error : " + e.getMessage());
        }
    }

    private void setEmployeeInfo(StringBuffer result, PersPersonItem employee) {
        result.append("<option value=\"" + employee.getId() + "\">");
        result.append("<text>");
        result.append("<photo>");
        result.append("<![CDATA[" + (String)StringUtils.defaultIfEmpty((CharSequence)employee.getPhotoBase64(), (CharSequence)"/images/PC/userImage.png") + "]]>");
        result.append("</photo>");
        result.append("<pin>");
        result.append(this.ivsEdgeDeviceService.convertToEncrypt(employee.getPin(), "pers.pin.encryptProp", "pers.pin.encryptMode"));
        result.append("</pin>");
        result.append("<decryptPhoto>");
        result.append("data:image/jpg;base64," + employee.getPhotoPath());
        result.append("</decryptPhoto>");
        String employeeName = StringUtils.isNotEmpty((CharSequence)employee.getName()) ? employee.getName() : "";
        result.append("<name>");
        result.append(this.ivsEdgeDeviceService.convertToEncrypt(employeeName, "pers.name.encryptProp", "pers.name.encryptMode"));
        result.append("</name>");
        result.append("</text>");
        result.append("</option>");
    }
}

