/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.ivs.utils.IvsExcelUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;

public class IvsExportController
extends BaseController {
    public static final String IMPORT_RESULT = "import-result:";
    public static final String EXPORT_RESULT = "export-result:";
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Value(value="${security.session.timeout:1800}")
    private Long sessionTimeout;
    @Value(value="${system.maxExportCount:30000}")
    private Integer maxExportCount;

    public <T> void excelExport(List<T> list, Class<T> cls) {
        this.excelExport(list, cls, null, null);
    }

    protected <T> void excelExport(List<T> list, Class<T> cls, Map<String, Map<String, String>> map, Map<String, String> addReportDetailMap) {
        if (list == null || 0 == list.size()) {
            throw new ZKBusinessException("common_report_dataSourceNull");
        }
        if (this.isNeedValid("pwd")) {
            try {
                String loginPwd = this.request.getParameter("loginPwd");
                Object authUserService = SpringContextUtil.getBean((String)"authUserServiceImpl");
                Object result = MethodUtils.invokeMethod((Object)authUserService, (String)"verifySecurity", (Object[])new Object[]{WebContextUtil.getCurrentSessionId(), loginPwd, "pwd"});
                if (!((Boolean)result).booleanValue()) {
                    throw new ZKBusinessException("auth_user_pwdIncorrect");
                }
            }
            catch (ZKBusinessException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error("", (Throwable)e);
            }
        }
        String reportType = this.request.getParameter("reportType");
        String jsonColumn = this.request.getParameter("jsonColumn");
        String fileName = this.request.getParameter("tableNameParam");
        String tableName = this.request.getParameter("tableNameSearch");
        String isEncrypt = this.request.getParameter("isEncrypt");
        String encryptPassword = this.request.getParameter("encryptPassword");
        addReportDetailMap = new HashMap<String, String>();
        if (map != null && map.get("jsonColumn") != null) {
            Map<String, String> jsonColumnMap = map.get("jsonColumn");
            jsonColumn = jsonColumnMap.get("jsonColumn");
        }
        if (!StringUtils.isBlank((CharSequence)tableName)) {
            fileName = tableName;
        }
        if (map != null && map.get("tableName") != null) {
            Map<String, String> tableNameMap = map.get("tableName");
            fileName = tableNameMap.get("tableName");
        }
        String encryptFileName = fileName;
        String gridName = fileName;
        if (StringUtils.isBlank((CharSequence)reportType)) {
            reportType = "xlsx";
        }
        reportType = reportType.toLowerCase();
        Object fileOutputStream = null;
        try {
            String agent = this.request.getHeader("User-Agent").toLowerCase();
            if (this.request.getHeader("User-Agent") != null && agent.indexOf("edge") != -1) {
                fileName = fileName.replaceAll(" ", "%20");
                fileName = URLEncoder.encode(fileName, "UTF-8");
                fileName = fileName.replace("%2520", " ");
            } else if (agent != null && (agent.indexOf("msie") != -1 || agent.indexOf("rv") != -1 && agent.indexOf("firefox") == -1)) {
                fileName = fileName.replaceAll(" ", "%20");
                fileName = URLEncoder.encode(fileName, "UTF-8");
                fileName = fileName.replace("%2520", " ");
            } else {
                fileName = agent != null && agent.indexOf("firefox") != -1 ? new String(fileName.getBytes("UTF-8"), "ISO-8859-1") : new String(fileName.getBytes("UTF-8"), "ISO-8859-1");
            }
            if (StringUtils.isNotBlank((CharSequence)isEncrypt) && "1".equals(isEncrypt)) {
                if (!StringUtils.isNotBlank((CharSequence)encryptPassword)) {
                    throw new ZKBusinessException("common_report_exportFaild");
                }
                encryptFileName = encryptFileName.replaceAll("\\+", " ");
                this.encryptFileExport(tableName, encryptFileName, fileName, reportType, gridName, encryptPassword, fileOutputStream, list, cls, map, jsonColumn, addReportDetailMap);
            } else {
                this.response.setCharacterEncoding("utf-8");
                this.response.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "." + reportType + "\"");
                this.response.setContentType("application/octet-stream");
                ServletOutputStream os = this.response.getOutputStream();
                IvsExcelUtil.excelExport(list, cls, jsonColumn, gridName, (OutputStream)os, reportType, map, addReportDetailMap);
                os.flush();
            }
        }
        catch (Exception e) {
            this.log.error(fileName + " export error", (Throwable)e);
            this.response.setHeader("Content-Disposition", "");
            this.response.setContentType("application/json");
            throw new ZKBusinessException("common_report_exportFaild");
        }
        finally {
            this.stringRedisTemplate.opsForValue().set((Object)(EXPORT_RESULT + this.request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)(EXPORT_RESULT + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
        }
    }

    protected <T> void encryptFileExport(String tableName, String encryptFileName, String fileName, String reportType, String gridName, String password, FileOutputStream fileOutputStream, List<T> list, Class<T> cls, Map<String, Map<String, String>> map, String jsonColumn, Map<String, String> addReportDetailMap) throws Exception {
        String fileNamePrefix = "";
        if (StringUtils.isNotBlank((CharSequence)tableName)) {
            fileNamePrefix = tableName;
        } else if (StringUtils.isNotBlank((CharSequence)encryptFileName)) {
            fileNamePrefix = encryptFileName;
        }
        String fileZipName = fileName;
        fileName = ClassUtil.getRootPath() + File.separator + FileUtil.systemFilePath + File.separator + "upload" + File.separator + fileNamePrefix + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "." + reportType.toLowerCase();
        File folder = new File(fileName);
        if (!folder.getParentFile().exists()) {
            folder.getParentFile().mkdirs();
        }
        fileOutputStream = new FileOutputStream(fileName);
        IvsExcelUtil.excelExport(list, cls, jsonColumn, gridName, fileOutputStream, reportType, map, addReportDetailMap);
        ArrayList<File> files = new ArrayList<File>();
        File file = new File(fileName);
        if (file.exists()) {
            files.add(file);
        }
        String tempPath = ClassUtil.getRootPath() + File.separator + FileUtil.systemFilePath + File.separator + "upload" + File.separator + fileZipName + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".zip";
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new ZKBusinessException("common_report_exportFaild");
        }
        this.response = FileUtil.fileEncryptZip((String)tempPath, files, (String)password, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        this.response.flushBuffer();
        File zipTempFile = new File(tempPath);
        if (zipTempFile.exists()) {
            zipTempFile.delete();
        }
        for (File f : files) {
            if (!f.exists()) continue;
            f.delete();
        }
    }

    public void setConditionValue(BaseItem conditionItem) {
        String[] conditionAry;
        this.stringRedisTemplate.opsForValue().set((Object)(EXPORT_RESULT + this.request.getSession().getId()), (Object)"start");
        String queryCondition = this.request.getParameter("queryConditions");
        String sortOrder = this.request.getParameter("sortOrder");
        String sortName = this.request.getParameter("sortName");
        if (StringUtils.isNotBlank((CharSequence)sortOrder) && StringUtils.isNotBlank((CharSequence)sortName)) {
            conditionItem.setSortName(sortName);
            conditionItem.setSortOrder(sortOrder);
        }
        if (StringUtils.isBlank((CharSequence)queryCondition)) {
            return;
        }
        for (String condition : conditionAry = queryCondition.replaceAll("%20", " ").split("&")) {
            if (StringUtils.isBlank((CharSequence)condition)) continue;
            String[] strAry = condition.split("=", 2);
            String fieldName = strAry[0];
            String fieldValue = strAry[1];
            try {
                Field field = conditionItem.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                fieldValue = URLDecoder.decode(fieldValue, "UTF-8");
                if (!StringUtils.isNotBlank((CharSequence)fieldValue)) continue;
                if ("java.util.Date".equals(field.getType().getTypeName())) {
                    field.set(conditionItem, DateUtil.stringToDate((String)fieldValue));
                    continue;
                }
                if ("java.sql.Timestamp".equals(field.getType().getTypeName())) {
                    field.set(conditionItem, new Timestamp(DateUtil.stringToDate((String)fieldValue).getTime()));
                    continue;
                }
                field.set(conditionItem, ConvertUtils.convert((String)fieldValue, field.getType()));
            }
            catch (Exception e) {
                this.log.error("setConditionValue", (Throwable)e);
            }
        }
    }

    protected int getBeginIndex() {
        String exportType = this.request.getParameter("exportType");
        String recordStart = this.request.getParameter("recordstart");
        String recordCount = this.request.getParameter("recordcount");
        int beginIndex = 0;
        if ("3".equals(exportType) && StringUtils.isNotBlank((CharSequence)recordStart) && StringUtils.isNotBlank((CharSequence)recordCount)) {
            beginIndex = Integer.valueOf(recordStart);
            beginIndex = beginIndex > 0 ? beginIndex - 1 : beginIndex;
        }
        return beginIndex;
    }

    protected int getEndIndex() {
        String exportType = this.request.getParameter("exportType");
        String recordStart = this.request.getParameter("recordstart");
        String recordCount = this.request.getParameter("recordcount");
        int endIndex = this.maxExportCount - 1;
        if ("3".equals(exportType) && StringUtils.isNotBlank((CharSequence)recordStart) && StringUtils.isNotBlank((CharSequence)recordCount)) {
            int beginIndex = Integer.valueOf(recordStart);
            beginIndex = beginIndex > 0 ? beginIndex - 1 : beginIndex;
            int maxCount = Integer.valueOf(recordCount) > this.maxExportCount ? this.maxExportCount : Integer.valueOf(recordCount);
            endIndex = beginIndex + maxCount - 1;
        }
        return endIndex;
    }

    protected boolean isNeedValid(String mode) {
        try {
            Object value;
            Object authSecurityParamsService = SpringContextUtil.getBean((String)"authSecurityParamsServiceImpl");
            Object result = MethodUtils.invokeMethod((Object)authSecurityParamsService, (String)"getPwdRequiredForOperation");
            if (result != null && "0".equals(result.toString())) {
                return false;
            }
            String id = WebContextUtil.getCurrentSessionId();
            String key = "valid_" + id;
            if (StringUtils.isNotBlank((CharSequence)mode) && mode.indexOf(":") != -1) {
                key = "valid_" + mode.split(":")[0].trim() + id;
            }
            return !Objects.nonNull(value = this.stringRedisTemplate.opsForValue().get((Object)key));
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            return false;
        }
    }
}

