/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.ivs.remote.IvsDevicePersonnelListRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsEdgeDeviceService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsPersonnelListItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsDevicePersonnelListController
extends BaseController
implements IvsDevicePersonnelListRemote {
    @Autowired
    private IvsEdgeDeviceService ivsEdgeDeviceService;

    public ModelAndView index() {
        return new ModelAndView("ivs/devicePersonnelList/devicePersonnelList");
    }

    public DxGrid list(IvsPersonnelListItem condition) {
        Pager pager = this.ivsEdgeDeviceService.getDevPersonnelItemsByPage(condition, this.getPageNo(), this.getPageSize());
        DxGrid data = GridUtil.convert((Pager)pager, condition.getClass());
        return data;
    }

    public ZKResultMsg delPersonnelList(String parentDeviceId, String name, String type) {
        if (StringUtils.isBlank((CharSequence)parentDeviceId) || StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)type)) {
            return ZKResultMsg.failMsg((String)"common_commStatus_dataParamError", (Object[])new Object[0]);
        }
        return this.ivsEdgeDeviceService.delPersonnelListByNameAndType(parentDeviceId, name, type);
    }
}

