/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsDeviceRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsApiDealService;
import com.zkteco.zkbiosecurity.ivs.service.IvsCameraSettingService;
import com.zkteco.zkbiosecurity.ivs.service.IvsChannelService;
import com.zkteco.zkbiosecurity.ivs.service.IvsDeviceService;
import com.zkteco.zkbiosecurity.ivs.service.IvsEdgeDeviceService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsCameraSettingItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsChannelDeviceItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsChannelItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsDeviceItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsEdgeDeviceItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsExtDeviceItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsMainDevItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsServerRecordingPlanItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsStorageManageDeviceItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsStorageStrategyItem;
import com.zkteco.zkbiosecurity.ivs.vo.api.HwApiRtspItem;
import com.zkteco.zkbiosecurity.ivs.vo.api.IvsApiRtspPlayBackItem;
import com.zkteco.zkbiosecurity.ivs.vo.dsServer.IvsSnapshotItem;
import com.zkteco.zkbiosecurity.ivs.vo.dsServer.IvsVideoItem;
import com.zkteco.zkbiosecurity.ivs.vo.enums.RecordTypeEnum;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsDeviceController
extends ExportController
implements IvsDeviceRemote {
    @Autowired
    private IvsDeviceService ivsDeviceService;
    @Autowired
    private IvsCameraSettingService ivsCameraSettingService;
    @Autowired
    private IvsEdgeDeviceService ivsEdgeDeviceService;
    @Autowired
    private IvsApiDealService ivsApiDealService;
    @Autowired
    private IvsChannelService ivsChannelService;

    @RequiresPermissions(value={"ivs:clientDevice:channel"})
    public ModelAndView index() {
        return new ModelAndView("ivs/device/vidDevice");
    }

    @RequiresPermissions(value={"ivs:subDevice:edit"})
    public ModelAndView edit(String id, String parentDeviceId) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.ivsDeviceService.getItemById(id));
        }
        this.request.setAttribute("parentItem", (Object)this.ivsEdgeDeviceService.getItemById(parentDeviceId));
        return new ModelAndView("ivs/device/editVidExtDevice");
    }

    public ModelAndView editDeviceName(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.ivsDeviceService.getItemById(id));
        }
        return new ModelAndView("ivs/device/editVidExtDeviceName");
    }

    public ZKResultMsg saveVidExtDeviceName(IvsDeviceItem item) {
        return this.ivsDeviceService.saveVidExtDeviceName(item);
    }

    @LogChangeRequest(module="ivs_module", object="ivs_camera", opType="common_adf_save", vo=IvsDeviceItem.class, service=IvsDeviceService.class)
    public ZKResultMsg saveClientDevice(IvsDeviceItem item) {
        ZKResultMsg res = this.ivsDeviceService.saveClientItem(item, this.request.getSession().getId());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_camera", requestParams={"cameraName"}, opContent="ivs_iClient_adjustment_area")
    public ZKResultMsg saveDeviceArea(String ids, String areaId) {
        ZKResultMsg res = this.ivsDeviceService.saveDeviceArea(ids, areaId);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ivs:subDevice:refresh"})
    public DxGrid list(IvsDeviceItem condition) {
        Pager pager = this.ivsDeviceService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getExtDeviceList(IvsExtDeviceItem condition) {
        Pager pager = this.ivsDeviceService.getExtItemsByPage(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_camera", requestParams={"devName"}, opContent="common_op_del")
    @RequiresPermissions(value={"ivs:subDevice:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = this.ivsDeviceService.deleteDevByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_camera", requestParams={"name"}, opContent="common_dev_reboot")
    public ZKResultMsg reboot(String ids, String isDefault) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.ivsDeviceService.rebootDevByIds(ids, isDefault);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public ZKResultMsg getRTSPStreamEdgeDeviceInfo(IvsChannelItem ivsChannelItem) {
        ZKResultMsg zkResultMsg = this.ivsDeviceService.getRTSPStreamByClientType(ivsChannelItem);
        return zkResultMsg;
    }

    public ZKResultMsg getRTSPStream(IvsChannelItem ivsChannelItem) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)ivsChannelItem.getId())) {
            ivsChannelItem = this.ivsChannelService.getItemById(ivsChannelItem.getId());
        } else {
            String cameraName = this.ivsChannelService.getNameByCodeAndParentDevId(ivsChannelItem.getChannelCode(), ivsChannelItem.getVidParentDeviceId());
            if (StringUtils.isNotBlank((CharSequence)cameraName)) {
                ivsChannelItem.setCameraName(cameraName);
            }
        }
        ZKResultMsg streamResult = this.ivsDeviceService.getRTSPStream(ivsChannelItem);
        List rtspStream = (List)streamResult.getData();
        if (CollectionUtils.isEmpty((Collection)rtspStream) || rtspStream.size() <= 0) {
            return streamResult;
        }
        HwApiRtspItem hwApiRtspItem = (HwApiRtspItem)rtspStream.get(0);
        hwApiRtspItem.setChannelCode(ivsChannelItem.getChannelCode());
        hwApiRtspItem.setVidParentDeviceId(ivsChannelItem.getVidParentDeviceId());
        hwApiRtspItem.setCameraName(ivsChannelItem.getCameraName());
        zkResultMsg.setData((Object)hwApiRtspItem);
        return zkResultMsg;
    }

    public ModelAndView toShowRTSPStreamView(String id) {
        List ivsChannelItems;
        IvsDeviceItem ivsDeviceItem;
        if (StringUtils.isNotBlank((CharSequence)id) && Objects.nonNull(ivsDeviceItem = this.ivsDeviceService.getItemById(id)) && Objects.nonNull(ivsChannelItems = this.ivsChannelService.getItemByDevId(id)) && ivsChannelItems.size() > 0) {
            List rtspStream;
            IvsChannelItem item = (IvsChannelItem)ivsChannelItems.get(0);
            item.setVidParentDeviceId(ivsDeviceItem.getVidParentDeviceId());
            ZKResultMsg streamResult = this.ivsDeviceService.getRTSPStream(item);
            if (streamResult.isSuccess() && !CollectionUtils.isEmpty((Collection)(rtspStream = (List)streamResult.getData())) && rtspStream.size() > 0) {
                this.request.setAttribute("rtspStream", (Object)rtspStream);
            }
        }
        return new ModelAndView("ivs/device/showRtspStream");
    }

    public ZKResultMsg getDrawLineRTSPStream(IvsChannelItem ivsChannelItem) {
        ZKResultMsg streamResult;
        List rtspStream;
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)ivsChannelItem.getId())) {
            ivsChannelItem = this.ivsChannelService.getItemById(ivsChannelItem.getId());
        }
        if (CollectionUtils.isEmpty((Collection)(rtspStream = (List)(streamResult = this.ivsDeviceService.getRTSPStream(ivsChannelItem)).getData())) || rtspStream.size() <= 0) {
            return streamResult;
        }
        zkResultMsg.setData(rtspStream.get(0));
        return zkResultMsg;
    }

    public ZKResultMsg getRtspPlayBack(IvsApiRtspPlayBackItem ivsApiRtspPlayBackItem) {
        if (StringUtils.isNotBlank((CharSequence)ivsApiRtspPlayBackItem.getId())) {
            IvsChannelItem ivsChannelItem = this.ivsChannelService.getItemById(ivsApiRtspPlayBackItem.getId());
            if (Objects.nonNull(ivsChannelItem)) {
                ivsApiRtspPlayBackItem.setCameraName(ivsChannelItem.getCameraName());
                ivsApiRtspPlayBackItem.setChannelCode(ivsChannelItem.getChannelCode());
                ivsApiRtspPlayBackItem.setVidParentDeviceId(ivsChannelItem.getVidParentDeviceId());
            }
        } else {
            String name = this.ivsChannelService.getNameByCodeAndParentDevId(ivsApiRtspPlayBackItem.getChannelCode(), ivsApiRtspPlayBackItem.getVidParentDeviceId());
            if (StringUtils.isNotBlank((CharSequence)name)) {
                ivsApiRtspPlayBackItem.setCameraName(name);
            }
        }
        if (StringUtils.isBlank((CharSequence)ivsApiRtspPlayBackItem.getClientType())) {
            ivsApiRtspPlayBackItem.setClientType("0");
        }
        ArrayList<RecordTypeEnum> typeList = new ArrayList<RecordTypeEnum>();
        typeList.add(RecordTypeEnum.PLAN);
        typeList.add(RecordTypeEnum.MANUAL);
        typeList.add(RecordTypeEnum.ALARM);
        ivsApiRtspPlayBackItem.setTypeList(typeList);
        IvsEdgeDeviceItem ivsEdgeDeviceItem = this.ivsEdgeDeviceService.getItemById(ivsApiRtspPlayBackItem.getVidParentDeviceId());
        if (Objects.nonNull(ivsEdgeDeviceItem) && ivsEdgeDeviceItem.getType().equals("7")) {
            ivsApiRtspPlayBackItem.setStartDate(ivsApiRtspPlayBackItem.getStartDate2() != null ? ivsApiRtspPlayBackItem.getStartDate2() : ivsApiRtspPlayBackItem.getStartDate());
            ivsApiRtspPlayBackItem.setEndDate(ivsApiRtspPlayBackItem.getEndDate2() != null ? ivsApiRtspPlayBackItem.getEndDate2() : ivsApiRtspPlayBackItem.getEndDate());
        }
        return this.ivsApiDealService.getRtspPlayBack(ivsApiRtspPlayBackItem);
    }

    public ModelAndView getIClientCameraSetting(String code, String domainCode) {
        IvsCameraSettingItem vidCameraSettingItem = new IvsCameraSettingItem();
        vidCameraSettingItem.setId(domainCode + "$" + code);
        this.request.setAttribute("item", (Object)vidCameraSettingItem);
        return new ModelAndView("ivs/device/vidChannelSetting");
    }

    public ZKResultMsg getCameraSettingParams(String id, String type) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        IvsDeviceItem ivsDeviceItem = new IvsDeviceItem();
        if (id.contains("$")) {
            String[] cameraSign = id.split("\\$");
            ivsDeviceItem = this.ivsDeviceService.getItemByDomianCodeAndCode(cameraSign[0], cameraSign[1]);
        } else {
            ivsDeviceItem = this.ivsDeviceService.getItemById(id);
        }
        if (Objects.nonNull(ivsDeviceItem) && "7".equals(ivsDeviceItem.getParentType())) {
            IvsCameraSettingItem vidCameraSettingItem = this.ivsCameraSettingService.getVidCameraSettingParam(ivsDeviceItem.getDomainCode(), ivsDeviceItem.getCode(), type);
            vidCameraSettingItem.setId(id);
            resultMsg.setData((Object)vidCameraSettingItem);
        }
        return resultMsg;
    }

    public ZKResultMsg setCameraSettingParams(IvsCameraSettingItem item) {
        IvsDeviceItem ivsDeviceItem = null;
        if (item.getId().contains("$")) {
            String[] codeAndDomainCode = item.getId().split("\\$");
            ivsDeviceItem = this.ivsDeviceService.getItemByDomianCodeAndCode(codeAndDomainCode[0], codeAndDomainCode[1]);
        } else {
            ivsDeviceItem = this.ivsDeviceService.getItemById(item.getId());
        }
        if (Objects.nonNull(ivsDeviceItem)) {
            String domainCode = ivsDeviceItem.getDomainCode();
            String code = ivsDeviceItem.getCode();
            CompletableFuture.runAsync(() -> this.ivsCameraSettingService.setVidCameraSettingParam(domainCode, code, item));
            return ZKResultMsg.successMsg();
        }
        return ZKResultMsg.failMsg();
    }

    public DxGrid storageManageDeviceList(String parentDeviceId) {
        Pager pager = this.ivsDeviceService.getPagerByParentDeviceId(parentDeviceId, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, IvsStorageManageDeviceItem.class);
    }

    public ModelAndView storageStrategy(String deviceId) {
        IvsStorageStrategyItem item = this.ivsDeviceService.getStorageStrategy(deviceId);
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("ivs/parentdevice/ivsStorageStrategy");
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_iClient_storage_manage", requestParams={"cameraCode"}, opContent="ivs_iClient_storageStrategy")
    public ZKResultMsg saveStorageStrategy(IvsStorageStrategyItem item) {
        return this.ivsDeviceService.saveStorageStrategy(item);
    }

    public ModelAndView serverRecordingPlan(String deviceId) {
        IvsServerRecordingPlanItem item = this.ivsDeviceService.getServerRecordingPlan(deviceId);
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("ivs/parentdevice/ivsServerRecordingPlan");
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_iClient_storage_manage", requestParams={"cameraCode"}, opContent="ivs_iClient_serverRecordingPlan")
    public ZKResultMsg saveServerRecordingPlan(IvsServerRecordingPlanItem item) {
        return this.ivsDeviceService.saveServerRecordingPlan(item);
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_camera", requestParams={"id", "deviceUser"}, opContent="common_op_edit")
    public ZKResultMsg updateOfflinePassword(IvsMainDevItem condition) {
        String result = this.ivsDeviceService.updateOfflinePassword(condition);
        JSONObject resultObject = JSONObject.parseObject((String)result);
        if ("0".equals(resultObject.getString("resultCode"))) {
            if (resultObject.getBoolean("content").booleanValue()) {
                return ZKResultMsg.successMsg();
            }
        } else {
            return ZKResultMsg.failMsg((String)resultObject.getString("resultText"), (Object[])new Object[0]);
        }
        return ZKResultMsg.failMsg();
    }

    public ModelAndView createSnap(String id) {
        String filePath;
        List ivsChannelItems = this.ivsChannelService.getItemByDevId(id);
        if (!CollectionUtils.isEmpty((Collection)ivsChannelItems) && ivsChannelItems.size() > 0 && StringUtils.isNotBlank((CharSequence)(filePath = this.ivsDeviceService.createSnapshot(((IvsChannelItem)ivsChannelItems.get(0)).getId())))) {
            filePath = "data:image/jpg;base64," + FileEncryptUtil.getDecryptFileBase64((String)filePath);
            this.request.setAttribute("photoPath", (Object)filePath);
        }
        return new ModelAndView("ivs/analyseface/viewPhotoPath");
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_camera", requestParams={"channelName"}, opContent="common_op_edit")
    public ZKResultMsg existParentDevice() {
        List parentSeletItem = this.ivsEdgeDeviceService.getParentSeletItem();
        if (CollectionUtils.isEmpty((Collection)parentSeletItem)) {
            throw new ZKBusinessException("ivs_add_parent_device");
        }
        return new ZKResultMsg();
    }

    public ZKResultMsg getParentSeletItem() {
        return new ZKResultMsg((Object)this.ivsEdgeDeviceService.getParentSeletItem());
    }

    public ZKResultMsg getParentDeviceInfo(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            IvsDeviceItem deviceItem = this.ivsDeviceService.getItemById(id);
            return new ZKResultMsg((Object)this.ivsEdgeDeviceService.getItemById(deviceItem.getVidParentDeviceId()));
        }
        throw new ZKBusinessException("ivs_iClient_paramError");
    }

    public ModelAndView showDeviceView(String id, String devIds) {
        this.request.setAttribute("parentDeviceId", (Object)id);
        if (StringUtils.isNotBlank((CharSequence)devIds)) {
            List list = this.ivsDeviceService.getChannelIdsByDeviceIds(Arrays.asList(devIds.split(",")));
            list.forEach(channelId -> {
                IvsChannelItem item = this.ivsChannelService.getItemById(channelId);
                if (Objects.nonNull(item)) {
                    IvsChannelDeviceItem ivsChannelDeviceItem = this.ivsDeviceService.buildDeviceRtsp(item);
                    this.ivsDeviceService.addChannelDevice(ivsChannelDeviceItem);
                }
            });
        }
        return new ModelAndView("ivs/device/channelDevice");
    }

    public DxGrid deviceList(IvsChannelDeviceItem condition) {
        ZKResultMsg pager = this.ivsDeviceService.getDeviceItemPagerByParentDeviceId("parentDeviceId", condition.getName(), this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)((Pager)pager.getData()), condition.getClass());
    }

    public ZKResultMsg addChannelDevice(IvsChannelDeviceItem condition) {
        return this.ivsDeviceService.addChannelDevice(condition);
    }

    public ZKResultMsg editChannelDevice(IvsChannelDeviceItem condition) {
        return this.ivsDeviceService.editChannelDevice(condition);
    }

    public ZKResultMsg delChannels(String ids) {
        return this.ivsDeviceService.delChannelDevice(ids);
    }

    public ModelAndView createChannelSnap(String id) {
        String imgPath = this.ivsDeviceService.createChannelSnap(id);
        if (StringUtils.isNotBlank((CharSequence)imgPath)) {
            this.request.setAttribute("photoPath", (Object)FileUtils.getFileBase64Str((String)imgPath.split(",")[0]).replaceAll("\r\n", ""));
        }
        return new ModelAndView("ivs/analyseface/viewPhotoPath");
    }

    public ZKResultMsg videoDownload(IvsChannelDeviceItem condition) {
        return this.ivsDeviceService.videoDownload(condition);
    }

    public DxGrid getSnapshotList(String id) {
        Pager pager = this.ivsDeviceService.getSnapshotList(id);
        return GridUtil.convert((Pager)pager, IvsSnapshotItem.class);
    }

    public DxGrid getVideoList(String id) {
        Pager pager = this.ivsDeviceService.getVideoList(id);
        return GridUtil.convert((Pager)pager, IvsVideoItem.class);
    }
}

