/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsDeveloperLogRemote;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsDevelopLogController
extends ExportController
implements IvsDeveloperLogRemote {
    @RequiresPermissions(value={"system:developersLog"})
    public ModelAndView index() {
        return new ModelAndView("ivs/developerLog/developerLog");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export() {
        int i;
        ArrayList<File> files = new ArrayList<File>();
        String systemPath = System.getProperty("user.dir");
        String zk = systemPath + "/logs/zkbiosecurity.log";
        File zkFile = new File(zk);
        String zkError = systemPath + "/logs/zkbiosecurity-error.log";
        File zkErrorFile = new File(zkError);
        if (StringUtils.isNotBlank((CharSequence)systemPath) && (i = systemPath.lastIndexOf(System.getProperty("file.separator"))) != -1) {
            String servicePath = systemPath.substring(0, i);
            String ivs = servicePath + "/IVSClientToolkit/logs/cuserver_info.log";
            String ivsError = servicePath + "/IVSClientToolkit/logs/cuserver_error.log";
            File ivsFile = new File(ivs);
            File ivsErrorFile = new File(ivsError);
            files.add(ivsFile);
            files.add(ivsErrorFile);
        }
        files.add(zkFile);
        files.add(zkErrorFile);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        simpleDateFormat.applyPattern("yyyy_MM_dd");
        Date date = new Date();
        String ivsWebPlugin = System.getProperty("user.home") + "/AppData/Local/IVSWebPlugin/logs/" + simpleDateFormat.format(date);
        File sourceFile = new File(ivsWebPlugin);
        files.add(sourceFile);
        if (files.isEmpty()) {
            return;
        }
        ServletOutputStream outputStream = null;
        DeflaterOutputStream zipOutputStream = null;
        String timeStr = DateUtil.dateToString((Date)date, (DateUtil.DateStyle)DateUtil.DateStyle.YYYYMMDDHHMMSS);
        try {
            outputStream = this.response.getOutputStream();
            this.response.setContentType("application/force-download");
            this.response.addHeader("Content-Disposition", "attachment;fileName=DeveloperLog" + timeStr + ".zip");
            zipOutputStream = new ZipOutputStream((OutputStream)outputStream);
            for (File file : files) {
                if (!file.exists()) continue;
                IvsDevelopLogController.compress(file, (ZipOutputStream)zipOutputStream, file.getName(), true);
            }
        }
        catch (Exception e) {
            this.log.error("ivs grid export error : " + e.getMessage());
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.flush();
                    ((ZipOutputStream)zipOutputStream).close();
                }
                catch (IOException e) {
                    this.log.error("ivs grid export zipOutputStream close error : " + e.getMessage());
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException e) {
                    this.log.error("ivs grid export outputStream close error : " + e.getMessage());
                }
            }
        }
    }

    private static void compress(File sourceFile, ZipOutputStream zos, String name, boolean KeepDirStructure) throws Exception {
        byte[] buf = new byte[1024];
        if (sourceFile.isFile()) {
            int len;
            zos.putNextEntry(new ZipEntry(name));
            FileInputStream in = new FileInputStream(sourceFile);
            while ((len = in.read(buf)) != -1) {
                zos.write(buf, 0, len);
            }
            zos.closeEntry();
            in.close();
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (KeepDirStructure) {
                    zos.putNextEntry(new ZipEntry(name + "/"));
                    zos.closeEntry();
                }
            } else {
                for (File file : listFiles) {
                    if (KeepDirStructure) {
                        IvsDevelopLogController.compress(file, zos, name + "/" + file.getName(), KeepDirStructure);
                        continue;
                    }
                    IvsDevelopLogController.compress(file, zos, file.getName(), KeepDirStructure);
                }
            }
        }
    }
}

