/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ivs.remote.IvsDecoderRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsDecoderService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsDecoderItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsDecoderController
extends BaseController
implements IvsDecoderRemote {
    @Autowired
    private IvsDecoderService ivsDecoderService;

    @RequiresPermissions(value={"ivs:decoder"})
    public ModelAndView index() {
        return new ModelAndView("ivs/decoder/ivsDecoder");
    }

    @RequiresPermissions(value={"ivs:decoder:edit", "ivs:decoder:add"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.ivsDecoderService.getItemById(id));
        }
        return new ModelAndView("ivs/decoder/editIvsDecoder");
    }

    @RequiresPermissions(value={"ivs:decoder:edit", "ivs:decoder:add"})
    public ZKResultMsg save(IvsDecoderItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.ivsDecoderService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ivs:decoder:refresh"})
    public DxGrid list(IvsDecoderItem condition) {
        Pager pager = this.ivsDecoderService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ivs:decoder:del"})
    public ZKResultMsg del(String ids) {
        this.ivsDecoderService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String validName(String name) {
        IvsDecoderItem item = this.ivsDecoderService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public String validIp(String ip) {
        IvsDecoderItem item = new IvsDecoderItem();
        item.setIp(ip);
        item.setEquals(Boolean.valueOf(true));
        List items = this.ivsDecoderService.getByCondition(item);
        item = items != null && !items.isEmpty() ? (IvsDecoderItem)items.get(0) : null;
        boolean rs = item == null;
        return rs + "";
    }

    public ZKResultMsg getItemById(String ivsDecoderId) {
        ZKResultMsg res = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)ivsDecoderId)) {
            IvsDecoderItem item = new IvsDecoderItem(ivsDecoderId);
            List items = this.ivsDecoderService.getByCondition(item);
            res.setData(items != null && !items.isEmpty() ? items.get(0) : null);
        }
        return res;
    }

    public ZKResultMsg getItems() {
        return new ZKResultMsg((Object)this.ivsDecoderService.getByCondition(new IvsDecoderItem()));
    }
}

