/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.Tree;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.ivs.remote.IvsCrowdSituationalRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsCrowdSituationalService;
import com.zkteco.zkbiosecurity.ivs.service.IvsFaceIntelligentService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsGetDeviceTreeItem;
import com.zkteco.zkbiosecurity.ivs.vo.api.HwApiVidParentDeviceItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsCrowdSituationalController
extends BaseController
implements IvsCrowdSituationalRemote {
    @Autowired
    private IvsFaceIntelligentService ivsFaceIntelligentService;
    @Autowired
    private IvsCrowdSituationalService ivsCrowdSituationalService;

    @RequiresPermissions(value={"ivs:ext:crowdSituational"})
    public ModelAndView index() {
        this.request.setAttribute("isClient", (Object)this.request.getParameter("isClient"));
        return new ModelAndView("/ivs/crowdSituational/crowdSituational");
    }

    private boolean isQueryToDevice(String id) {
        return StringUtils.isBlank((CharSequence)id) || "0".equals(id);
    }

    public Tree dynaTree(String id, Boolean showPersonCount, HwApiVidParentDeviceItem hwVidParentDeviceItem) {
        List deviceTreeItems = this.ivsFaceIntelligentService.getDeviceTree(id, hwVidParentDeviceItem, this.request.getSession().getId());
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = null;
        if (CollectionUtils.isNotEmpty((Collection)deviceTreeItems)) {
            for (IvsGetDeviceTreeItem deviceTree : deviceTreeItems) {
                item = new TreeItem();
                item.setId(deviceTree.getId());
                item.setText(deviceTree.getName());
                item.setChild("1");
                item.setIm0("ivs_channel_tree.png");
                item.setIm1("ivs_channel_tree.png");
                item.setIm2("ivs_channel_tree.png");
                if (this.isQueryToDevice(id) && Objects.isNull(deviceTree.getParentId())) {
                    item.setOpen(null);
                    item.setChild(null);
                    item.setIm0("vid_device_tree.png");
                    item.setIm1("vid_device_tree.png");
                    item.setIm2("vid_device_tree.png");
                } else {
                    item.setOpen(null);
                }
                pItem = deviceTree.getParentId() != null ? new TreeItem(deviceTree.getParentId()) : new TreeItem("0");
                item.setParent(pItem);
                items.add(item);
            }
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        Tree tree = new Tree(treeItems);
        tree.setId(StringUtils.isBlank((CharSequence)id) ? "0" : id);
        return tree;
    }

    @LogRequest(module="ivs_module", object="ivs_crowd_situational", opType="ivs_log_opType_get", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg getCrossCounting(String channelCode, String parentDeviceId) {
        ZKResultMsg crossCounting = this.ivsCrowdSituationalService.getCrossCounting(channelCode, parentDeviceId);
        return crossCounting;
    }

    public ZKResultMsg clearCrossCounting(String channelCode, String parentDeviceId) {
        ZKResultMsg zkResultMsg = this.ivsCrowdSituationalService.clearCrossCounting(channelCode, parentDeviceId);
        return zkResultMsg;
    }

    public ZKResultMsg getAlarmAudio(String channelCode, String parentDeviceId) {
        ZKResultMsg alarmAudio = this.ivsCrowdSituationalService.getAlarmAudio(channelCode, parentDeviceId);
        return alarmAudio;
    }

    @LogRequest(module="ivs_module", object="ivs_crowd_situational", opType="ivs_log_opType_set", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg setCrossCounting(String crossCountingObject) {
        ZKResultMsg zkResultMsg = this.ivsCrowdSituationalService.setCrossCounting(crossCountingObject);
        return zkResultMsg;
    }

    @LogRequest(module="ivs_module", object="ivs_crowd_situational", opType="ivs_log_opType_get", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg getQueueLength(String channelCode, String parentDeviceId) {
        ZKResultMsg crossCounting = this.ivsCrowdSituationalService.getQueueLength(channelCode, parentDeviceId);
        return crossCounting;
    }

    @LogRequest(module="ivs_module", object="ivs_crowd_situational", opType="ivs_log_opType_set", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg setQueueLength(String queueLengthObject) {
        ZKResultMsg zkResultMsg = this.ivsCrowdSituationalService.setQueueLength(queueLengthObject);
        return zkResultMsg;
    }

    @LogRequest(module="ivs_module", object="ivs_crowd_situational", opType="ivs_log_opType_get", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg getPopulationDensity(String channelCode, String parentDeviceId) {
        ZKResultMsg zkResultMsg = this.ivsCrowdSituationalService.getPopulationDensity(channelCode, parentDeviceId);
        return zkResultMsg;
    }

    @LogRequest(module="ivs_module", object="ivs_crowd_situational", opType="ivs_log_opType_set", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg setPopulationDensity(String populationObject) {
        ZKResultMsg zkResultMsg = this.ivsCrowdSituationalService.setPopulationDensity(populationObject);
        return zkResultMsg;
    }

    @LogRequest(module="ivs_module", object="ivs_crowd_situational", opType="ivs_log_opType_get", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg getHeatMap(String channelCode, String parentDeviceId) {
        ZKResultMsg zkResultMsg = this.ivsCrowdSituationalService.getHeatMap(channelCode, parentDeviceId);
        return zkResultMsg;
    }

    @LogRequest(module="ivs_module", object="ivs_crowd_situational", opType="ivs_log_opType_set", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg setHeatMap(String setHeatMapObject) {
        ZKResultMsg zkResultMsg = this.ivsCrowdSituationalService.setHeatMap(setHeatMapObject);
        return zkResultMsg;
    }

    @LogRequest(module="ivs_module", object="ivs_crowd_situational", opType="ivs_log_opType_get", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg getLeaveDetect(String channelCode, String parentDeviceId) {
        ZKResultMsg zkResultMsg = this.ivsCrowdSituationalService.getLeaveDetect(channelCode, parentDeviceId);
        return zkResultMsg;
    }

    @LogRequest(module="ivs_module", object="ivs_crowd_situational", opType="ivs_log_opType_set", requestParams={"opContent"}, opContent="ivs_log_opContent")
    public ZKResultMsg setLeaveDetect(String setHeatMapObject) {
        ZKResultMsg zkResultMsg = this.ivsCrowdSituationalService.setLeaveDetect(setHeatMapObject);
        return zkResultMsg;
    }
}

