/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsClientRequestLogRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsClientRequestLogService;
import com.zkteco.zkbiosecurity.ivs.utils.ApiIvsCheckUtil;
import com.zkteco.zkbiosecurity.ivs.utils.IVSUtil;
import com.zkteco.zkbiosecurity.ivs.vo.IvsClientRequestLogItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsClientRequestLogController
extends ExportController
implements IvsClientRequestLogRemote {
    @Autowired
    private IvsClientRequestLogService ivsClientRequestLogService;

    @RequiresPermissions(value={"ivs:ClientRequestLog"})
    public ModelAndView index() {
        return new ModelAndView("ivs/icClientRequestLog/ivsClientRequestLog");
    }

    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            IvsClientRequestLogItem item = this.ivsClientRequestLogService.getItemById(id);
            String receive = "";
            if (Objects.nonNull(item)) {
                try {
                    receive = IVSUtil.replaceBlank(item.getReceive());
                }
                catch (Exception e) {
                    receive = item.getReceive();
                }
            }
            this.request.setAttribute("content", (Object)receive);
            this.request.setAttribute("requestParams", (Object)item.getContent());
        }
        return new ModelAndView("ivs/requestLog/viewContent");
    }

    public DxGrid list(IvsClientRequestLogItem condition) {
        Pager pager = this.ivsClientRequestLogService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        DxGrid data = GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
        data.getRows().forEach(item -> {
            JSONObject row = (JSONObject)item;
            if (I18nUtil.i18nCode((String)"common_failed", (Object[])new Object[0]).equals(row.getJSONArray("data").getString(2))) {
                row.put("style", (Object)"color:red");
            }
        });
        return data;
    }

    public ZKResultMsg clearData() {
        this.ivsClientRequestLogService.clearData();
        return ZKResultMsg.successMsg();
    }

    public void export(HttpServletRequest request, HttpServletResponse response) {
        IvsClientRequestLogItem ivsClientRequestLogItem = new IvsClientRequestLogItem();
        this.setConditionValue((BaseItem)ivsClientRequestLogItem);
        List intemList = this.ivsClientRequestLogService.getItemData(ivsClientRequestLogItem, this.getBeginIndex(), this.getEndIndex());
        Map<String, String> map = ApiIvsCheckUtil.getColumnAndI18nByClass(IvsClientRequestLogItem.class);
        map.remove("id");
        HashMap allMap = new HashMap();
        HashMap<String, String> columnNameMap = new HashMap<String, String>();
        columnNameMap.put("jsonColumn", JSONObject.toJSONString(map));
        allMap.put("jsonColumn", columnNameMap);
        this.excelExport(intemList, IvsClientRequestLogItem.class, allMap);
    }
}

