/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ivs.remote.IvsClientParentDeviceRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsApiDealService;
import com.zkteco.zkbiosecurity.ivs.service.IvsChannelService;
import com.zkteco.zkbiosecurity.ivs.service.IvsClientParentDeviceService;
import com.zkteco.zkbiosecurity.ivs.service.IvsEdgeDeviceService;
import com.zkteco.zkbiosecurity.ivs.service.IvsSuspectService;
import com.zkteco.zkbiosecurity.ivs.service.IvsTaskManageService;
import com.zkteco.zkbiosecurity.ivs.vo.EmailConfigItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsCameraSettingParamItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsChangePasswordItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsChannelItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsClientParentDeviceItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsCloudUserItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsEdgeDeviceItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsRepeatVisitorItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsSuspectItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsTaskManageItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsThirdAlgorithmConfigurationItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsVcmInfoItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsVehicleGroupItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsVehiclePlateItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsVehicleRepositoryItem;
import com.zkteco.zkbiosecurity.ivs.vo.RebootCheckItem;
import com.zkteco.zkbiosecurity.ivs.vo.suspecttask.SuspectTaskInfo;
import com.zkteco.zkbiosecurity.ivs.vo.taskmanage.IvsBehaviouralAnalysisInfo;
import com.zkteco.zkbiosecurity.ivs.vo.taskmanage.IvsTaskInfo;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsClientParentDeviceController
extends BaseController
implements IvsClientParentDeviceRemote {
    @Autowired
    private IvsEdgeDeviceService ivsEdgeDeviceService;
    @Autowired
    private IvsClientParentDeviceService ivsClientParentDeviceService;
    @Autowired
    private IvsApiDealService ivsApiDealService;
    @Autowired
    private IvsChannelService ivsChannelService;
    @Autowired
    private IvsSuspectService ivsSuspectService;
    @Autowired
    private IvsTaskManageService ivsTaskManageService;

    @RequiresPermissions(value={"ivs:parentDevice"})
    public ModelAndView index() {
        this.request.setAttribute("isClient", (Object)this.request.getParameter("isClient"));
        return new ModelAndView("ivs/device/ivsClientDevice");
    }

    @RequiresPermissions(value={"ivs:parentDevice:add", "ivs:parentDevice:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            String type;
            IvsEdgeDeviceItem item = this.ivsEdgeDeviceService.getItemById(id);
            switch (type = item.getType()) {
                case "12": 
                case "13": {
                    item.setDeviceType("1");
                    break;
                }
            }
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("ivs/parentdevice/editVidParentDevice");
    }

    @LogChangeRequest(module="ivs_module", object="ivs_ext_device_manager", opType="common_op_edit", fields={"name", "port", "userName", "ip", "type", "status"}, vo=IvsClientParentDeviceItem.class, service=IvsClientParentDeviceService.class)
    @RequiresPermissions(value={"ivs:parentDevice:add", "ivs:parentDevice:edit"})
    public ZKResultMsg save(IvsClientParentDeviceItem item) {
        item.setJsSessionId(this.request.getSession().getId());
        ZKResultMsg res = this.ivsClientParentDeviceService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg firstChange(IvsVcmInfoItem ivsVcmInfoItem, IvsChangePasswordItem ivsChangePasswordItem) {
        ZKResultMsg res = this.ivsClientParentDeviceService.firstChange(ivsVcmInfoItem, ivsChangePasswordItem);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ivs:parentDevice:refresh"})
    public DxGrid list(IvsClientParentDeviceItem condition) {
        Pager pager = this.ivsClientParentDeviceService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="common_op_del", requestParams={"names"}, opContent="common_name")
    @RequiresPermissions(value={"ivs:parentDevice:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        List<String> idList = Arrays.asList(ids.split(","));
        idList.forEach(id -> {
            String type = this.ivsEdgeDeviceService.getParentDeviceType(id);
            if ("4".equals(type)) {
                retMsg.setMsg(I18nUtil.i18nCode((String)"ivs_error_code_674", (Object[])new Object[0]));
            } else {
                this.ivsEdgeDeviceService.deleteByParentDeviceId(id);
            }
        });
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="common_dev_synchronize", requestParams={"names"}, opContent="common_dev_synchronize")
    @RequiresPermissions(value={"ivs:parentDevice:synchronize"})
    public ZKResultMsg syncDev(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        List<String> idList = Arrays.asList(ids.split(","));
        idList.forEach(id -> {
            String type = this.ivsEdgeDeviceService.getParentDeviceType(id);
            if ("4".equals(type)) {
                retMsg.setMsg(I18nUtil.i18nCode((String)"ivs_error_code_674", (Object[])new Object[0]));
            } else {
                this.ivsApiDealService.syncDev(id, "");
            }
        });
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    @RequiresPermissions(value={"ivs:parentDevice:basicConfig"})
    public ModelAndView toCameraSetting(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            IvsChannelItem ivsChannelItem = new IvsChannelItem();
            ivsChannelItem.setDevId(id);
            List ivsChannelItems = this.ivsChannelService.getByCondition(ivsChannelItem);
            if (Objects.nonNull(ivsChannelItems) && ivsChannelItems.size() > 0) {
                this.request.setAttribute("item", ivsChannelItems.get(0));
            }
        }
        return new ModelAndView("ivs/device/vidClientChannelSetting");
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_ext_channel_manager", requestParams={"domainCode", "userName", "cameraCode"}, opContent="base_login_passReset")
    public ZKResultMsg updateCameraPassword(IvsCameraSettingParamItem item) {
        String parentDeviceId = item.getParentDeviceId();
        String cameraCode = item.getCameraCode();
        if (StringUtils.isNotBlank((CharSequence)parentDeviceId) && StringUtils.isNotBlank((CharSequence)cameraCode)) {
            return this.ivsClientParentDeviceService.updateCameraPassword(item);
        }
        ZKResultMsg resultMsg = ZKResultMsg.failMsg();
        resultMsg.setMsg(I18nUtil.i18nCode((String)"ivs_iClient_paramError", (Object[])new Object[0]));
        return resultMsg;
    }

    public ZKResultMsg getCameraSettingParam(IvsCameraSettingParamItem item) {
        String parentDeviceId = item.getParentDeviceId();
        String channelCode = item.getChannelCode();
        String cameraCode = item.getCameraCode();
        String type = item.getType();
        if (StringUtils.isNotBlank((CharSequence)parentDeviceId) && StringUtils.isNotBlank((CharSequence)channelCode) && StringUtils.isNotBlank((CharSequence)cameraCode) && StringUtils.isNotBlank((CharSequence)type)) {
            ZKResultMsg resultMsg = ZKResultMsg.successMsg();
            IvsCameraSettingParamItem ivsCameraSettingParamItem = this.ivsClientParentDeviceService.getCameraSettingParam(item);
            resultMsg.setData((Object)ivsCameraSettingParamItem);
            return resultMsg;
        }
        ZKResultMsg resultMsg = ZKResultMsg.failMsg();
        resultMsg.setMsg(I18nUtil.i18nCode((String)"ivs_iClient_paramError", (Object[])new Object[0]));
        return resultMsg;
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_ext_channel_manager", requestParams={"domainCode", "channelCode", "cameraCode"}, opContent="ivs_basicConfig")
    public ZKResultMsg saveCameraSettingParam(IvsCameraSettingParamItem item) {
        String parentDeviceId = item.getParentDeviceId();
        String channelCode = item.getChannelCode();
        String cameraCode = item.getCameraCode();
        String type = item.getType();
        if (StringUtils.isNotBlank((CharSequence)parentDeviceId) && StringUtils.isNotBlank((CharSequence)channelCode) && StringUtils.isNotBlank((CharSequence)cameraCode) && StringUtils.isNotBlank((CharSequence)type)) {
            return this.ivsClientParentDeviceService.saveCameraSettingParam(item);
        }
        ZKResultMsg resultMsg = ZKResultMsg.failMsg();
        resultMsg.setMsg(I18nUtil.i18nCode((String)"ivs_iClient_paramError", (Object[])new Object[0]));
        return resultMsg;
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_viewInformation", requestParams={"parentDeviceName"}, opContent="common_dev_name")
    @RequiresPermissions(value={"ivs:parentDevice:view"})
    public ModelAndView view(String id) {
        ZKResultMsg zkResultMsg = this.ivsEdgeDeviceService.getParentDeviceVersion(id);
        if (zkResultMsg.isSuccess()) {
            this.request.setAttribute("item", zkResultMsg.getData());
        }
        return new ModelAndView("ivs/parentdevice/viewVidParentDevice");
    }

    @RequiresPermissions(value={"ivs:parentDevice:frequency"})
    public ModelAndView getRepeatVisitor(String id) {
        this.request.setAttribute("parentDeviceId", (Object)id);
        this.ivsEdgeDeviceService.getLocalParentDevList().stream().forEach(ivsEdgeDeviceItem -> {
            if (ivsEdgeDeviceItem.getId().equals(id)) {
                this.request.setAttribute("devName", (Object)ivsEdgeDeviceItem.getName());
            }
        });
        ZKResultMsg zkResultMsg = this.ivsEdgeDeviceService.getRepeatVisitor(id);
        if (zkResultMsg.isSuccess()) {
            this.request.setAttribute("item", zkResultMsg.getData());
        }
        return new ModelAndView("ivs/parentdevice/repeatVisitor");
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_persFrequencyAnalysis", requestParams={"parentDeviceName"}, opContent="common_dev_name")
    public ZKResultMsg saveRepeatVisitor(IvsRepeatVisitorItem condition) {
        return this.ivsEdgeDeviceService.saveRepeatVisitor(condition);
    }

    @RequiresPermissions(value={"ivs:parentDevice:suspect"})
    public ModelAndView suspect(String id, String suspectType) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            IvsEdgeDeviceItem ivsEdgeDeviceItem = this.ivsEdgeDeviceService.getItemById(id);
            this.request.setAttribute("id", (Object)ivsEdgeDeviceItem.getId());
            this.request.setAttribute("type", (Object)ivsEdgeDeviceItem.getType());
            this.request.setAttribute("suspectType", (Object)suspectType);
        }
        return new ModelAndView("ivs/parentdevice/suspect/suspect");
    }

    public DxGrid suspectList(IvsSuspectItem condition) {
        Pager pager = this.ivsSuspectService.getSuspectPagerList(condition, this.getPageNo(), this.getPageSize());
        DxGrid data = GridUtil.convert((Pager)pager, condition.getClass());
        data.getRows().forEach(item -> {
            JSONObject row = (JSONObject)item;
            Integer alarmLevel = row.getJSONArray("data").getInteger(6);
            if (alarmLevel.equals(1)) {
                row.getJSONArray("data").set(6, (Object)("<font color='red'>" + I18nUtil.i18nCode((String)"ivs_urgent", (Object[])new Object[0]) + "</font>"));
            } else if (alarmLevel.equals(2)) {
                row.getJSONArray("data").set(6, (Object)("<font color='orange'>" + I18nUtil.i18nCode((String)"ivs_important", (Object[])new Object[0]) + "</font>"));
            } else if (alarmLevel.equals(3)) {
                row.getJSONArray("data").set(6, (Object)("<font color='Gold'>" + I18nUtil.i18nCode((String)"ivs_general", (Object[])new Object[0]) + "</font>"));
            } else if (alarmLevel.equals(4)) {
                row.getJSONArray("data").set(6, (Object)("<font color='green'>" + I18nUtil.i18nCode((String)"ivs_prompt", (Object[])new Object[0]) + "</font>"));
            }
        });
        return data;
    }

    public ModelAndView toAddSuspectView(IvsSuspectItem condition) {
        this.request.setAttribute("isEdit", (Object)false);
        this.addRequestParams(condition);
        return new ModelAndView("ivs/parentdevice/suspect/editSuspectView");
    }

    public ModelAndView toEditSuspectView(IvsSuspectItem condition) {
        SuspectTaskInfo suspectTaskInfo = this.ivsSuspectService.getSuspect(condition);
        this.request.setAttribute("item", (Object)suspectTaskInfo);
        this.request.setAttribute("isEdit", (Object)true);
        this.addRequestParams(condition);
        return new ModelAndView("ivs/parentdevice/suspect/editSuspectView");
    }

    private void addRequestParams(IvsSuspectItem condition) {
        this.request.setAttribute("suspectType", (Object)condition.getSuspectType());
        this.request.setAttribute("parentDeviceType", (Object)condition.getParentDeviceType());
        this.request.setAttribute("parentDeviceId", (Object)condition.getParentDeviceId());
    }

    @LogChangeRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_iClient_face_control", vo=SuspectTaskInfo.class, service=IvsSuspectService.class)
    public ZKResultMsg addSuspect(SuspectTaskInfo item) {
        return this.ivsSuspectService.addSuspect(item);
    }

    @LogChangeRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_iClient_face_control", vo=SuspectTaskInfo.class, service=IvsSuspectService.class)
    public ZKResultMsg editSuspect(SuspectTaskInfo item) {
        return this.ivsSuspectService.editSuspect(item);
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_iClient_face_control", requestParams={"taskName"}, opContent="common_op_del")
    public ZKResultMsg delSuspect(IvsSuspectItem item) {
        return this.ivsSuspectService.delSuspect(item);
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_iClient_face_control", requestParams={"name"}, opContent="common_enable")
    public ZKResultMsg enableSuspect(IvsSuspectItem item) {
        return this.ivsSuspectService.enableSuspect(item, true);
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_iClient_face_control", requestParams={"name"}, opContent="common_disable")
    public ZKResultMsg disableSuspect(IvsSuspectItem item) {
        return this.ivsSuspectService.enableSuspect(item, false);
    }

    @RequiresPermissions(value={"ivs:parentDevice:taskManage"})
    public ModelAndView taskManage(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            IvsEdgeDeviceItem ivsEdgeDeviceItem = this.ivsEdgeDeviceService.getItemById(id);
            this.request.setAttribute("id", (Object)ivsEdgeDeviceItem.getId());
            this.request.setAttribute("parentDeviceId", (Object)id);
            this.request.setAttribute("domainCode", (Object)ivsEdgeDeviceItem.getDomainCode());
            IvsVcmInfoItem ivsVcmInfoItem = this.ivsEdgeDeviceService.buildVcmInfoByParentId(ivsEdgeDeviceItem.getId());
            JSONArray algorithmByType = this.ivsEdgeDeviceService.getAlgorithmByType(ivsVcmInfoItem, "4");
            String targetRecognition = "";
            if (algorithmByType.size() > 0 && StringUtils.isNotBlank((CharSequence)algorithmByType.get(0).toString())) {
                targetRecognition = JSONObject.parseObject((String)algorithmByType.get(0).toString()).getString("name");
            }
            String videoStructuring = "";
            algorithmByType = this.ivsEdgeDeviceService.getAlgorithmByType(ivsVcmInfoItem, "9");
            if (algorithmByType.size() > 0 && StringUtils.isNotBlank((CharSequence)algorithmByType.get(0).toString())) {
                videoStructuring = JSONObject.parseObject((String)algorithmByType.get(0).toString()).getString("name");
            }
            if (StringUtils.isNotBlank((CharSequence)targetRecognition)) {
                this.request.setAttribute("targetRecognition", (Object)targetRecognition);
            }
            if (StringUtils.isNotBlank((CharSequence)videoStructuring)) {
                this.request.setAttribute("videoStructuring", (Object)videoStructuring);
            }
        }
        return new ModelAndView("ivs/parentdevice/taskManage");
    }

    public DxGrid taskManageList(IvsTaskManageItem condition) {
        Pager pager = this.ivsTaskManageService.getTaskManagePagerList(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_iClient_task_manage", requestParams={"name"}, opContent="common_enable")
    public ZKResultMsg enableTask(IvsTaskManageItem item) {
        return this.ivsTaskManageService.enableTask(item, true);
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_iClient_task_manage", requestParams={"name"}, opContent="common_disable")
    public ZKResultMsg disableTask(IvsTaskManageItem item) {
        return this.ivsTaskManageService.enableTask(item, false);
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_iClient_task_manage", requestParams={"taskNames"}, opContent="common_op_del")
    public ZKResultMsg batchDel(String ids, String parentDeviceId) {
        int count = 0;
        if (StringUtils.isNotEmpty((CharSequence)ids)) {
            String[] idArray = StringUtils.split((String)ids, (String)",");
            if (idArray.length == 1) {
                return this.ivsTaskManageService.batchDel(parentDeviceId, idArray[0]);
            }
            for (String taskId : idArray) {
                ZKResultMsg zkResultMsg = this.ivsTaskManageService.batchDel(parentDeviceId, taskId);
                if (!zkResultMsg.isSuccess()) continue;
                ++count;
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg("ok", String.format(I18nUtil.i18nCode((String)"ivs_delete_success_tip", (Object[])new Object[0]), count)));
    }

    public ModelAndView toVideoScribing(String data) {
        if (StringUtils.isNotBlank((CharSequence)data)) {
            JSONObject dataObject = JSONObject.parseObject((String)data);
            this.request.setAttribute("intelligentType", (Object)dataObject.getString("intelligentType"));
            this.request.setAttribute("data", (Object)data);
        }
        return new ModelAndView("ivs/parentdevice/taskVideoDrawLine");
    }

    public ZKResultMsg addTaskBehaviorAnalysis(IvsBehaviouralAnalysisInfo ivsBehaviouralAnalysisInfo) {
        return this.ivsTaskManageService.addTaskBehaviorAnalysis(ivsBehaviouralAnalysisInfo);
    }

    public ZKResultMsg editTaskBehaviorAnalysis(IvsBehaviouralAnalysisInfo ivsBehaviouralAnalysisInfo) {
        return this.ivsTaskManageService.editTaskBehaviorAnalysis(ivsBehaviouralAnalysisInfo);
    }

    @LogChangeRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_iClient_task_manage", vo=IvsTaskInfo.class, service=IvsClientParentDeviceService.class)
    public ZKResultMsg saveTaskManage(IvsTaskInfo ivsTaskInfo) {
        return this.ivsTaskManageService.addTask(ivsTaskInfo);
    }

    public ModelAndView editTaskManage(String id, String parentDeviceId) {
        this.request.setAttribute("id", (Object)id);
        this.request.setAttribute("parentDeviceId", (Object)parentDeviceId);
        IvsTaskManageItem ivsTaskManageItem = new IvsTaskManageItem();
        ivsTaskManageItem.setParentDeviceId(parentDeviceId);
        ivsTaskManageItem.setId(id);
        IvsTaskManageItem taskManageItem = this.ivsTaskManageService.getTaskManage(ivsTaskManageItem);
        return new ModelAndView("ivs/parentdevice/taskVideoDrawLine");
    }

    public ModelAndView toDetailView(IvsTaskManageItem condition) {
        if (StringUtils.isNotBlank((CharSequence)condition.getRunExtraData())) {
            ArrayList<String> arr = new ArrayList<String>();
            JSONObject RunExtraJsonData = JSONObject.parseObject((String)condition.getRunExtraData());
            JSONObject issAlgConfig = RunExtraJsonData.getJSONObject("root").getJSONObject("iss_alg_config");
            for (String s : issAlgConfig.keySet()) {
                if (issAlgConfig.getJSONObject(s).getIntValue("enable") != 1) continue;
                arr.add(this.convertRuleType(s));
            }
            condition.setAnalysisRules(StringUtils.join(arr, (String)"\u3001"));
        }
        IvsTaskManageItem ivsTaskManageItem = this.ivsTaskManageService.getTaskManage(condition);
        this.request.setAttribute("item", (Object)ivsTaskManageItem);
        return new ModelAndView("ivs/parentdevice/taskManageDetailView");
    }

    private String convertRuleType(String ruleType) {
        switch (ruleType) {
            case "BEH_INVASION_RULE": {
                return I18nUtil.i18nCode((String)"ivs_intrusion_rule", (Object[])new Object[0]);
            }
            case "BEH_TRIPWIRE_RULE": {
                return I18nUtil.i18nCode((String)"ivs_crossLine_rule", (Object[])new Object[0]);
            }
            case "BEH_ENTER_RULE": {
                return I18nUtil.i18nCode((String)"ivs_zone_entry", (Object[])new Object[0]);
            }
            case "BEH_EXIT_RULE": {
                return I18nUtil.i18nCode((String)"ivs_alarmExit", (Object[])new Object[0]);
            }
            case "BEH_FASTMOVE_RULE": {
                return I18nUtil.i18nCode((String)"ivs_fast_move", (Object[])new Object[0]);
            }
            case "BEH_WANDER_RULE": {
                return I18nUtil.i18nCode((String)"ivs_wandering_rule", (Object[])new Object[0]);
            }
        }
        return "";
    }

    public TreeItem getFaceGroupSelectList(String parentDeviceId, String type) {
        return this.ivsSuspectService.getFaceGroupSelectList(parentDeviceId, type);
    }

    public TreeItem getVehicleGroupSelectList(String parentDeviceId, String type) {
        return this.ivsSuspectService.getVehicleGroupSelectList(parentDeviceId, type);
    }

    public TreeItem getCameraSelectList(String parentDeviceId) {
        return this.ivsSuspectService.getCameraSelectList(this.request.getSession().getId(), parentDeviceId);
    }

    public TreeItem tree(String parentDeviceId, String type) {
        return this.ivsEdgeDeviceService.getTree(parentDeviceId, type);
    }

    public ZKResultMsg getTokenInfo() {
        SecuritySubject securitySubject = this.getCurrentSubject();
        return this.ivsClientParentDeviceService.getTokenInfo(securitySubject);
    }

    @RequiresPermissions(value={"ivs:parentDevice:alarmManagement"})
    public ModelAndView alarmManagement(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            IvsEdgeDeviceItem item = this.ivsEdgeDeviceService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("ivs/parentdevice/alarm/alarmManage");
    }

    @RequiresPermissions(value={"ivs:parentDevice:vehicleList"})
    public ModelAndView vehicleList(String id) {
        this.request.setAttribute("parentDeviceId", (Object)id);
        return new ModelAndView("ivs/parentdevice/vehicleList");
    }

    public DxGrid vehicleRepository(String parentDeviceId) {
        Pager repositories = this.ivsEdgeDeviceService.getVehicleRepositories(parentDeviceId);
        return GridUtil.convert((Pager)repositories, IvsVehicleGroupItem.class);
    }

    public ZKResultMsg getVidExtDeviceSelectData(String parentDeviceId) {
        return new ZKResultMsg((Object)this.ivsEdgeDeviceService.getVehicleRepositoriesSelectData(parentDeviceId));
    }

    public DxGrid vehicleInfo(String parentDeviceId, IvsVehiclePlateItem condition) {
        this.request.setAttribute("repositoryId", (Object)condition.getRepositoryId());
        Pager repositories = this.ivsEdgeDeviceService.getVehicleInfoList(parentDeviceId, condition, this.getPageNo(), this.getPageSize());
        if (Objects.isNull(repositories.getData())) {
            return new DxGrid();
        }
        return GridUtil.convert((Pager)repositories, IvsVehicleRepositoryItem.class);
    }

    public ModelAndView viewVehicleInfo(String id) {
        if (StringUtils.isNotBlank((CharSequence)id) && id.split("_").length == 3) {
            String[] ids = id.split("_");
            IvsVehicleRepositoryItem vehicleRepository = this.ivsEdgeDeviceService.getSimpleVehicleInfo(ids[0], ids[1], ids[2], true);
            vehicleRepository.setLpn(this.ivsEdgeDeviceService.convertToEncrypt(vehicleRepository.getLpn(), "pers.carPlate.encryptProp", "pers.carPlate.encryptMode"));
            this.request.setAttribute("item", (Object)vehicleRepository);
        }
        this.request.setAttribute("id", (Object)id);
        return new ModelAndView("ivs/parentdevice/viewVehicleInfo");
    }

    public ModelAndView editVehicleList(String id) {
        this.request.setAttribute("id", (Object)id);
        String[] ids = id.split("_");
        Pager repositories = this.ivsEdgeDeviceService.getVehicleRepositories(ids[0]);
        List hwVidVehicleGroupItems = repositories.getData();
        if (ids.length == 2 && StringUtils.isNotBlank((CharSequence)ids[1])) {
            hwVidVehicleGroupItems.forEach(item -> {
                if (item.getGroupid().equals(ids[1])) {
                    this.request.setAttribute("item", item);
                }
            });
        }
        return new ModelAndView("ivs/parentdevice/editVehicleList");
    }

    public ModelAndView editVehicleInfo(String id) {
        this.request.setAttribute("id", (Object)id);
        if (StringUtils.isNotBlank((CharSequence)id) && id.split("_").length == 3) {
            String[] ids = id.split("_");
            IvsVehicleRepositoryItem vehicleRepository = this.ivsEdgeDeviceService.getSimpleVehicleInfo(ids[0], ids[1], ids[2], false);
            this.request.setAttribute("item", (Object)vehicleRepository);
        }
        return new ModelAndView("ivs/parentdevice/editVehicleInfo");
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_iClient_vehicle_list_database", requestParams={"name"}, opContent="common_op_edit")
    public ZKResultMsg saveVehicleList(IvsVehicleGroupItem condition) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        zkResultMsg = condition.getId().split("_").length != 2 ? this.ivsEdgeDeviceService.addVehicleList(condition) : this.ivsEdgeDeviceService.updateVehicleList(condition);
        return zkResultMsg;
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_iClient_vehicle_list_database", requestParams={"lpn"}, opContent="common_op_edit")
    public ZKResultMsg saveVehicleInfo(IvsVehicleRepositoryItem condition, MultipartFile vehiclePhoto) {
        if (Objects.nonNull(vehiclePhoto) && !vehiclePhoto.isEmpty()) {
            try {
                condition.setPictures(vehiclePhoto.getBytes());
            }
            catch (IOException e) {
                this.log.error("ivs save vehicle info error : " + e.getMessage());
            }
        } else {
            condition.setPictures(null);
        }
        ZKResultMsg zkResultMsg = condition.getId().split("_").length == 2 ? this.ivsEdgeDeviceService.addVehicleInfo(condition) : (condition.getId().split("_").length == 3 ? this.ivsEdgeDeviceService.updateVehicleInfo(condition) : ZKResultMsg.failMsg());
        return zkResultMsg;
    }

    public ZKResultMsg saveVehicleInfoByBase64Img(IvsVehicleRepositoryItem condition, String vehicleBase64Photo) {
        String[] split = vehicleBase64Photo.split(",");
        if (StringUtils.isNotBlank((CharSequence)vehicleBase64Photo)) {
            condition.setPictures(Base64.getDecoder().decode(split[1]));
        } else {
            condition.setPictures(null);
        }
        ZKResultMsg zkResultMsg = condition.getId().split("_").length == 2 ? this.ivsEdgeDeviceService.addVehicleInfo(condition) : (condition.getId().split("_").length == 3 ? this.ivsEdgeDeviceService.updateVehicleInfo(condition) : ZKResultMsg.failMsg());
        return zkResultMsg;
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_iClient_vehicle_list_database", requestParams={"name"}, opContent="common_op_del")
    public ZKResultMsg delVehicleList(String id, Boolean status) {
        if (status.booleanValue()) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"ivs_control_enable", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        String[] ids = id.split("_");
        if (ids.length == 2) {
            return this.ivsEdgeDeviceService.delVehicleList(ids[0], ids[1]);
        }
        return ZKResultMsg.failMsg();
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_iClient_vehicle_list_database", requestParams={"lpn"}, opContent="common_op_del")
    public ZKResultMsg delVehicleInfo(String ids) {
        String[] simpleIds;
        for (String simpleId : simpleIds = ids.split(",")) {
            String[] simIds = simpleId.split("_");
            if (simIds.length != 3) {
                return ZKResultMsg.failMsg();
            }
            this.ivsEdgeDeviceService.delVehicleInfo(simIds[0], simIds[2]);
        }
        return new ZKResultMsg();
    }

    @RequiresPermissions(value={"ivs:parentDevice:storageManage"})
    public ModelAndView storageManage(String parentDeviceId) {
        this.request.setAttribute("parentDeviceId", (Object)parentDeviceId);
        return new ModelAndView("ivs/parentdevice/ivsStorageManage");
    }

    @RequiresPermissions(value={"ivs:parentDevice:algorithm"})
    public ModelAndView thirdAlgorithmConfiguration(String parentDeviceId) {
        this.request.setAttribute("parentDeviceId", (Object)parentDeviceId);
        return new ModelAndView("ivs/parentdevice/ivsThirdAlgorithmConfiguration");
    }

    public DxGrid getThirdAlgorithmList(String parentDeviceId) {
        Pager pager = this.ivsEdgeDeviceService.getThirdAlgorithm(parentDeviceId, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, IvsThirdAlgorithmConfigurationItem.class);
    }

    public ModelAndView editThirdAlgorithmConfiguration(String id, String appName, String groupName) {
        IvsThirdAlgorithmConfigurationItem item = this.ivsEdgeDeviceService.getThirdAlgorithmConfiguration(id, appName, groupName);
        this.request.setAttribute("IvsThirdAlgorithmConfigurationItem", (Object)item);
        this.request.setAttribute("appParamInfoStr", (Object)JSON.toJSONString((Object)item));
        return new ModelAndView("ivs/parentdevice/ivsEditThirdAlgorithmConfiguration");
    }

    public ZKResultMsg setThirdAlgorithmConfiguration(String appParamInfoStr) {
        return this.ivsEdgeDeviceService.setThirdAlgorithmConfiguration(appParamInfoStr);
    }

    public ZKResultMsg getVehicleData(String id, String vehicleBrandId) {
        return this.ivsEdgeDeviceService.getVehicleData(id, vehicleBrandId);
    }

    public ZKResultMsg getDeviceAbility(String parentDeviceId, String channelCode) {
        return this.ivsEdgeDeviceService.getDeviceAbility(parentDeviceId, channelCode);
    }

    public ZKResultMsg cloudServerLogin(IvsCloudUserItem item) {
        return this.ivsClientParentDeviceService.cloudServerLogin(item);
    }

    public ZKResultMsg cloudServerLogout() {
        return this.ivsClientParentDeviceService.cloudServerLogout();
    }

    public ZKResultMsg cloudServerSync() {
        return this.ivsClientParentDeviceService.cloudServerSync();
    }

    public ZKResultMsg getCloudRoleTree() {
        return this.ivsClientParentDeviceService.getCloudRoleTree();
    }

    public ZKResultMsg cloudServerRole(String cloudRoleId) {
        return this.ivsEdgeDeviceService.cloudServerRole(cloudRoleId);
    }

    public ZKResultMsg isSupportTargetAnalysis(String id) {
        return this.ivsEdgeDeviceService.getParentDeviceVersion(id);
    }

    public ModelAndView getTargetAnalysis(String id) {
        ZKResultMsg targetAnalysis = this.ivsEdgeDeviceService.getTargetAnalysis(id);
        this.ivsEdgeDeviceService.getLocalParentDevList().stream().forEach(ivsEdgeDeviceItem -> {
            if (ivsEdgeDeviceItem.getId().equals(id)) {
                this.request.setAttribute("devName", (Object)ivsEdgeDeviceItem.getName());
            }
        });
        this.request.setAttribute("enableTargetAnalysis", targetAnalysis.getData());
        this.request.setAttribute("id", (Object)id);
        return new ModelAndView("ivs/parentdevice/ivsTargetAnalysis");
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_target_analysis", requestParams={"parentDeviceName"}, opContent="ivs_target_analysis")
    public ZKResultMsg setTargetAnalysis(String id, Boolean enableTargetAnalysis) {
        return this.ivsEdgeDeviceService.setTargetAnalysis(id, enableTargetAnalysis);
    }

    public ModelAndView emailConfigView(String id) {
        EmailConfigItem item = this.ivsEdgeDeviceService.getEmailConfig(id);
        if (Objects.nonNull(item)) {
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("ivs/parentdevice/emailConfig");
    }

    public ZKResultMsg setEmailConfig(EmailConfigItem item) {
        return this.ivsEdgeDeviceService.setEmailConfig(item);
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_ext_device_reboot", requestParams={"ids"}, opContent="ivs_ext_device_reboot")
    public ModelAndView rebootCheck(String ids) {
        this.request.setAttribute("ids", (Object)ids);
        return new ModelAndView("ivs/parentdevice/rebootVidParentDevice");
    }

    @LogRequest(module="ivs_module", object="ivs_ext_device_manager", opType="ivs_ext_device_reboot", requestParams={"ids", "passWord"}, opContent="ivs_ext_device_reboot")
    public ZKResultMsg reboot(RebootCheckItem rebootCheckItem) {
        return this.ivsEdgeDeviceService.reboot(rebootCheckItem.getIds(), rebootCheckItem.getPassWord());
    }
}

