/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ivs.remote.IvsChannelGroupRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsGroupService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsGroupItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsChannelGroupController
extends BaseController
implements IvsChannelGroupRemote {
    @Autowired
    private IvsGroupService ivsGroupService;

    @RequiresPermissions(value={"ivs:channelGroup"})
    public ModelAndView index() {
        return new ModelAndView("ivs/group/ivsGroup");
    }

    @RequiresPermissions(value={"ivs:channelGroup:edit"})
    public ModelAndView edit(String id) {
        IvsGroupItem ivsGroupItem = null;
        ivsGroupItem = StringUtils.isNotBlank((CharSequence)id) ? this.ivsGroupService.getItemById(id) : new IvsGroupItem();
        this.request.setAttribute("item", (Object)ivsGroupItem);
        return new ModelAndView("ivs/group/editIvsGroup");
    }

    @LogRequest(module="ivs_module", object="ivs_group_management", opType="common_adf_save", requestParams={"name"}, opContent="common_name")
    @RequiresPermissions(value={"ivs:channelGroup:edit"})
    public ZKResultMsg save(IvsGroupItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.ivsGroupService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ivs:channelGroup:refresh"})
    public DxGrid list(IvsGroupItem condition) {
        Pager pager = this.ivsGroupService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public TreeItem tree() {
        List groupItems = this.ivsGroupService.getByCondition(new IvsGroupItem());
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = null;
        for (IvsGroupItem depart : groupItems) {
            item = new TreeItem();
            item.setId(depart.getId());
            item.setText(depart.getName());
            pItem = depart.getParentId() != null ? new TreeItem(depart.getParentId()) : new TreeItem("0");
            item.setParent(pItem);
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    @LogRequest(module="ivs_module", object="ivs_group_management", opType="ivs_iClient_del_Group", requestParams={"name"}, opContent="common_name")
    @RequiresPermissions(value={"ivs:channelGroup:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.ivsGroupService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    @LogRequest(module="ivs_module", object="ivs_group_management", opType="ivs_iClient_add_camera", requestParams={"channelNames"}, opContent="common_name")
    @RequiresPermissions(value={"ivs:channelGroup:edit"})
    public ZKResultMsg addChannel(String groupId, String channelIds) {
        ZKResultMsg zkResultMsg = this.ivsGroupService.addChannel(groupId, channelIds);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @LogRequest(module="ivs_module", object="ivs_group_management", opType="ivs_del_device", requestParams={"channelNames"}, opContent="common_name")
    @RequiresPermissions(value={"ivs:channelGroup:delChannel"})
    public ZKResultMsg delChannel(String groupId, String channelIds) {
        return this.ivsGroupService.delChannel(groupId, channelIds);
    }

    public boolean valid(String name) {
        return !this.ivsGroupService.isExistGroupName(name);
    }
}

