/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ivs.remote.IvsChannelRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsChannelService;
import com.zkteco.zkbiosecurity.ivs.service.IvsDeviceService;
import com.zkteco.zkbiosecurity.ivs.service.IvsGroupService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsChannelItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsChannelSelectItem;
import com.zkteco.zkbiosecurity.ivs.vo.api.HwApiRtspItem;
import com.zkteco.zkbiosecurity.ivs.vo.patrol.IvsPatrolChannelSelectItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsChannelController
extends BaseController
implements IvsChannelRemote {
    @Autowired
    private IvsChannelService ivsChannelService;
    @Autowired
    private IvsGroupService ivsGroupService;
    @Autowired
    private IvsDeviceService ivsDeviceService;

    @RequiresPermissions(value={"ivs:channelGroup"})
    public ModelAndView index() {
        return new ModelAndView("ivs/group/ivsGroup");
    }

    public ZKResultMsg addSub(String ids) {
        this.ivsChannelService.subscription(ids, Boolean.valueOf(true));
        return ZKResultMsg.successMsg();
    }

    public ZKResultMsg cancelSub(String ids) {
        this.ivsChannelService.subscription(ids, Boolean.valueOf(false));
        return ZKResultMsg.successMsg();
    }

    @RequiresPermissions(value={"ivs:channel:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.ivsChannelService.getItemById(id));
        }
        return new ModelAndView("ivs/channel/editVidExtChannel");
    }

    @RequiresPermissions(value={"ivs:channel:edit"})
    public ZKResultMsg save(IvsChannelItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.ivsChannelService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ivs:channel:refresh"})
    public DxGrid list(IvsChannelItem condition) {
        if (Objects.nonNull(condition) && StringUtils.isNotBlank((CharSequence)condition.getGroupIds())) {
            List channelIdList = this.ivsGroupService.getChannelIdById(condition.getGroupIds());
            String devIdsFilter = this.ivsDeviceService.getDevIdsFilter(this.request.getSession().getId());
            if (!channelIdList.isEmpty()) {
                String channelIds = String.join((CharSequence)",", channelIdList);
                condition.setInId(channelIds);
                condition.setDevIdIn(devIdsFilter);
            } else {
                condition.setInId("-1");
                condition.setDevIdIn("-1");
            }
        }
        Pager pager = this.ivsChannelService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        this.ivsChannelService.buildVidChannel(pager.getData());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectChannelList(IvsChannelSelectItem condition) {
        Pager pager = new Pager();
        if ("noSelected".equals(condition.getType())) {
            pager = this.ivsChannelService.getNoExistChannel(condition, this.getPageNo(), this.getPageSize());
        } else if ("selected".equals(condition.getType())) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectChannelListByFilter(IvsChannelSelectItem condition) {
        Pager pager = new Pager();
        if ("noSelected".equals(condition.getType())) {
            pager = this.ivsChannelService.getNoExistChannelByFilter(condition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        } else if ("selected".equals(condition.getType())) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ivs:channel:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.ivsChannelService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public ModelAndView testChannel(String ids) {
        String rtsp = null;
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            ZKResultMsg zkResultMsg;
            List hwApiRtspItems;
            IvsChannelItem channelItem = this.ivsChannelService.getItemById(ids);
            if (channelItem != null && (hwApiRtspItems = (List)(zkResultMsg = this.ivsDeviceService.getRTSPStream(channelItem)).getData()).size() > 0) {
                rtsp = ((HwApiRtspItem)hwApiRtspItems.get(0)).getRtspUrl();
            }
            this.request.setAttribute("rtspUrl", rtsp);
        }
        return new ModelAndView("ivs/channel/testChannel");
    }

    public ModelAndView viewCapture(String ids) {
        IvsChannelItem channelItem;
        String path = "";
        if (StringUtils.isNotBlank((CharSequence)ids) && Objects.nonNull(channelItem = this.ivsChannelService.getItemById(ids))) {
            path = this.ivsChannelService.manualSnapshot(channelItem);
            this.request.setAttribute("photoPath", (Object)path);
        }
        return new ModelAndView("ivs/channel/vidShowUserPhoto");
    }

    public ZKResultMsg getChannelData(String id) {
        IvsChannelItem channelItem = new IvsChannelItem();
        if (StringUtils.isNotBlank((CharSequence)id) && Objects.isNull(channelItem = this.ivsChannelService.getItemById(id))) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"ivs_ext_device_notExist", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        return new ZKResultMsg("ok", "common_op_succeed", (Object)channelItem);
    }

    public TreeItem tree(String vidExtDeviceId) {
        return this.ivsChannelService.getChannelTree(this.request.getSession().getId(), vidExtDeviceId);
    }

    public DxGrid ivsPatrolSelectList(IvsPatrolChannelSelectItem condition) {
        String selectId = condition.getSelectId();
        if (StringUtils.isBlank((CharSequence)selectId)) {
            selectId = "-1";
            condition.setSelectId(selectId);
        }
        String sessionId = this.request.getSession().getId();
        if ("noSelected".equals(condition.getType())) {
            condition.setSelectIdsNotIn(selectId);
        } else if ("selected".equals(condition.getType())) {
            HashSet<String> selectIdSet = new HashSet<String>(Arrays.asList(selectId.split(",")));
            if (selectIdSet.size() == 0) {
                selectIdSet.add("-1");
            }
            condition.setSelectIdsIn(StringUtils.join(selectIdSet, (String)","));
        }
        Pager pager = this.ivsChannelService.getPatrolChannelsByPage(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        if (Objects.isNull(pager.getData())) {
            pager.setData((List)Lists.newArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg getChannelName(String parentDeviceId, String channelCode) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        zkResultMsg.setData((Object)this.ivsChannelService.getNameByCodeAndParentDevId(channelCode, parentDeviceId));
        return zkResultMsg;
    }

    public ZKResultMsg getOnlineChannelIds(IvsChannelItem condition) {
        List onlineChannelIds = this.ivsChannelService.getOnlineChannelIds(condition);
        return new ZKResultMsg((Object)StringUtils.join((Iterable)onlineChannelIds, (String)","));
    }
}

