/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsCcStatisticsRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsCcStatisticsService;
import com.zkteco.zkbiosecurity.ivs.utils.ApiIvsCheckUtil;
import com.zkteco.zkbiosecurity.ivs.vo.IvsCcStatisticsRepItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsCcStatisticsReqItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsCcStatisticsController
extends ExportController
implements IvsCcStatisticsRemote {
    @Autowired
    private IvsCcStatisticsService ivsCcStatisticsService;

    @RequiresPermissions(value={"ivs:ext:ccStatistics"})
    public ModelAndView index() {
        return new ModelAndView("ivs/statistic/ivsCcStatistics");
    }

    public DxGrid list(String gridName) {
        Pager pager = this.ivsCcStatisticsService.getHwCcStatisticsRepItemList(gridName);
        return GridUtil.convert((Pager)pager, IvsCcStatisticsRepItem.class);
    }

    public ZKResultMsg getCcStatisticsPieOpt(IvsCcStatisticsReqItem condition) {
        return this.ivsCcStatisticsService.getCcStatisticsPieOpt(condition);
    }

    public ZKResultMsg getVidExtChannelSelectData(@RequestParam(value="vidExtParentDeviceId", required=false) String vidExtParentDeviceId) {
        String sessionId = WebContextUtil.getCurrentSessionId();
        return new ZKResultMsg((Object)this.ivsCcStatisticsService.getVidExtChannelSelectData(vidExtParentDeviceId, sessionId));
    }

    public ZKResultMsg getVidExtDeviceSelectData() {
        String sessionId = WebContextUtil.getCurrentSessionId();
        return new ZKResultMsg((Object)this.ivsCcStatisticsService.getVidExtDeviceSelectData(sessionId));
    }

    public void export(String dataKey, String statisticsWay) {
        List itemList = this.ivsCcStatisticsService.getItemListToCache(dataKey);
        Map<String, String> map = ApiIvsCheckUtil.getColumnAndI18nByClass(IvsCcStatisticsRepItem.class);
        HashMap allMap = new HashMap();
        HashMap<String, String> tableNameMap = new HashMap<String, String>();
        HashMap<String, String> columnNameMap = new HashMap<String, String>();
        String tableName = I18nUtil.i18nCode((String)"ivs_ext_ccStatistics", (Object[])new Object[0]);
        switch (statisticsWay) {
            case "day": {
                tableName = tableName + "_" + I18nUtil.i18nCode((String)"ivs_dailyReport", (Object[])new Object[0]);
                break;
            }
            case "week": {
                tableName = tableName + "_" + I18nUtil.i18nCode((String)"ivs_weekReport", (Object[])new Object[0]);
                break;
            }
            case "month": {
                tableName = tableName + "_" + I18nUtil.i18nCode((String)"ivs_monthlyReport", (Object[])new Object[0]);
                break;
            }
            case "year": {
                tableName = tableName + "_" + I18nUtil.i18nCode((String)"ivs_yearQuarter", (Object[])new Object[0]);
                break;
            }
        }
        tableNameMap.put("tableName", tableName);
        columnNameMap.put("jsonColumn", JSONObject.toJSONString(map));
        allMap.put("tableName", tableNameMap);
        allMap.put("jsonColumn", columnNameMap);
        this.excelExport(itemList, IvsCcStatisticsRepItem.class, allMap);
    }
}

