/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsAnalyseFaceRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsAnalyseFaceService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsAnalyseFaceItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsAnalyseFaceController
extends ExportController
implements IvsAnalyseFaceRemote {
    @Autowired
    private IvsAnalyseFaceService ivsAnalyseFaceService;

    @RequiresPermissions(value={"ivs:analyseface"})
    public ModelAndView index() {
        return new ModelAndView("ivs/analyseface/ivsAnalyseFace");
    }

    @RequiresPermissions(value={"ivs:analyseface:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.ivsAnalyseFaceService.getItemById(id));
        }
        return new ModelAndView("ivs/analyseface/editHwAnalyseFace");
    }

    @RequiresPermissions(value={"ivs:analyseface:edit"})
    public ZKResultMsg save(IvsAnalyseFaceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.ivsAnalyseFaceService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(IvsAnalyseFaceItem condition) {
        Pager pager = this.ivsAnalyseFaceService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        DxGrid data = GridUtil.convert((Pager)pager, condition.getClass());
        data.getRows().forEach(item -> {
            JSONObject row = (JSONObject)item;
            if (I18nUtil.i18nCode((String)"common_failed", (Object[])new Object[0]).equals(row.getJSONArray("data").getString(1))) {
                row.put("style", (Object)"color:red");
            }
        });
        return data;
    }

    @RequiresPermissions(value={"ivs:analyseface:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.ivsAnalyseFaceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public ZKResultMsg getCountByPersonId(String personId) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        if (!StringUtils.isNotBlank((CharSequence)personId)) {
            zkResultMsg.setData((Object)0);
        }
        return zkResultMsg;
    }

    @RequiresPermissions(value={"ivs:analyseface:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        IvsAnalyseFaceItem ivsAnalyseFaceItem = new IvsAnalyseFaceItem();
        this.setConditionValue((BaseItem)ivsAnalyseFaceItem);
        List intemList = this.ivsAnalyseFaceService.getItemData(ivsAnalyseFaceItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(intemList, IvsAnalyseFaceItem.class);
    }

    public ZKResultMsg clearData() {
        return this.ivsAnalyseFaceService.clearData();
    }
}

